/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.segment.spi.memory.DataBuffer;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.memory.PinotNativeOrderLBuffer;
import org.apache.pinot.segment.spi.memory.PinotNonNativeOrderLBuffer;
import xerial.larray.buffer.LBuffer;
import xerial.larray.buffer.LBufferAPI;
import xerial.larray.mmap.MMapBuffer;

@ThreadSafe
public abstract class BasePinotLBuffer
extends PinotDataBuffer {
    protected final LBufferAPI _buffer;
    private final boolean _flushable;

    protected BasePinotLBuffer(LBufferAPI buffer, boolean closeable, boolean flushable) {
        super(closeable);
        this._buffer = buffer;
        this._flushable = flushable;
    }

    @Override
    public byte getByte(int offset) {
        return this._buffer.getByte(offset);
    }

    @Override
    public byte getByte(long offset) {
        return this._buffer.getByte(offset);
    }

    @Override
    public void putByte(int offset, byte value) {
        this._buffer.putByte(offset, value);
    }

    @Override
    public void putByte(long offset, byte value) {
        this._buffer.putByte(offset, value);
    }

    @Override
    public void copyTo(long offset, DataBuffer buffer, long destOffset, long size) {
        if (buffer instanceof BasePinotLBuffer) {
            this._buffer.copyTo(offset, ((BasePinotLBuffer)buffer)._buffer, destOffset, size);
        } else {
            super.copyTo(offset, buffer, destOffset, size);
        }
    }

    @Override
    public void readFrom(long offset, byte[] buffer, int srcOffset, int size) {
        if (size <= 10) {
            int end = srcOffset + size;
            for (int i = srcOffset; i < end; ++i) {
                this._buffer.putByte(offset++, buffer[i]);
            }
        } else {
            this._buffer.toDirectByteBuffer(offset, size).put(buffer, srcOffset, size);
        }
    }

    @Override
    public void readFrom(long offset, ByteBuffer buffer) {
        this._buffer.toDirectByteBuffer(offset, buffer.remaining()).put(buffer);
    }

    @Override
    public void readFrom(long offset, File file, long srcOffset, long size) throws IOException {
        try (FileChannel fileChannel = new RandomAccessFile(file, "r").getChannel();){
            if (size <= Integer.MAX_VALUE) {
                fileChannel.read(this._buffer.toDirectByteBuffer(offset, (int)size), srcOffset);
            } else {
                while (size > Integer.MAX_VALUE) {
                    fileChannel.read(this._buffer.toDirectByteBuffer(offset, Integer.MAX_VALUE), srcOffset);
                    offset += Integer.MAX_VALUE;
                    srcOffset += Integer.MAX_VALUE;
                    size -= Integer.MAX_VALUE;
                }
                fileChannel.read(this._buffer.toDirectByteBuffer(offset, (int)size), srcOffset);
            }
        }
    }

    @Override
    public long size() {
        if (this._buffer instanceof MMapBuffer) {
            return this._buffer.m.address() + this._buffer.m.size() - this._buffer.address();
        }
        return this._buffer.size();
    }

    @Override
    public PinotDataBuffer view(long start, long end, ByteOrder byteOrder) {
        if (byteOrder == NATIVE_ORDER) {
            return new PinotNativeOrderLBuffer((LBufferAPI)this._buffer.view(start, end), false, false);
        }
        return new PinotNonNativeOrderLBuffer((LBufferAPI)this._buffer.view(start, end), false, false);
    }

    @Override
    public ByteBuffer toDirectByteBuffer(long offset, int size, ByteOrder byteOrder) {
        return this._buffer.toDirectByteBuffer(offset, size).order(byteOrder);
    }

    @Override
    public void flush() {
        if (this._flushable) {
            ((MMapBuffer)this._buffer).flush();
        }
    }

    @Override
    public void release() throws IOException {
        if (this._buffer instanceof LBuffer) {
            this._buffer.release();
        } else if (this._buffer instanceof MMapBuffer) {
            ((MMapBuffer)this._buffer).close();
        }
    }
}

