/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.loader;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoader;
import org.apache.pinot.segment.spi.loader.SegmentLoader;
import org.apache.pinot.spi.utils.PinotReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentDirectoryLoaderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentDirectoryLoaderRegistry.class);
    public static final String DEFAULT_SEGMENT_DIRECTORY_LOADER_NAME = "default";
    private static final Map<String, SegmentDirectoryLoader> SEGMENT_DIRECTORY_LOADER_MAP = new ConcurrentHashMap<String, SegmentDirectoryLoader>();

    private SegmentDirectoryLoaderRegistry() {
    }

    public static SegmentDirectoryLoader getSegmentDirectoryLoader(String segmentDirectoryLoader) {
        return SEGMENT_DIRECTORY_LOADER_MAP.get(segmentDirectoryLoader);
    }

    public static void setSegmentDirectoryLoader(String segmentDirectoryLoaderName, SegmentDirectoryLoader loader) {
        SEGMENT_DIRECTORY_LOADER_MAP.put(segmentDirectoryLoaderName, loader);
    }

    public static SegmentDirectoryLoader getDefaultSegmentDirectoryLoader() {
        return SEGMENT_DIRECTORY_LOADER_MAP.get(DEFAULT_SEGMENT_DIRECTORY_LOADER_NAME);
    }

    static {
        long startTime = System.currentTimeMillis();
        Set loaderClasses = PinotReflectionUtils.getClassesThroughReflection((String)"org.apache.pinot.segment", (String)".*\\.loader\\..*", SegmentLoader.class);
        for (Class loaderClass : loaderClasses) {
            SegmentLoader segmentLoaderAnnotation = loaderClass.getAnnotation(SegmentLoader.class);
            if (!segmentLoaderAnnotation.enabled()) continue;
            if (segmentLoaderAnnotation.name().isEmpty()) {
                LOGGER.error("Cannot register an unnamed SegmentDirectoryLoader for annotation {} ", (Object)segmentLoaderAnnotation);
                continue;
            }
            String segmentLoaderName = segmentLoaderAnnotation.name();
            try {
                SegmentDirectoryLoader segmentDirectoryLoader = (SegmentDirectoryLoader)loaderClass.newInstance();
                SEGMENT_DIRECTORY_LOADER_MAP.putIfAbsent(segmentLoaderName, segmentDirectoryLoader);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Unable to register SegmentDirectoryLoader %s . Cannot instantiate.", segmentLoaderName), (Throwable)e);
            }
        }
        LOGGER.info("Initialized SegmentDirectoryLoaderRegistry with {} segmentDirectoryLoaders: {} in {} ms", new Object[]{SEGMENT_DIRECTORY_LOADER_MAP.size(), SEGMENT_DIRECTORY_LOADER_MAP.keySet(), System.currentTimeMillis() - startTime});
    }
}

