/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.startree;

import java.util.Comparator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.config.table.StarTreeAggregationConfig;

public class AggregationFunctionColumnPair
implements Comparable<AggregationFunctionColumnPair> {
    public static final String DELIMITER = "__";
    public static final String STAR = "*";
    public static final AggregationFunctionColumnPair COUNT_STAR = new AggregationFunctionColumnPair(AggregationFunctionType.COUNT, "*");
    private final AggregationFunctionType _functionType;
    private final String _column;

    public AggregationFunctionColumnPair(AggregationFunctionType functionType, String column) {
        this._functionType = functionType;
        this._column = functionType == AggregationFunctionType.COUNT ? STAR : column;
    }

    public AggregationFunctionType getFunctionType() {
        return this._functionType;
    }

    public String getColumn() {
        return this._column;
    }

    public String toColumnName() {
        return AggregationFunctionColumnPair.toColumnName(this._functionType, this._column);
    }

    public static String toColumnName(AggregationFunctionType functionType, String column) {
        return functionType.getName() + DELIMITER + column;
    }

    public static AggregationFunctionColumnPair fromColumnName(String columnName) {
        String[] parts = columnName.split(DELIMITER, 2);
        return AggregationFunctionColumnPair.fromFunctionAndColumnName(parts[0], parts[1]);
    }

    public static AggregationFunctionColumnPair fromAggregationConfig(StarTreeAggregationConfig aggregationConfig) {
        return AggregationFunctionColumnPair.fromFunctionAndColumnName(aggregationConfig.getAggregationFunction(), aggregationConfig.getColumnName());
    }

    public static AggregationFunctionColumnPair resolveToStoredType(AggregationFunctionColumnPair functionColumnPair) {
        AggregationFunctionType storedType = AggregationFunctionColumnPair.getStoredType(functionColumnPair.getFunctionType());
        return new AggregationFunctionColumnPair(storedType, functionColumnPair.getColumn());
    }

    public static AggregationFunctionType getStoredType(AggregationFunctionType aggregationType) {
        switch (aggregationType) {
            case DISTINCTCOUNTRAWHLL: {
                return AggregationFunctionType.DISTINCTCOUNTHLL;
            }
            case PERCENTILERAWEST: {
                return AggregationFunctionType.PERCENTILEEST;
            }
            case PERCENTILERAWTDIGEST: {
                return AggregationFunctionType.PERCENTILETDIGEST;
            }
            case DISTINCTCOUNTRAWTHETASKETCH: {
                return AggregationFunctionType.DISTINCTCOUNTTHETASKETCH;
            }
            case DISTINCTCOUNTRAWHLLPLUS: {
                return AggregationFunctionType.DISTINCTCOUNTHLLPLUS;
            }
            case DISTINCTCOUNTRAWINTEGERSUMTUPLESKETCH: 
            case AVGVALUEINTEGERSUMTUPLESKETCH: 
            case SUMVALUESINTEGERSUMTUPLESKETCH: {
                return AggregationFunctionType.DISTINCTCOUNTTUPLESKETCH;
            }
            case DISTINCTCOUNTRAWCPCSKETCH: {
                return AggregationFunctionType.DISTINCTCOUNTCPCSKETCH;
            }
            case DISTINCTCOUNTRAWULL: {
                return AggregationFunctionType.DISTINCTCOUNTULL;
            }
        }
        return aggregationType;
    }

    private static AggregationFunctionColumnPair fromFunctionAndColumnName(String functionName, String columnName) {
        AggregationFunctionType functionType = AggregationFunctionType.getAggregationFunctionType(functionName);
        if (functionType == AggregationFunctionType.COUNT) {
            return COUNT_STAR;
        }
        return new AggregationFunctionColumnPair(functionType, columnName);
    }

    public int hashCode() {
        return 31 * this._functionType.hashCode() + this._column.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AggregationFunctionColumnPair) {
            AggregationFunctionColumnPair anotherPair = (AggregationFunctionColumnPair)obj;
            return this._functionType == anotherPair._functionType && this._column.equals(anotherPair._column);
        }
        return false;
    }

    public String toString() {
        return this.toColumnName();
    }

    @Override
    public int compareTo(AggregationFunctionColumnPair other) {
        return Comparator.comparing(o -> o._column).thenComparing(o -> o._functionType).compare(this, other);
    }
}

