/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.reader;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonSerialize(converter=ToIntListConverted.class)
@JsonDeserialize(using=Deserializator.class)
public class H3IndexResolution {
    private short _resolutions;

    public H3IndexResolution(List<Integer> resolutions) {
        for (int resolution : resolutions) {
            this._resolutions = (short)(this._resolutions | 1 << resolution);
        }
    }

    public H3IndexResolution(short resolutions) {
        this._resolutions = resolutions;
    }

    public short serialize() {
        return this._resolutions;
    }

    public int size() {
        return Integer.bitCount(this._resolutions);
    }

    public List<Integer> getResolutions() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 0; i < 15; ++i) {
            if ((this._resolutions & 1 << i) == 0) continue;
            res.add(i);
        }
        return res;
    }

    @JsonIgnore
    public int getLowestResolution() {
        return Integer.numberOfTrailingZeros(this._resolutions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        H3IndexResolution that = (H3IndexResolution)o;
        return this._resolutions == that._resolutions;
    }

    public int hashCode() {
        return Objects.hash(this._resolutions);
    }

    public static class Deserializator
    extends StdDeserializer<H3IndexResolution> {
        public Deserializator() {
            super(H3IndexResolution.class);
        }

        public H3IndexResolution deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            switch (p.currentToken()) {
                case VALUE_NUMBER_INT: {
                    long longValue = p.getLongValue();
                    if (longValue > 32767L || longValue < -32768L) {
                        throw new JsonParseException(p, "Resolution value is outside the short int range");
                    }
                    return new H3IndexResolution((short)longValue);
                }
                case START_ARRAY: {
                    CollectionLikeType arrayType = ctxt.getTypeFactory().constructCollectionLikeType(List.class, Integer.class);
                    List resolutions = (List)ctxt.readValue(p, (JavaType)arrayType);
                    return new H3IndexResolution(resolutions);
                }
            }
            throw new JsonParseException(p, "Expecting number or array, but found " + p.currentToken());
        }
    }

    public static class ToIntListConverted
    extends StdConverter<H3IndexResolution, List<Integer>> {
        public List<Integer> convert(H3IndexResolution value) {
            return value.getResolutions();
        }
    }
}

