/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.creator;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.creator.RawValueBasedInvertedIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public interface CombinedInvertedIndexCreator
extends DictionaryBasedInvertedIndexCreator,
RawValueBasedInvertedIndexCreator {
    public FieldSpec.DataType getDataType();

    @Override
    default public void add(@Nonnull Object value, int dictId) {
        if (dictId >= 0) {
            this.add(dictId);
        } else {
            switch (this.getDataType()) {
                case INT: {
                    this.add((Integer)value);
                    break;
                }
                case LONG: {
                    this.add((Long)value);
                    break;
                }
                case FLOAT: {
                    this.add(((Float)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    this.add((Double)value);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported data type " + this.getDataType() + " for range index");
                }
            }
        }
    }

    @Override
    default public void add(@Nonnull Object[] values, @Nullable int[] dictIds) {
        if (dictIds != null) {
            this.add(dictIds, dictIds.length);
        } else {
            switch (this.getDataType()) {
                case INT: {
                    int[] intValues = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        intValues[i] = (Integer)values[i];
                    }
                    this.add(intValues, values.length);
                    break;
                }
                case LONG: {
                    long[] longValues = new long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        longValues[i] = (Long)values[i];
                    }
                    this.add(longValues, values.length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = new float[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        floatValues[i] = ((Float)values[i]).floatValue();
                    }
                    this.add(floatValues, values.length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        doubleValues[i] = (Double)values[i];
                    }
                    this.add(doubleValues, values.length);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported data type " + this.getDataType() + " for range index");
                }
            }
        }
    }
}

