/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.segment.spi.index.IndexPlugin;
import org.apache.pinot.segment.spi.index.IndexType;

@ThreadSafe
public class IndexService {
    private static volatile IndexService _instance = IndexService.fromServiceLoader();
    private final Set<IndexType<?, ?, ?>> _allIndexes;
    private final Map<String, IndexType<?, ?, ?>> _allIndexesById;

    private IndexService(Set<IndexPlugin<?>> allPlugins) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IndexPlugin<?> plugin : allPlugins) {
            Object indexType = plugin.getIndexType();
            builder.put((Object)indexType.getId().toLowerCase(Locale.US), indexType);
        }
        this._allIndexesById = builder.build();
        this._allIndexes = ImmutableSet.copyOf(this._allIndexesById.values());
    }

    public static IndexService getInstance() {
        return _instance;
    }

    public static void setInstance(IndexService other) {
        _instance = other;
    }

    public static IndexService fromServiceLoader() {
        HashSet pluginList = new HashSet();
        for (IndexPlugin indexPlugin : ServiceLoader.load(IndexPlugin.class)) {
            pluginList.add(indexPlugin);
        }
        return new IndexService(pluginList);
    }

    public Set<IndexType<?, ?, ?>> getAllIndexes() {
        return this._allIndexes;
    }

    public Optional<IndexType<?, ?, ?>> getOptional(String indexId) {
        return Optional.ofNullable(this._allIndexesById.get(indexId.toLowerCase(Locale.US)));
    }

    public IndexType<?, ?, ?> get(String indexId) {
        IndexType<?, ?, ?> indexType = this._allIndexesById.get(indexId.toLowerCase(Locale.US));
        if (indexType == null) {
            throw new IllegalArgumentException("Unknown index id: " + indexId);
        }
        return indexType;
    }
}

