/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.IndexConfig;

public interface IndexReaderFactory<R extends IndexReader> {
    @Nullable
    public R createIndexReader(SegmentDirectory.Reader var1, FieldIndexConfigs var2, ColumnMetadata var3) throws IOException, IndexReaderConstraintException;

    public static abstract class Default<C extends IndexConfig, R extends IndexReader>
    implements IndexReaderFactory<R> {
        protected abstract IndexType<C, R, ?> getIndexType();

        protected abstract R createIndexReader(PinotDataBuffer var1, ColumnMetadata var2, C var3) throws IOException, IndexReaderConstraintException;

        @Override
        public R createIndexReader(SegmentDirectory.Reader segmentReader, FieldIndexConfigs fieldIndexConfigs, ColumnMetadata metadata) throws IOException, IndexReaderConstraintException {
            IndexType<C, R, ?> indexType = this.getIndexType();
            if (!segmentReader.hasIndexFor(metadata.getColumnName(), indexType)) {
                return null;
            }
            PinotDataBuffer buffer = segmentReader.getIndexFor(metadata.getColumnName(), indexType);
            try {
                return this.createIndexReader(buffer, metadata, fieldIndexConfigs.getConfig(indexType));
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("Cannot read index " + indexType + " for column " + metadata.getColumnName(), ex);
            }
        }
    }
}

