/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexService;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class FieldIndexConfigsUtil {
    private FieldIndexConfigsUtil() {
    }

    public static Map<String, FieldIndexConfigs> createIndexConfigsByColName(TableConfig tableConfig, Schema schema) {
        return FieldIndexConfigsUtil.createIndexConfigsByColName(tableConfig, schema, DefaultDeserializerProvider.INSTANCE);
    }

    public static Map<String, FieldIndexConfigs> createIndexConfigsByColName(TableConfig tableConfig, Schema schema, DeserializerProvider deserializerProvider) {
        HashMap<String, FieldIndexConfigs.Builder> builderMap = new HashMap<String, FieldIndexConfigs.Builder>();
        for (String string : schema.getColumnNames()) {
            builderMap.put(string, new FieldIndexConfigs.Builder());
        }
        for (IndexType indexType : IndexService.getInstance().getAllIndexes()) {
            FieldIndexConfigsUtil.readConfig(builderMap, indexType, tableConfig, schema, deserializerProvider);
        }
        return builderMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FieldIndexConfigs.Builder)entry.getValue()).build()));
    }

    private static <C extends IndexConfig> void readConfig(Map<String, FieldIndexConfigs.Builder> builderMap, IndexType<C, ?, ?> indexType, TableConfig tableConfig, Schema schema, DeserializerProvider deserializerProvider) {
        ColumnConfigDeserializer<C> deserializer = deserializerProvider.get(indexType);
        Map<String, C> deserialize = deserializer.deserialize(tableConfig, schema);
        for (Map.Entry<String, C> entry : deserialize.entrySet()) {
            FieldIndexConfigs.Builder colBuilder = builderMap.computeIfAbsent(entry.getKey(), key -> new FieldIndexConfigs.Builder());
            colBuilder.addUnsafe(indexType, (IndexConfig)entry.getValue());
        }
    }

    public static Set<String> columnsWithIndexEnabled(IndexType<?, ?, ?> indexType, Map<String, FieldIndexConfigs> configByCol) {
        return configByCol.entrySet().stream().filter(e -> {
            Object config = ((FieldIndexConfigs)e.getValue()).getConfig(indexType);
            return config != null && config.isEnabled();
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static Set<String> columnsWithIndexDisabled(IndexType<?, ?, ?> indexType, Map<String, FieldIndexConfigs> configByCol) {
        return Sets.difference(configByCol.keySet(), FieldIndexConfigsUtil.columnsWithIndexEnabled(indexType, configByCol));
    }

    public static Set<String> columnsWithIndexDisabled(Set<String> allColumns, IndexType<?, ?, ?> indexType, Map<String, FieldIndexConfigs> configByCol) {
        return Sets.difference(allColumns, FieldIndexConfigsUtil.columnsWithIndexEnabled(indexType, configByCol));
    }

    public static <C extends IndexConfig> Map<String, C> enableConfigByColumn(IndexType<C, ?, ?> indexType, Map<String, FieldIndexConfigs> configByCol) {
        return configByCol.entrySet().stream().filter(e -> {
            Object config = ((FieldIndexConfigs)e.getValue()).getConfig(indexType);
            return config != null && config.isEnabled();
        }).collect(Collectors.toMap(Map.Entry::getKey, e -> ((FieldIndexConfigs)e.getValue()).getConfig(indexType)));
    }

    private static class DefaultDeserializerProvider
    implements DeserializerProvider {
        public static final DefaultDeserializerProvider INSTANCE = new DefaultDeserializerProvider();

        private DefaultDeserializerProvider() {
        }

        @Override
        public <C extends IndexConfig> ColumnConfigDeserializer<C> get(IndexType<C, ?, ?> indexType) {
            return indexType::getConfig;
        }
    }

    @FunctionalInterface
    public static interface DeserializerProvider {
        public <C extends IndexConfig> ColumnConfigDeserializer<C> get(IndexType<C, ?, ?> var1);
    }
}

