/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.pinot.segment.spi.index.MergedColumnConfigDeserializer;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

@FunctionalInterface
public interface ColumnConfigDeserializer<C> {
    public Map<String, C> deserialize(TableConfig var1, Schema var2);

    default public ColumnConfigDeserializer<C> withExclusiveAlternative(ColumnConfigDeserializer<C> alternative) {
        return new MergedColumnConfigDeserializer(MergedColumnConfigDeserializer.OnConflict.FAIL, this, alternative);
    }

    default public ColumnConfigDeserializer<C> withFallbackAlternative(ColumnConfigDeserializer<C> alternative) {
        return new MergedColumnConfigDeserializer(MergedColumnConfigDeserializer.OnConflict.PICK_FIRST, this, alternative);
    }

    public static <C extends IndexConfig> ColumnConfigDeserializer<C> onlyIf(Predicate<TableConfig> predicate, ColumnConfigDeserializer<C> delegate) {
        return (tableConfig, schema) -> predicate.test(tableConfig) ? delegate.deserialize(tableConfig, schema) : Collections.emptyMap();
    }
}

