/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexCreator;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.MergedColumnConfigDeserializer;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public abstract class AbstractIndexType<C extends IndexConfig, IR extends IndexReader, IC extends IndexCreator>
implements IndexType<C, IR, IC> {
    private final String _id;
    private ColumnConfigDeserializer<C> _deserializer;
    private IndexReaderFactory<IR> _readerFactory;

    protected abstract ColumnConfigDeserializer<C> createDeserializer();

    protected abstract IndexReaderFactory<IR> createReaderFactory();

    protected void handleIndexSpecificCleanup(TableConfig tableConfig) {
    }

    public AbstractIndexType(String id) {
        this._id = id;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public Map<String, C> getConfig(TableConfig tableConfig, Schema schema) {
        if (this._deserializer == null) {
            this._deserializer = this.createDeserializer();
        }
        try {
            return this._deserializer.deserialize(tableConfig, schema);
        }
        catch (MergedColumnConfigDeserializer.ConfigDeclaredTwiceException ex) {
            throw new MergedColumnConfigDeserializer.ConfigDeclaredTwiceException(ex.getColumn(), this, ex);
        }
    }

    @Override
    public IndexReaderFactory<IR> getReaderFactory() {
        if (this._readerFactory == null) {
            this._readerFactory = this.createReaderFactory();
        }
        return this._readerFactory;
    }

    @Override
    public void convertToNewFormat(TableConfig tableConfig, Schema schema) {
        Map<String, C> deserialize = this.getConfig(tableConfig, schema);
        List<FieldConfig> fieldConfigList = tableConfig.getFieldConfigList() == null ? new ArrayList() : tableConfig.getFieldConfigList();
        Map fieldConfigMap = fieldConfigList.stream().collect(Collectors.toMap(FieldConfig::getName, Function.identity()));
        for (Map.Entry<String, C> entry : deserialize.entrySet()) {
            IndexConfig configValue = (IndexConfig)entry.getValue();
            if (configValue.equals(this.getDefaultConfig())) continue;
            FieldConfig fieldConfig = (FieldConfig)fieldConfigMap.get(entry.getKey());
            if (fieldConfig != null) {
                ObjectNode currentIndexes = fieldConfig.getIndexes().isNull() ? new ObjectMapper().createObjectNode() : (ObjectNode)new ObjectMapper().valueToTree((Object)fieldConfig.getIndexes());
                JsonNode indexes = currentIndexes.set(this.getPrettyName(), configValue.toJsonNode());
                FieldConfig.Builder builder = new FieldConfig.Builder(fieldConfig);
                builder.withIndexes(indexes);
                fieldConfigList.remove(fieldConfig);
                fieldConfigList.add(builder.build());
                continue;
            }
            JsonNode indexes = new ObjectMapper().createObjectNode().set(this.getPrettyName(), configValue.toJsonNode());
            FieldConfig.Builder builder = new FieldConfig.Builder(entry.getKey());
            builder.withIndexes(indexes);
            builder.withEncodingType(FieldConfig.EncodingType.DICTIONARY);
            fieldConfigList.add(builder.build());
        }
        tableConfig.setFieldConfigList(fieldConfigList);
        this.handleIndexSpecificCleanup(tableConfig);
    }

    public String toString() {
        return this._id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractIndexType that = (AbstractIndexType)o;
        return this._id.equals(that._id);
    }

    public int hashCode() {
        return Objects.hash(this._id);
    }
}

