/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator.name;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;

public class UploadedRealtimeSegmentNameGenerator
implements SegmentNameGenerator {
    private static final String DELIMITER = "__";
    private final String _tableName;
    private final int _partitionId;
    private final long _creationTimeMillis;
    private final String _prefix;
    @Nullable
    private final String _suffix;

    public UploadedRealtimeSegmentNameGenerator(String tableName, int partitionId, long creationTimeMillis, String prefix, @Nullable String suffix) {
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)tableName) && !tableName.contains(DELIMITER) && StringUtils.isNotBlank((CharSequence)prefix) && !prefix.contains(DELIMITER) ? 1 : 0) != 0, (Object)"Invalid tableName or prefix for UploadedRealtimeSegmentNameGenerator");
        Preconditions.checkArgument((creationTimeMillis > 0L ? 1 : 0) != 0, (Object)"Creation time must be greater than 0");
        if (suffix != null) {
            Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)suffix) && !suffix.contains(DELIMITER) ? 1 : 0) != 0, (Object)"Invalid suffix for UploadedRealtimeSegmentNameGenerator");
        }
        this._tableName = tableName;
        this._partitionId = partitionId;
        this._creationTimeMillis = creationTimeMillis;
        this._prefix = prefix;
        this._suffix = suffix;
    }

    @Override
    public String generateSegmentName(int sequenceId, @Nullable Object minTimeValue, @Nullable Object maxTimeValue) {
        return Joiner.on((String)DELIMITER).join((Object)this._prefix, (Object)this._tableName, new Object[]{this._partitionId, this._creationTimeMillis, StringUtils.isBlank((CharSequence)this._suffix) ? Integer.valueOf(sequenceId) : this._suffix});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("UploadedRealtimeSegmentNameGenerator: tableName=").append(this._tableName);
        stringBuilder.append(", prefix=").append(this._prefix);
        stringBuilder.append(", partitionId=").append(this._partitionId);
        if (this._suffix != null) {
            stringBuilder.append(", suffix=").append(this._suffix);
        }
        stringBuilder.append(", creationTimeMillis=").append(this._creationTimeMillis);
        return stringBuilder.toString();
    }
}

