/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.partition.PartitionFunction;

public class ColumnIndexCreationInfo
implements Serializable {
    private final boolean _createDictionary;
    private final boolean _useVarLengthDictionary;
    private final boolean _isAutoGenerated;
    private final Object _defaultNullValue;
    private final ColumnStatistics _columnStatistics;

    public ColumnIndexCreationInfo(ColumnStatistics columnStatistics, boolean createDictionary, boolean useVarLengthDictionary, boolean isAutoGenerated, Object defaultNullValue) {
        this._columnStatistics = columnStatistics;
        this._createDictionary = createDictionary;
        this._useVarLengthDictionary = useVarLengthDictionary;
        this._isAutoGenerated = isAutoGenerated;
        this._defaultNullValue = defaultNullValue;
    }

    public ColumnStatistics getColumnStatistics() {
        return this._columnStatistics;
    }

    public boolean isCreateDictionary() {
        return this._createDictionary;
    }

    public boolean isUseVarLengthDictionary() {
        return this._useVarLengthDictionary;
    }

    public Object getMin() {
        return this._columnStatistics.getMinValue();
    }

    public Object getMax() {
        return this._columnStatistics.getMaxValue();
    }

    public Object getSortedUniqueElementsArray() {
        return this._columnStatistics.getUniqueValuesSet();
    }

    public int getDistinctValueCount() {
        Object uniqueValArray = this._columnStatistics.getUniqueValuesSet();
        if (uniqueValArray == null) {
            return Integer.MIN_VALUE;
        }
        return ArrayUtils.getLength((Object)uniqueValArray);
    }

    public boolean isSorted() {
        return this._columnStatistics.isSorted();
    }

    public int getTotalNumberOfEntries() {
        return this._columnStatistics.getTotalNumberOfEntries();
    }

    public int getMaxNumberOfMultiValueElements() {
        return this._columnStatistics.getMaxNumberOfMultiValues();
    }

    public int getMaxRowLengthInBytes() {
        return this._columnStatistics.getMaxRowLengthInBytes();
    }

    public boolean isAutoGenerated() {
        return this._isAutoGenerated;
    }

    public Object getDefaultNullValue() {
        return this._defaultNullValue;
    }

    public int getLengthOfLongestEntry() {
        return this._columnStatistics.getLengthOfLargestElement();
    }

    public Set<Integer> getPartitions() {
        return this._columnStatistics.getPartitions();
    }

    public PartitionFunction getPartitionFunction() {
        return this._columnStatistics.getPartitionFunction();
    }

    public int getNumPartitions() {
        return this._columnStatistics.getNumPartitions();
    }

    public boolean isFixedLength() {
        return this._columnStatistics.isFixedLength();
    }

    @Nullable
    public Map<String, String> getPartitionFunctionConfig() {
        return this._columnStatistics.getPartitionFunctionConfig();
    }
}

