/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.StringUtils;

public enum AggregationFunctionType {
    COUNT("count", null, SqlKind.COUNT, SqlFunctionCategory.NUMERIC, OperandTypes.ONE_OR_MORE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.BIGINT), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.BIGINT)),
    MIN("min", null, SqlKind.MIN, SqlFunctionCategory.SYSTEM, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.ARG0_NULLABLE_IF_EMPTY, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE)),
    MAX("max", null, SqlKind.MAX, SqlFunctionCategory.SYSTEM, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.ARG0_NULLABLE_IF_EMPTY, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE)),
    SUM("sum", null, SqlKind.SUM, SqlFunctionCategory.NUMERIC, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.AGG_SUM, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE)),
    SUM0("$sum0", null, SqlKind.SUM0, SqlFunctionCategory.NUMERIC, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.AGG_SUM_EMPTY_IS_ZERO, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE)),
    SUMPRECISION("sumPrecision", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.ANY, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DECIMAL), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    AVG("avg"),
    MODE("mode"),
    FIRSTWITHTIME("firstWithTime", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.TIMESTAMP, (Object)SqlTypeFamily.CHARACTER)), OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.CHARACTER))}), ReturnTypes.ARG0, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    LASTWITHTIME("lastWithTime", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.TIMESTAMP, (Object)SqlTypeFamily.CHARACTER)), OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.CHARACTER))}), ReturnTypes.ARG0, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    MINMAXRANGE("minMaxRange", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.NUMERIC, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.ARG0, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNT("distinctCount", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.ANY, ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTBITMAP("distinctCountBitmap", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_BITMAP"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.ANY, ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    SEGMENTPARTITIONEDDISTINCTCOUNT("segmentPartitionedDistinctCount", (List<String>)ImmutableList.of((Object)"SEGMENT_PARTITIONED_DISTINCT_COUNT"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.ANY, ReturnTypes.BIGINT, ReturnTypes.BIGINT),
    DISTINCTCOUNTHLL("distinctCountHLL", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_HLL"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.NUMERIC), ordinal -> ordinal > 0), ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTRAWHLL("distinctCountRawHLL", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_RAW_HLL"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.INTEGER), ordinal -> ordinal > 0), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTSMARTHLL("distinctCountSmartHLL", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_SMART_HLL"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 0), ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    FASTHLL("fastHLL"),
    DISTINCTCOUNTTHETASKETCH("distinctCountThetaSketch", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 0), ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTRAWTHETASKETCH("distinctCountRawThetaSketch", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 0), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTSUM("distinctSum", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.NUMERIC, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.AGG_SUM, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTAVG("distinctAvg", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.NUMERIC, (SqlOperandTypeChecker)OperandTypes.NUMERIC, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILE("percentile", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.ARG0, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILEEST("percentileEst", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.ARG0, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILERAWEST("percentileRawEst", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILETDIGEST("percentileTDigest", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.ARG0, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILERAWTDIGEST("percentileRawTDigest", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILESMARTTDIGEST("percentileSmartTDigest"),
    PERCENTILEKLL("percentileKLL", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.ARG0, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILERAWKLL("percentileRawKLL", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTHLLPLUS("distinctCountHLLPlus", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_HLL_PLUS"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.NUMERIC), ordinal -> ordinal > 0), ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTRAWHLLPLUS("distinctCountRawHLLPlus", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_RAW_HLL_PLUS"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.INTEGER), ordinal -> ordinal > 0), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTULL("distinctCountULL", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_ULL"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.NUMERIC), ordinal -> ordinal > 0), ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTRAWULL("distinctCountRawULL", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_RAW_ULL"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.NUMERIC), ordinal -> ordinal > 0), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    IDSET("idSet"),
    HISTOGRAM("histogram"),
    COVARPOP("covarPop", Collections.emptyList(), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    COVARSAMP("covarSamp", Collections.emptyList(), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    VARPOP("varPop", Collections.emptyList(), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    VARSAMP("varSamp", Collections.emptyList(), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    STDDEVPOP("stdDevPop", Collections.emptyList(), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    STDDEVSAMP("stdDevSamp", Collections.emptyList(), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    SKEWNESS("skewness", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    KURTOSIS("kurtosis", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.NUMERIC, ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    FOURTHMOMENT("fourthMoment"),
    DISTINCTCOUNTTUPLESKETCH("distinctCountTupleSketch", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_TUPLE_SKETCH"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.BINARY, ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTRAWINTEGERSUMTUPLESKETCH("distinctCountRawIntegerSumTupleSketch", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_RAW_INTEGER_SUM_TUPLE_SKETCH"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.BINARY, ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    SUMVALUESINTEGERSUMTUPLESKETCH("sumValuesIntegerSumTupleSketch", (List<String>)ImmutableList.of((Object)"SUM_VALUES_INTEGER_SUM_TUPLE_SKETCH"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.BINARY, ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    AVGVALUEINTEGERSUMTUPLESKETCH("avgValueIntegerSumTupleSketch", (List<String>)ImmutableList.of((Object)"AVG_VALUE_INTEGER_SUM_TUPLE_SKETCH"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.BINARY, ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    FREQUENTSTRINGSSKETCH("frequentStringsSketch"),
    FREQUENTLONGSSKETCH("frequentLongsSketch"),
    DISTINCTCOUNTCPCSKETCH("distinctCountCPCSketch", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_CPC_SKETCH"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 0), ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTRAWCPCSKETCH("distinctCountRawCPCSketch", (List<String>)ImmutableList.of((Object)"DISTINCT_COUNT_RAW_CPC_SKETCH"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 0), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    STUNION("STUnion", (List<String>)ImmutableList.of((Object)"ST_UNION"), SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.BINARY, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARBINARY), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    COUNTMV("countMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.BIGINT), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.BIGINT)),
    MINMV("minMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE)),
    MAXMV("maxMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE)),
    SUMMV("sumMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE)),
    AVGMV("avgMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    MINMAXRANGEMV("minMaxRangeMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTMV("distinctCountMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTBITMAPMV("distinctCountBitmapMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTHLLMV("distinctCountHLLMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTRAWHLLMV("distinctCountRawHLLMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTSUMMV("distinctSumMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTAVGMV("distinctAvgMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILEMV("percentileMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILEESTMV("percentileEstMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILERAWESTMV("percentileRawEstMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILETDIGESTMV("percentileTDigestMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILERAWTDIGESTMV("percentileRawTDigestMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.NUMERIC)), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILEKLLMV("percentileKLLMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC), ordinal -> ordinal > 1 && ordinal < 4), ReturnTypes.DOUBLE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PERCENTILERAWKLLMV("percentileRawKLLMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC), ordinal -> ordinal > 1 && ordinal < 4), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTHLLPLUSMV("distinctCountHLLPlusMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    DISTINCTCOUNTRAWHLLPLUSMV("distinctCountRawHLLPlusMV", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ReturnTypes.VARCHAR_2000, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    BOOLAND("boolAnd", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.BOOLEAN, ReturnTypes.BOOLEAN, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.INTEGER)),
    BOOLOR("boolOr", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.BOOLEAN, ReturnTypes.BOOLEAN, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.INTEGER)),
    EXPRMIN("exprMin", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY), ordinal -> ordinal > 1), ReturnTypes.ARG0, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    EXPRMAX("exprMax", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY), ordinal -> ordinal > 1), ReturnTypes.ARG0, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PINOTPARENTAGGEXPRMIN("pinotparentagg" + EXPRMIN.getName(), null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.ANY), ordinal -> ordinal > 2), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PINOTPARENTAGGEXPRMAX("pinotparentagg" + EXPRMAX.getName(), null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.ANY), ordinal -> ordinal > 2), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PINOTCHILDAGGEXPRMIN("pinotchildagg" + EXPRMIN.getName(), null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.ANY), ordinal -> ordinal > 3), ReturnTypes.ARG1, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    PINOTCHILDAGGEXPRMAX("pinotchildagg" + EXPRMAX.getName(), null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.ANY), ordinal -> ordinal > 3), ReturnTypes.ARG1, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    ARRAYAGG("arrayAgg", null, SqlKind.ARRAY_AGG, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.BOOLEAN), ordinal -> ordinal > 1), ReturnTypes.TO_ARRAY, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    LISTAGG("listAgg", null, SqlKind.LISTAGG, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.BOOLEAN), ordinal -> ordinal > 1), ReturnTypes.VARCHAR, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    SUMARRAYLONG("sumArrayLong", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ArrayReturnTypeInference.forType(SqlTypeName.BIGINT), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    SUMARRAYDOUBLE("sumArrayDouble", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), ArrayReturnTypeInference.forType(SqlTypeName.DOUBLE), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    FUNNELMAXSTEP("funnelMaxStep", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, OperandTypes.VARIADIC, ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    FUNNELCOMPLETECOUNT("funnelCompleteCount", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, OperandTypes.VARIADIC, ReturnTypes.BIGINT, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    FUNNELMATCHSTEP("funnelMatchStep", null, SqlKind.OTHER_FUNCTION, SqlFunctionCategory.USER_DEFINED_FUNCTION, OperandTypes.VARIADIC, ArrayReturnTypeInference.INT_ARRAY_RETURN_TYPE_INFERENCE, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER)),
    FUNNELCOUNT("funnelCount");

    private static final Set<String> NAMES;
    private final String _name;
    private final List<String> _alternativeNames;
    private final SqlKind _sqlKind;
    private final SqlFunctionCategory _sqlFunctionCategory;
    private final SqlReturnTypeInference _returnTypeInference;
    private final SqlOperandTypeChecker _operandTypeChecker;
    private final SqlReturnTypeInference _intermediateReturnTypeInference;

    private AggregationFunctionType(String name) {
        this(name, null, null, null);
    }

    private AggregationFunctionType(String name, List<String> alternativeNames, SqlKind sqlKind, SqlFunctionCategory sqlFunctionCategory) {
        this(name, alternativeNames, sqlKind, sqlFunctionCategory, null, null, null);
    }

    private AggregationFunctionType(@Nullable String name, @Nullable List<String> alternativeNames, @Nullable SqlKind sqlKind, @Nullable SqlFunctionCategory sqlFunctionCategory, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlReturnTypeInference finalReturnType, SqlReturnTypeInference intermediateReturnType) {
        this._name = name;
        this._alternativeNames = alternativeNames == null ? Collections.singletonList(AggregationFunctionType.getUnderscoreSplitAggregationFunctionName(this._name)) : alternativeNames;
        this._sqlKind = sqlKind;
        this._sqlFunctionCategory = sqlFunctionCategory;
        this._returnTypeInference = finalReturnType;
        this._operandTypeChecker = operandTypeChecker;
        this._intermediateReturnTypeInference = intermediateReturnType == null ? this._returnTypeInference : intermediateReturnType;
    }

    public String getName() {
        return this._name;
    }

    public List<String> getAlternativeNames() {
        return this._alternativeNames;
    }

    public SqlKind getSqlKind() {
        return this._sqlKind;
    }

    public SqlReturnTypeInference getIntermediateReturnTypeInference() {
        return this._intermediateReturnTypeInference;
    }

    public SqlReturnTypeInference getReturnTypeInference() {
        return this._returnTypeInference;
    }

    public SqlOperandTypeChecker getOperandTypeChecker() {
        return this._operandTypeChecker;
    }

    public SqlFunctionCategory getSqlFunctionCategory() {
        return this._sqlFunctionCategory;
    }

    public static boolean isAggregationFunction(String functionName) {
        if (NAMES.contains(functionName)) {
            return true;
        }
        if (functionName.regionMatches(true, 0, "percentile", 0, 10)) {
            try {
                AggregationFunctionType.getAggregationFunctionType(functionName);
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        }
        String upperCaseFunctionName = AggregationFunctionType.getNormalizedAggregationFunctionName(functionName);
        return NAMES.contains(upperCaseFunctionName);
    }

    public static String getNormalizedAggregationFunctionName(String functionName) {
        return StringUtils.remove((String)StringUtils.remove((String)functionName, (char)'_').toUpperCase(), (String)"$");
    }

    public static String getUnderscoreSplitAggregationFunctionName(String functionName) {
        return functionName.matches(".*\\d.*") ? functionName : functionName.replaceAll("(.)(\\p{Upper}+|\\d+)", "$1_$2");
    }

    public static AggregationFunctionType getAggregationFunctionType(String functionName) {
        String normalizedFunctionName = AggregationFunctionType.getNormalizedAggregationFunctionName(functionName);
        if (normalizedFunctionName.regionMatches(false, 0, "PERCENTILE", 0, 10)) {
            String remainingFunctionName = normalizedFunctionName.substring(10).toUpperCase();
            if (remainingFunctionName.isEmpty() || remainingFunctionName.matches("\\d+")) {
                return PERCENTILE;
            }
            if (remainingFunctionName.equals("EST") || remainingFunctionName.matches("EST\\d+")) {
                return PERCENTILEEST;
            }
            if (remainingFunctionName.equals("RAWEST") || remainingFunctionName.matches("RAWEST\\d+")) {
                return PERCENTILERAWEST;
            }
            if (remainingFunctionName.equals("TDIGEST") || remainingFunctionName.matches("TDIGEST\\d+")) {
                return PERCENTILETDIGEST;
            }
            if (remainingFunctionName.equals("RAWTDIGEST") || remainingFunctionName.matches("RAWTDIGEST\\d+")) {
                return PERCENTILERAWTDIGEST;
            }
            if (remainingFunctionName.equals("KLL") || remainingFunctionName.matches("KLL\\d+")) {
                return PERCENTILEKLL;
            }
            if (remainingFunctionName.equals("RAWKLL") || remainingFunctionName.matches("RAWKLL\\d+")) {
                return PERCENTILERAWKLL;
            }
            if (remainingFunctionName.equals("MV") || remainingFunctionName.matches("\\d+MV")) {
                return PERCENTILEMV;
            }
            if (remainingFunctionName.equals("ESTMV") || remainingFunctionName.matches("EST\\d+MV")) {
                return PERCENTILEESTMV;
            }
            if (remainingFunctionName.equals("RAWESTMV") || remainingFunctionName.matches("RAWEST\\d+MV")) {
                return PERCENTILERAWESTMV;
            }
            if (remainingFunctionName.equals("TDIGESTMV") || remainingFunctionName.matches("TDIGEST\\d+MV")) {
                return PERCENTILETDIGESTMV;
            }
            if (remainingFunctionName.equals("RAWTDIGESTMV") || remainingFunctionName.matches("RAWTDIGEST\\d+MV")) {
                return PERCENTILERAWTDIGESTMV;
            }
            if (remainingFunctionName.equals("KLLMV") || remainingFunctionName.matches("KLL\\d+MV")) {
                return PERCENTILEKLLMV;
            }
            if (remainingFunctionName.equals("RAWKLLMV") || remainingFunctionName.matches("RAWKLL\\d+MV")) {
                return PERCENTILEKLLMV;
            }
            throw new IllegalArgumentException("Invalid aggregation function name: " + functionName);
        }
        try {
            return AggregationFunctionType.valueOf(normalizedFunctionName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid aggregation function name: " + functionName);
        }
    }

    static {
        NAMES = Arrays.stream(AggregationFunctionType.values()).flatMap(func -> Stream.of(func.name(), func.getName(), func.getName().toLowerCase())).collect(Collectors.toSet());
    }

    static class ArrayReturnTypeInference
    implements SqlReturnTypeInference {
        static final ArrayReturnTypeInference INT_ARRAY_RETURN_TYPE_INFERENCE = ArrayReturnTypeInference.forType(SqlTypeName.INTEGER);
        private final SqlTypeName _sqlTypeName;

        ArrayReturnTypeInference(SqlTypeName sqlTypeName) {
            this._sqlTypeName = sqlTypeName;
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType elementType = typeFactory.createSqlType(this._sqlTypeName);
            return typeFactory.createArrayType(elementType, -1L);
        }

        static ArrayReturnTypeInference forType(SqlTypeName sqlTypeName) {
            return new ArrayReturnTypeInference(sqlTypeName);
        }
    }
}

