/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.utils.config.TagNameUtils;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.segment.local.recordtransformer.SchemaConformingTransformer;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.DictionaryIndexConfig;
import org.apache.pinot.segment.spi.index.IndexService;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.QuotaConfig;
import org.apache.pinot.spi.config.table.RoutingConfig;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.StarTreeAggregationConfig;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.TenantConfig;
import org.apache.pinot.spi.config.table.TierConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceAssignmentConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.config.table.ingestion.AggregationConfig;
import org.apache.pinot.spi.config.table.ingestion.BatchIngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.ComplexTypeConfig;
import org.apache.pinot.spi.config.table.ingestion.EnrichmentConfig;
import org.apache.pinot.spi.config.table.ingestion.FilterConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.SchemaConformingTransformerConfig;
import org.apache.pinot.spi.config.table.ingestion.StreamIngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.ingestion.batch.BatchConfig;
import org.apache.pinot.spi.recordtransformer.enricher.RecordEnricherRegistry;
import org.apache.pinot.spi.recordtransformer.enricher.RecordEnricherValidationConfig;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.utils.DataSizeUtils;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.TimeUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableConfigUtils.class);
    private static final String STAR_TREE_CONFIG_NAME = "StarTreeIndex Config";
    private static final String UPSERT_COMPACTION_TASK_TYPE = "UpsertCompactionTask";
    private static final String UPSERT_COMPACT_MERGE_TASK_TYPE = "UpsertCompactMergeTask";
    private static final String KINESIS_STREAM_TYPE = "kinesis";
    private static final EnumSet<AggregationFunctionType> SUPPORTED_INGESTION_AGGREGATIONS = EnumSet.of(AggregationFunctionType.SUM, new AggregationFunctionType[]{AggregationFunctionType.MIN, AggregationFunctionType.MAX, AggregationFunctionType.COUNT, AggregationFunctionType.DISTINCTCOUNTHLL, AggregationFunctionType.SUMPRECISION, AggregationFunctionType.DISTINCTCOUNTHLLPLUS});
    private static final Set<String> UPSERT_DEDUP_ALLOWED_ROUTING_STRATEGIES = ImmutableSet.of((Object)"strictReplicaGroup", (Object)"multiStageReplicaGroup");
    private static boolean _disableGroovy;
    private static boolean _enforcePoolBasedAssignment;

    private TableConfigUtils() {
    }

    public static void setDisableGroovy(boolean disableGroovy) {
        _disableGroovy = disableGroovy;
    }

    public static void setEnforcePoolBasedAssignment(boolean enforcePoolBasedAssignment) {
        _enforcePoolBasedAssignment = enforcePoolBasedAssignment;
    }

    public static void validate(TableConfig tableConfig, @Nullable Schema schema) {
        TableConfigUtils.validate(tableConfig, schema, null);
    }

    public static void validate(TableConfig tableConfig, @Nullable Schema schema, @Nullable String typesToSkip) {
        Set<ValidationType> skipTypes = TableConfigUtils.parseTypesToSkipString(typesToSkip);
        if (tableConfig.getTableType() == TableType.REALTIME) {
            Preconditions.checkState((schema != null ? 1 : 0) != 0, (Object)"Schema should not be null for REALTIME table");
        }
        TableConfigUtils.sanitize(tableConfig);
        if (!skipTypes.contains((Object)ValidationType.ALL)) {
            TableConfigUtils.validateTableSchemaConfig(tableConfig);
            TableConfigUtils.validateValidationConfig(tableConfig, schema);
            TableConfigUtils.validateIngestionConfig(tableConfig, schema);
            if (tableConfig.getTableType() == TableType.REALTIME) {
                List streamConfigMaps = IngestionConfigUtils.getStreamConfigMaps((TableConfig)tableConfig);
                if (streamConfigMaps.size() > 1) {
                    Preconditions.checkArgument((!tableConfig.isUpsertEnabled() ? 1 : 0) != 0, (Object)"Multiple stream configs are not supported for upsert tables");
                }
                for (Map streamConfigMap : streamConfigMaps) {
                    StreamConfig streamConfig;
                    try {
                        streamConfig = new StreamConfig(tableConfig.getTableName(), streamConfigMap);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Could not create StreamConfig using the streamConfig map", e);
                    }
                    TableConfigUtils.validateStreamConfig(streamConfig);
                }
            }
            TableConfigUtils.validateTierConfigList(tableConfig.getTierConfigsList());
            TableConfigUtils.validateIndexingConfig(tableConfig.getIndexingConfig(), schema);
            TableConfigUtils.validateFieldConfigList(tableConfig, schema);
            TableConfigUtils.validateInstancePartitionsTypeMapConfig(tableConfig);
            TableConfigUtils.validatePartitionedReplicaGroupInstance(tableConfig);
            if (!skipTypes.contains((Object)ValidationType.UPSERT)) {
                TableConfigUtils.validateUpsertAndDedupConfig(tableConfig, schema);
                TableConfigUtils.validatePartialUpsertStrategies(tableConfig, schema);
            }
            if (_enforcePoolBasedAssignment) {
                TableConfigUtils.validateInstancePoolsNReplicaGroups(tableConfig);
            }
        }
    }

    static boolean isTableUsingInstancePoolAndReplicaGroup(@Nonnull TableConfig tableConfig) {
        boolean status = true;
        Map instanceAssignmentConfigMap = tableConfig.getInstanceAssignmentConfigMap();
        if (instanceAssignmentConfigMap != null) {
            for (InstanceAssignmentConfig instanceAssignmentConfig : instanceAssignmentConfigMap.values()) {
                if (instanceAssignmentConfig != null) {
                    status &= instanceAssignmentConfig.getTagPoolConfig().isPoolBased() && instanceAssignmentConfig.getReplicaGroupPartitionConfig().isReplicaGroupBased();
                    continue;
                }
                status = false;
            }
        } else {
            status = false;
        }
        return status;
    }

    public static void validateInstancePoolsNReplicaGroups(TableConfig tableConfig) {
        Preconditions.checkState((boolean)TableConfigUtils.isTableUsingInstancePoolAndReplicaGroup(tableConfig), (Object)"Instance pool and replica group configurations must be enabled");
    }

    private static Set<ValidationType> parseTypesToSkipString(@Nullable String typesToSkip) {
        return typesToSkip == null ? Collections.emptySet() : Arrays.stream(typesToSkip.split(",")).map(s -> ValidationType.valueOf(s.toUpperCase())).collect(Collectors.toSet());
    }

    public static void validateTableName(TableConfig tableConfig) {
        String tableName = tableConfig.getTableName();
        int dotCount = StringUtils.countMatches((CharSequence)tableName, (char)'.');
        if (dotCount > 1) {
            throw new IllegalStateException("Table name: '" + tableName + "' containing more than one '.' is not allowed");
        }
        if (StringUtils.containsWhitespace((CharSequence)tableName)) {
            throw new IllegalStateException("Table name: '" + tableName + "' containing space is not allowed");
        }
    }

    private static void validateTableSchemaConfig(TableConfig tableConfig) {
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableConfig.getTableName());
        String schemaName = tableConfig.getValidationConfig().getSchemaName();
        if (schemaName != null && !schemaName.equals(rawTableName)) {
            throw new IllegalStateException("Schema name: " + schemaName + " does not match table name: " + rawTableName);
        }
    }

    private static void validateRetentionConfig(TableConfig tableConfig) {
        SegmentsValidationAndRetentionConfig segmentsConfig = tableConfig.getValidationConfig();
        String tableName = tableConfig.getTableName();
        if (segmentsConfig == null) {
            throw new IllegalStateException(String.format("Table: %s, \"segmentsConfig\" field is missing in table config", tableName));
        }
        String segmentPushType = IngestionConfigUtils.getBatchSegmentIngestionType((TableConfig)tableConfig);
        if (!(tableConfig.getTableType() != TableType.OFFLINE || segmentPushType == null || segmentPushType.isEmpty() || segmentPushType.equalsIgnoreCase("REFRESH") || segmentPushType.equalsIgnoreCase("APPEND"))) {
            throw new IllegalStateException(String.format("Table: %s, invalid push type: %s", tableName, segmentPushType));
        }
        String timeUnitString = segmentsConfig.getRetentionTimeUnit();
        if (timeUnitString == null || timeUnitString.isEmpty()) {
            return;
        }
        try {
            TimeUnit.valueOf(timeUnitString.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Table: %s, invalid time unit: %s", tableName, timeUnitString));
        }
    }

    private static void validateValidationConfig(TableConfig tableConfig, @Nullable Schema schema) {
        String peerSegmentDownloadScheme;
        SegmentsValidationAndRetentionConfig validationConfig = tableConfig.getValidationConfig();
        String timeColumnName = validationConfig.getTimeColumnName();
        if (tableConfig.getTableType() == TableType.REALTIME) {
            Preconditions.checkState((timeColumnName != null ? 1 : 0) != 0, (Object)"'timeColumnName' cannot be null in REALTIME table config");
        }
        if (timeColumnName != null && !timeColumnName.isEmpty() && schema != null) {
            Preconditions.checkState((schema.getSpecForTimeColumn(timeColumnName) != null ? 1 : 0) != 0, (String)"Cannot find valid fieldSpec for timeColumn: %s from the table config: %s, in the schema: %s", (Object)timeColumnName, (Object)tableConfig.getTableName(), (Object)schema.getSchemaName());
        }
        if (tableConfig.isDimTable()) {
            Preconditions.checkState((tableConfig.getTableType() == TableType.OFFLINE ? 1 : 0) != 0, (Object)"Dimension table must be of OFFLINE table type.");
            Preconditions.checkState((schema != null ? 1 : 0) != 0, (Object)"Dimension table must have an associated schema");
            Preconditions.checkState((!schema.getPrimaryKeyColumns().isEmpty() ? 1 : 0) != 0, (Object)"Dimension table must have primary key[s]");
        }
        if ((peerSegmentDownloadScheme = validationConfig.getPeerSegmentDownloadScheme()) != null) {
            if (!"http".equalsIgnoreCase(peerSegmentDownloadScheme) && !"https".equalsIgnoreCase(peerSegmentDownloadScheme)) {
                throw new IllegalStateException("Invalid value '" + peerSegmentDownloadScheme + "' for peerSegmentDownloadScheme. Must be one of http or https");
            }
            if (tableConfig.getReplication() < 2) {
                throw new IllegalStateException("peerSegmentDownloadScheme can't be used when replication is < 2");
            }
        }
        TableConfigUtils.validateRetentionConfig(tableConfig);
    }

    @VisibleForTesting
    public static void validateIngestionConfig(TableConfig tableConfig, @Nullable Schema schema) {
        IngestionConfig ingestionConfig = tableConfig.getIngestionConfig();
        if (ingestionConfig != null) {
            SchemaConformingTransformerConfig schemaConformingTransformerConfig;
            Map prefixesToRename;
            ComplexTypeConfig complexTypeConfig;
            List transformConfigs;
            List enrichmentConfigs;
            String filterFunction;
            FilterConfig filterConfig;
            String tableNameWithType = tableConfig.getTableName();
            if (ingestionConfig.getBatchIngestionConfig() != null) {
                BatchIngestionConfig cfg = ingestionConfig.getBatchIngestionConfig();
                List batchConfigMaps = cfg.getBatchConfigMaps();
                try {
                    if (CollectionUtils.isNotEmpty((Collection)batchConfigMaps)) {
                        batchConfigMaps.forEach(b -> new BatchConfig(tableNameWithType, b));
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not create BatchConfig using the batchConfig map", e);
                }
                if (tableConfig.isDimTable()) {
                    Preconditions.checkState((boolean)cfg.getSegmentIngestionType().equalsIgnoreCase("REFRESH"), (Object)"Dimension tables must have segment ingestion type REFRESH");
                }
            }
            if (tableConfig.isDimTable()) {
                Preconditions.checkState((ingestionConfig.getBatchIngestionConfig() != null ? 1 : 0) != 0, (Object)"Dimension tables must have batch ingestion configuration");
            }
            if (ingestionConfig.getStreamIngestionConfig() != null) {
                IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
                Preconditions.checkState((indexingConfig == null || MapUtils.isEmpty((Map)indexingConfig.getStreamConfigs()) ? 1 : 0) != 0, (Object)"Should not use indexingConfig#getStreamConfigs if ingestionConfig#StreamIngestionConfig is provided");
                List streamConfigMaps = ingestionConfig.getStreamIngestionConfig().getStreamConfigMaps();
                Preconditions.checkState((streamConfigMaps.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 stream in REALTIME table");
            }
            if ((filterConfig = ingestionConfig.getFilterConfig()) != null && (filterFunction = filterConfig.getFilterFunction()) != null) {
                if (_disableGroovy && FunctionEvaluatorFactory.isGroovyExpression(filterFunction)) {
                    throw new IllegalStateException("Groovy filter functions are disabled for table config. Found '" + filterFunction + "'");
                }
                try {
                    FunctionEvaluatorFactory.getExpressionEvaluator(filterFunction);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Invalid filter function " + filterFunction, e);
                }
            }
            List aggregationConfigs = ingestionConfig.getAggregationConfigs();
            HashSet<String> aggregationSourceColumns = new HashSet<String>();
            if (!CollectionUtils.isEmpty((Collection)aggregationConfigs)) {
                Preconditions.checkState((!tableConfig.getIndexingConfig().isAggregateMetrics() ? 1 : 0) != 0, (Object)"aggregateMetrics cannot be set with AggregationConfig");
                HashSet<Object> aggregationColumns = new HashSet<Object>();
                for (AggregationConfig aggregationConfig : aggregationConfigs) {
                    ExpressionContext firstArgument;
                    FieldSpec.DataType dataType;
                    String literal;
                    ExpressionContext secondArgument;
                    ExpressionContext expressionContext;
                    String columnName = aggregationConfig.getColumnName();
                    String aggregationFunction = aggregationConfig.getAggregationFunction();
                    if (columnName == null || aggregationFunction == null) {
                        throw new IllegalStateException("columnName/aggregationFunction cannot be null in AggregationConfig " + aggregationConfig);
                    }
                    FieldSpec fieldSpec = null;
                    if (schema != null) {
                        fieldSpec = schema.getFieldSpecFor(columnName);
                        Preconditions.checkState((fieldSpec != null ? 1 : 0) != 0, (Object)("The destination column '" + (String)columnName + "' of the aggregation function must be present in the schema"));
                        Preconditions.checkState((fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC ? 1 : 0) != 0, (Object)("The destination column '" + (String)columnName + "' of the aggregation function must be a metric column"));
                    }
                    if (!aggregationColumns.add(columnName)) {
                        throw new IllegalStateException("Duplicate aggregation config found for column '" + (String)columnName + "'");
                    }
                    try {
                        expressionContext = RequestContextUtils.getExpression((String)aggregationConfig.getAggregationFunction());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Invalid aggregation function '" + aggregationFunction + "' for column '" + (String)columnName + "'", e);
                    }
                    Preconditions.checkState((expressionContext.getType() == ExpressionContext.Type.FUNCTION ? 1 : 0) != 0, (String)"aggregation function must be a function for: %s", (Object)aggregationConfig);
                    FunctionContext functionContext = expressionContext.getFunction();
                    AggregationFunctionType functionType = AggregationFunctionType.getAggregationFunctionType((String)functionContext.getFunctionName());
                    TableConfigUtils.validateIngestionAggregation(functionType);
                    List arguments = functionContext.getArguments();
                    int numArguments = arguments.size();
                    if (functionType == AggregationFunctionType.DISTINCTCOUNTHLL) {
                        Preconditions.checkState((numArguments >= 1 && numArguments <= 2 ? 1 : 0) != 0, (String)"DISTINCT_COUNT_HLL can have at most two arguments: %s", (Object)aggregationConfig);
                        if (numArguments == 2) {
                            secondArgument = (ExpressionContext)arguments.get(1);
                            Preconditions.checkState((secondArgument.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"Second argument of DISTINCT_COUNT_HLL must be literal: %s", (Object)aggregationConfig);
                            literal = secondArgument.getLiteral().getStringValue();
                            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)literal), (String)"Second argument of DISTINCT_COUNT_HLL must be a number: %s", (Object)aggregationConfig);
                        }
                        if (fieldSpec != null) {
                            dataType = fieldSpec.getDataType();
                            Preconditions.checkState((dataType == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (String)"Result type for DISTINCT_COUNT_HLL must be BYTES: %s", (Object)aggregationConfig);
                        }
                    } else if (functionType == AggregationFunctionType.DISTINCTCOUNTHLLPLUS) {
                        Preconditions.checkState((numArguments >= 1 && numArguments <= 3 ? 1 : 0) != 0, (String)"DISTINCT_COUNT_HLL_PLUS can have at most three arguments: %s", (Object)aggregationConfig);
                        if (numArguments == 2) {
                            secondArgument = (ExpressionContext)arguments.get(1);
                            Preconditions.checkState((secondArgument.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"Second argument of DISTINCT_COUNT_HLL_PLUS must be literal: %s", (Object)aggregationConfig);
                            literal = secondArgument.getLiteral().getStringValue();
                            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)literal), (String)"Second argument of DISTINCT_COUNT_HLL_PLUS must be a number: %s", (Object)aggregationConfig);
                        }
                        if (numArguments == 3) {
                            ExpressionContext thirdArgument = (ExpressionContext)arguments.get(2);
                            Preconditions.checkState((thirdArgument.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"Third argument of DISTINCT_COUNT_HLL_PLUS must be literal: %s", (Object)aggregationConfig);
                            literal = thirdArgument.getLiteral().getStringValue();
                            Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)literal), (String)"Third argument of DISTINCT_COUNT_HLL_PLUS must be a number: %s", (Object)aggregationConfig);
                        }
                        if (fieldSpec != null) {
                            dataType = fieldSpec.getDataType();
                            Preconditions.checkState((dataType == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (String)"Result type for DISTINCT_COUNT_HLL_PLUS must be BYTES: %s", (Object)aggregationConfig);
                        }
                    } else if (functionType == AggregationFunctionType.SUMPRECISION) {
                        Preconditions.checkState((numArguments >= 2 && numArguments <= 3 ? 1 : 0) != 0, (String)"SUM_PRECISION must specify precision (required), scale (optional): %s", (Object)aggregationConfig);
                        secondArgument = (ExpressionContext)arguments.get(1);
                        Preconditions.checkState((secondArgument.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"Second argument of SUM_PRECISION must be literal: %s", (Object)aggregationConfig);
                        literal = secondArgument.getLiteral().getStringValue();
                        Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)literal), (String)"Second argument of SUM_PRECISION must be a number: %s", (Object)aggregationConfig);
                        if (fieldSpec != null) {
                            FieldSpec.DataType dataType2 = fieldSpec.getDataType();
                            Preconditions.checkState((dataType2 == FieldSpec.DataType.BIG_DECIMAL || dataType2 == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (String)"Result type for DISTINCT_COUNT_HLL must be BIG_DECIMAL or BYTES: %s", (Object)aggregationConfig);
                        }
                    } else {
                        Preconditions.checkState((numArguments == 1 ? 1 : 0) != 0, (String)"%s can only have one argument: %s", (Object)functionType, (Object)aggregationConfig);
                    }
                    Preconditions.checkState(((firstArgument = (ExpressionContext)arguments.get(0)).getType() == ExpressionContext.Type.IDENTIFIER ? 1 : 0) != 0, (String)"First argument of aggregation function: %s must be identifier, got: %s", (Object)functionType, (Object)firstArgument.getType());
                    aggregationSourceColumns.add(firstArgument.getIdentifier());
                }
                if (schema != null) {
                    Preconditions.checkState((boolean)new HashSet(schema.getMetricNames()).equals(aggregationColumns), (Object)"all metric columns must be aggregated");
                }
                Map configPerCol = StandardIndexes.dictionary().getConfig(tableConfig, schema);
                aggregationColumns.forEach(column -> {
                    DictionaryIndexConfig dictConfig = (DictionaryIndexConfig)configPerCol.get(column);
                    Preconditions.checkState((dictConfig != null && dictConfig.isDisabled() ? 1 : 0) != 0, (String)"Aggregated column: %s must be a no-dictionary column", (Object)column);
                });
            }
            if ((enrichmentConfigs = ingestionConfig.getEnrichmentConfigs()) != null) {
                for (EnrichmentConfig enrichmentConfig : enrichmentConfigs) {
                    RecordEnricherRegistry.validateEnrichmentConfig((EnrichmentConfig)enrichmentConfig, (RecordEnricherValidationConfig)new RecordEnricherValidationConfig(_disableGroovy));
                }
            }
            if ((transformConfigs = ingestionConfig.getTransformConfigs()) != null) {
                HashSet<String> transformColumns = new HashSet<String>();
                for (TransformConfig transformConfig : transformConfigs) {
                    FunctionEvaluator expressionEvaluator;
                    String columnName = transformConfig.getColumnName();
                    String transformFunction = transformConfig.getTransformFunction();
                    if (columnName == null || transformFunction == null) {
                        throw new IllegalStateException("columnName/transformFunction cannot be null in TransformConfig " + transformConfig);
                    }
                    if (!transformColumns.add(columnName)) {
                        throw new IllegalStateException("Duplicate transform config found for column '" + columnName + "'");
                    }
                    if (schema != null) {
                        Preconditions.checkState((schema.getFieldSpecFor(columnName) != null || aggregationSourceColumns.contains(columnName) ? 1 : 0) != 0, (Object)("The destination column '" + columnName + "' of the transform function must be present in the schema or as a source column for aggregations"));
                    }
                    if (_disableGroovy && FunctionEvaluatorFactory.isGroovyExpression(transformFunction)) {
                        throw new IllegalStateException("Groovy transform functions are disabled for table config. Found '" + transformFunction + "' for column '" + columnName + "'");
                    }
                    try {
                        expressionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(transformFunction);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Invalid transform function '" + transformFunction + "' for column '" + columnName + "'", e);
                    }
                    List<String> arguments = expressionEvaluator.getArguments();
                    if (!arguments.contains(columnName)) continue;
                    throw new IllegalStateException("Arguments of a transform function '" + arguments + "' cannot contain the destination column '" + columnName + "'");
                }
            }
            if ((complexTypeConfig = ingestionConfig.getComplexTypeConfig()) != null && schema != null && MapUtils.isNotEmpty((Map)(prefixesToRename = complexTypeConfig.getPrefixesToRename()))) {
                NavigableSet fieldNames = schema.getColumnNames();
                for (String prefix : prefixesToRename.keySet()) {
                    for (String field : fieldNames) {
                        Preconditions.checkState((!field.startsWith(prefix) ? 1 : 0) != 0, (Object)("Fields in the schema may not begin with any prefix specified in the prefixesToRename config. Name conflict with field: " + field + " and prefix: " + prefix));
                    }
                }
            }
            if (null != (schemaConformingTransformerConfig = ingestionConfig.getSchemaConformingTransformerConfig()) && null != schema) {
                SchemaConformingTransformer.validateSchema(schema, schemaConformingTransformerConfig);
            }
        }
    }

    public static void validateIngestionAggregation(AggregationFunctionType functionType) {
        Preconditions.checkState((boolean)SUPPORTED_INGESTION_AGGREGATIONS.contains(functionType), (String)"Aggregation function: %s must be one of: %s", (Object)functionType, SUPPORTED_INGESTION_AGGREGATIONS);
    }

    @VisibleForTesting
    static void validateStreamConfig(StreamConfig streamConfig) {
        Preconditions.checkState((streamConfig.getFlushThresholdTimeMillis() > 0L ? 1 : 0) != 0, (String)"Invalid flush threshold time: %s", (long)streamConfig.getFlushThresholdTimeMillis());
        int flushThresholdRows = streamConfig.getFlushThresholdRows();
        int flushThresholdSegmentRows = streamConfig.getFlushThresholdSegmentRows();
        long flushThresholdSegmentSizeBytes = streamConfig.getFlushThresholdSegmentSizeBytes();
        int numFlushThresholdSet = 0;
        if (flushThresholdRows > 0) {
            ++numFlushThresholdSet;
        }
        if (flushThresholdSegmentRows > 0) {
            ++numFlushThresholdSet;
        }
        if (flushThresholdSegmentSizeBytes > 0L) {
            ++numFlushThresholdSet;
        }
        Preconditions.checkState((numFlushThresholdSet <= 1 ? 1 : 0) != 0, (String)"Only 1 of flush threshold (rows: %s, segment rows: %s, segment size: %s) can be set", (Object)flushThresholdRows, (Object)flushThresholdSegmentRows, (Object)flushThresholdSegmentSizeBytes);
        if (streamConfig.getDecoderClass().equals("org.apache.pinot.plugin.inputformat.protobuf.ProtoBufMessageDecoder")) {
            String descriptorFilePath = "descriptorFile";
            String protoClassName = "protoClassName";
            if (!streamConfig.getDecoderProperties().containsKey(descriptorFilePath)) {
                throw new IllegalStateException("Missing property of descriptorFile for ProtoBufMessageDecoder");
            }
            if (!streamConfig.getDecoderProperties().containsKey(protoClassName)) {
                throw new IllegalStateException("Missing property of protoClassName for ProtoBufMessageDecoder");
            }
        }
    }

    @VisibleForTesting
    static void validateUpsertAndDedupConfig(TableConfig tableConfig, Schema schema) {
        if (!(tableConfig.getUpsertMode() != UpsertConfig.Mode.NONE || tableConfig.getDedupConfig() != null && tableConfig.getDedupConfig().isDedupEnabled())) {
            return;
        }
        boolean isUpsertEnabled = tableConfig.getUpsertMode() != UpsertConfig.Mode.NONE;
        boolean isDedupEnabled = tableConfig.getDedupConfig() != null && tableConfig.getDedupConfig().isDedupEnabled();
        Preconditions.checkState((!isUpsertEnabled || !isDedupEnabled ? 1 : 0) != 0, (Object)"A table can have either Upsert or Dedup enabled, but not both");
        Preconditions.checkState((tableConfig.getTableType() == TableType.REALTIME ? 1 : 0) != 0, (Object)"Upsert/Dedup table is for realtime table only.");
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)schema.getPrimaryKeyColumns()), (Object)"Upsert/Dedup table must have primary key columns in the schema");
        Preconditions.checkState((tableConfig.getRoutingConfig() != null && TableConfigUtils.isRoutingStrategyAllowedForUpsert(tableConfig.getRoutingConfig()) ? 1 : 0) != 0, (Object)"Upsert/Dedup table must use strict replica-group (i.e. strictReplicaGroup) based routing");
        Preconditions.checkState((tableConfig.getTenantConfig().getTagOverrideConfig() == null || tableConfig.getTenantConfig().getTagOverrideConfig().getRealtimeConsuming() == null && tableConfig.getTenantConfig().getTagOverrideConfig().getRealtimeCompleted() == null ? 1 : 0) != 0, (Object)"Invalid tenant tag override used for Upsert/Dedup table");
        UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
        if (upsertConfig != null) {
            String outOfOrderRecordColumn;
            String deleteRecordColumn;
            Preconditions.checkState((CollectionUtils.isEmpty((Collection)tableConfig.getIndexingConfig().getStarTreeIndexConfigs()) && !tableConfig.getIndexingConfig().isEnableDefaultStarTree() ? 1 : 0) != 0, (Object)"The upsert table cannot have star-tree index.");
            List comparisonColumns = upsertConfig.getComparisonColumns();
            if (comparisonColumns != null) {
                for (String column : comparisonColumns) {
                    Preconditions.checkState((boolean)schema.hasColumn(column), (Object)"The comparison column does not exist on schema");
                }
            }
            if ((deleteRecordColumn = upsertConfig.getDeleteRecordColumn()) != null) {
                FieldSpec fieldSpec = schema.getFieldSpecFor(deleteRecordColumn);
                Preconditions.checkState((fieldSpec != null ? 1 : 0) != 0, (Object)String.format("Column %s specified in deleteRecordColumn does not exist", deleteRecordColumn));
                Preconditions.checkState((boolean)fieldSpec.isSingleValueField(), (Object)String.format("The deleteRecordColumn - %s must be a single-valued column", deleteRecordColumn));
                FieldSpec.DataType dataType = fieldSpec.getDataType();
                Preconditions.checkState((dataType == FieldSpec.DataType.BOOLEAN || dataType == FieldSpec.DataType.STRING || dataType.isNumeric() ? 1 : 0) != 0, (Object)String.format("The deleteRecordColumn - %s must be of type: String / Boolean / Numeric", deleteRecordColumn));
            }
            Preconditions.checkState(((outOfOrderRecordColumn = upsertConfig.getOutOfOrderRecordColumn()) == null || !upsertConfig.isDropOutOfOrderRecord() ? 1 : 0) != 0, (Object)"outOfOrderRecordColumn and dropOutOfOrderRecord shouldn't exist together for upsert table");
            if (outOfOrderRecordColumn != null) {
                FieldSpec fieldSpec = schema.getFieldSpecFor(outOfOrderRecordColumn);
                Preconditions.checkState((fieldSpec != null && fieldSpec.isSingleValueField() && fieldSpec.getDataType() == FieldSpec.DataType.BOOLEAN ? 1 : 0) != 0, (Object)"The outOfOrderRecordColumn must be a single-valued BOOLEAN column");
            }
            if (upsertConfig.isEnableDeletedKeysCompactionConsistency()) {
                Preconditions.checkState((upsertConfig.getMetadataTTL() == 0.0 ? 1 : 0) != 0, (Object)"enableDeletedKeysCompactionConsistency and metadataTTL shouldn't exist together for upsert table");
                Preconditions.checkState((!upsertConfig.isEnablePreload() ? 1 : 0) != 0, (Object)"enableDeletedKeysCompactionConsistency and enablePreload shouldn't exist together for upsert table");
                Preconditions.checkState((upsertConfig.getDeletedKeysTTL() > 0.0 ? 1 : 0) != 0, (Object)"enableDeletedKeysCompactionConsistency should exist with deletedKeysTTL for upsert table");
                Preconditions.checkState((boolean)upsertConfig.isEnableSnapshot(), (Object)"enableDeletedKeysCompactionConsistency should exist with enableSnapshot for upsert table");
                TableTaskConfig taskConfig = tableConfig.getTaskConfig();
                Preconditions.checkState((taskConfig != null && (taskConfig.getTaskTypeConfigsMap().containsKey(UPSERT_COMPACTION_TASK_TYPE) || taskConfig.getTaskTypeConfigsMap().containsKey(UPSERT_COMPACT_MERGE_TASK_TYPE)) ? 1 : 0) != 0, (Object)"enableDeletedKeysCompactionConsistency should exist with UpsertCompactionTask / UpsertCompactMergeTask for upsert table");
            }
            if (upsertConfig.getConsistencyMode() != UpsertConfig.ConsistencyMode.NONE) {
                Preconditions.checkState((upsertConfig.getNewSegmentTrackingTimeMs() > 0L ? 1 : 0) != 0, (Object)("Positive newSegmentTrackingTimeMs is required to enable consistency mode: " + upsertConfig.getConsistencyMode()));
            }
        }
        Preconditions.checkState((tableConfig.getInstanceAssignmentConfigMap() == null || !tableConfig.getInstanceAssignmentConfigMap().containsKey(InstancePartitionsType.COMPLETED) ? 1 : 0) != 0, (Object)"InstanceAssignmentConfig for COMPLETED is not allowed for upsert tables");
        TableConfigUtils.validateAggregateMetricsForUpsertConfig(tableConfig);
        TableConfigUtils.validateTTLForUpsertConfig(tableConfig, schema);
    }

    @VisibleForTesting
    static void validateTTLForUpsertConfig(TableConfig tableConfig, Schema schema) {
        UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
        if (upsertConfig == null || upsertConfig.getMetadataTTL() == 0.0 && upsertConfig.getDeletedKeysTTL() == 0.0) {
            return;
        }
        List comparisonColumns = upsertConfig.getComparisonColumns();
        if (CollectionUtils.isNotEmpty((Collection)comparisonColumns)) {
            Preconditions.checkState((comparisonColumns.size() == 1 ? 1 : 0) != 0, (Object)"MetadataTTL / DeletedKeysTTL does not work with multiple comparison columns");
            String comparisonColumn = (String)comparisonColumns.get(0);
            FieldSpec.DataType comparisonColumnDataType = schema.getFieldSpecFor(comparisonColumn).getDataType();
            Preconditions.checkState((boolean)comparisonColumnDataType.isNumeric(), (String)"MetadataTTL / DeletedKeysTTL must have comparison column: %s in numeric type, found: %s", (Object)comparisonColumn, (Object)comparisonColumnDataType);
        }
        if (upsertConfig.getMetadataTTL() > 0.0) {
            Preconditions.checkState((boolean)upsertConfig.isEnableSnapshot(), (Object)"Upsert TTL must have snapshot enabled");
        }
        if (upsertConfig.getDeletedKeysTTL() > 0.0) {
            Preconditions.checkState((upsertConfig.getDeleteRecordColumn() != null ? 1 : 0) != 0, (Object)"Deleted Keys TTL can only be enabled with deleteRecordColumn set.");
        }
    }

    @VisibleForTesting
    static void validateInstancePartitionsTypeMapConfig(TableConfig tableConfig) {
        if (MapUtils.isEmpty((Map)tableConfig.getInstancePartitionsMap()) || MapUtils.isEmpty((Map)tableConfig.getInstanceAssignmentConfigMap())) {
            return;
        }
        for (InstancePartitionsType instancePartitionsType : InstancePartitionsType.values()) {
            if (!tableConfig.getInstanceAssignmentConfigMap().containsKey(instancePartitionsType.toString())) continue;
            InstanceAssignmentConfig instanceAssignmentConfig = (InstanceAssignmentConfig)tableConfig.getInstanceAssignmentConfigMap().get(instancePartitionsType.toString());
            if (instanceAssignmentConfig.getPartitionSelector() == InstanceAssignmentConfig.PartitionSelector.MIRROR_SERVER_SET_PARTITION_SELECTOR) {
                Preconditions.checkState((boolean)tableConfig.getInstancePartitionsMap().containsKey(instancePartitionsType), (Object)String.format("Both InstanceAssignmentConfigMap and InstancePartitionsMap needed for %s, as MIRROR_SERVER_SET_PARTITION_SELECTOR is used", instancePartitionsType));
                continue;
            }
            Preconditions.checkState((!tableConfig.getInstancePartitionsMap().containsKey(instancePartitionsType) ? 1 : 0) != 0, (Object)String.format("Both InstanceAssignmentConfigMap and InstancePartitionsMap set for %s", instancePartitionsType));
        }
    }

    @VisibleForTesting
    static void validatePartitionedReplicaGroupInstance(TableConfig tableConfig) {
        if (tableConfig.getValidationConfig().getReplicaGroupStrategyConfig() == null || MapUtils.isEmpty((Map)tableConfig.getInstanceAssignmentConfigMap())) {
            return;
        }
        for (Map.Entry entry : tableConfig.getInstanceAssignmentConfigMap().entrySet()) {
            boolean isNullReplicaGroupPartitionConfig = ((InstanceAssignmentConfig)entry.getValue()).getReplicaGroupPartitionConfig() == null;
            Preconditions.checkState((boolean)isNullReplicaGroupPartitionConfig, (Object)"Both replicaGroupStrategyConfig and replicaGroupPartitionConfig is provided");
        }
    }

    private static void validateAggregateMetricsForUpsertConfig(TableConfig config) {
        boolean isAggregateMetricsEnabledInIndexingConfig = config.getIndexingConfig().isAggregateMetrics();
        boolean hasAggregationConfigs = config.getIngestionConfig() != null && CollectionUtils.isNotEmpty((Collection)config.getIngestionConfig().getAggregationConfigs());
        boolean bothAggregationConfigsEnabled = isAggregateMetricsEnabledInIndexingConfig && hasAggregationConfigs;
        boolean anyOneAggregationConfigsEnabled = isAggregateMetricsEnabledInIndexingConfig || hasAggregationConfigs;
        Preconditions.checkState((!bothAggregationConfigsEnabled ? 1 : 0) != 0, (Object)"Metrics aggregation cannot be enabled in the Indexing Config and Ingestion Config at the same time");
        Preconditions.checkState((!anyOneAggregationConfigsEnabled ? 1 : 0) != 0, (Object)"Metrics aggregation and upsert cannot be enabled together");
    }

    @VisibleForTesting
    static void validatePartialUpsertStrategies(TableConfig tableConfig, Schema schema) {
        if (tableConfig.getUpsertMode() != UpsertConfig.Mode.PARTIAL) {
            return;
        }
        Preconditions.checkState((schema.isEnableColumnBasedNullHandling() || tableConfig.getIndexingConfig().isNullHandlingEnabled() ? 1 : 0) != 0, (Object)"Null handling must be enabled for partial upsert tables");
        UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
        assert (upsertConfig != null);
        Map partialUpsertStrategies = upsertConfig.getPartialUpsertStrategies();
        String partialUpsertMergerClass = upsertConfig.getPartialUpsertMergerClass();
        if (StringUtils.isNotBlank((CharSequence)partialUpsertMergerClass)) {
            Preconditions.checkState((boolean)MapUtils.isEmpty((Map)partialUpsertStrategies), (Object)"If partialUpsertMergerClass is provided then partialUpsertStrategies should be empty");
        } else {
            List primaryKeyColumns = schema.getPrimaryKeyColumns();
            for (Map.Entry entry : partialUpsertStrategies.entrySet()) {
                String column = (String)entry.getKey();
                UpsertConfig.Strategy columnStrategy = (UpsertConfig.Strategy)entry.getValue();
                Preconditions.checkState((!primaryKeyColumns.contains(column) ? 1 : 0) != 0, (Object)"Merger cannot be applied to primary key columns");
                if (upsertConfig.getComparisonColumns() != null) {
                    Preconditions.checkState((!upsertConfig.getComparisonColumns().contains(column) ? 1 : 0) != 0, (Object)"Merger cannot be applied to comparison column");
                } else {
                    Preconditions.checkState((!tableConfig.getValidationConfig().getTimeColumnName().equals(column) ? 1 : 0) != 0, (Object)"Merger cannot be applied to time column");
                }
                FieldSpec fieldSpec = schema.getFieldSpecFor(column);
                Preconditions.checkState((fieldSpec != null ? 1 : 0) != 0, (String)"Merger cannot be applied to non-existing column: %s", (Object)column);
                if (columnStrategy == UpsertConfig.Strategy.INCREMENT) {
                    Preconditions.checkState((boolean)fieldSpec.getDataType().getStoredType().isNumeric(), (String)"INCREMENT merger cannot be applied to non-numeric column: %s", (Object)column);
                    Preconditions.checkState((!schema.getDateTimeNames().contains(column) ? 1 : 0) != 0, (String)"INCREMENT merger cannot be applied to date time column: %s", (Object)column);
                    Preconditions.checkState((!schema.getComplexNames().contains(column) ? 1 : 0) != 0, (String)"INCREMENT merger cannot be applied to complex column: %s", (Object)column);
                    continue;
                }
                if (columnStrategy != UpsertConfig.Strategy.APPEND && columnStrategy != UpsertConfig.Strategy.UNION) continue;
                Preconditions.checkState((!fieldSpec.isSingleValueField() ? 1 : 0) != 0, (String)"%s merger cannot be applied to single-value column: %s", (Object)columnStrategy.toString(), (Object)column);
            }
        }
    }

    private static void validateTierConfigList(@Nullable List<TierConfig> tierConfigList) {
        if (tierConfigList == null) {
            return;
        }
        HashSet<String> tierNames = new HashSet<String>();
        for (TierConfig tierConfig : tierConfigList) {
            String tierName = tierConfig.getName();
            Preconditions.checkState((!tierName.isEmpty() ? 1 : 0) != 0, (Object)"Tier name cannot be blank");
            Preconditions.checkState((boolean)tierNames.add(tierName), (String)"Tier name: %s already exists in tier configs", (Object)tierName);
            String segmentSelectorType = tierConfig.getSegmentSelectorType();
            String segmentAge = tierConfig.getSegmentAge();
            if (segmentSelectorType.equalsIgnoreCase("time")) {
                Preconditions.checkState((segmentAge != null ? 1 : 0) != 0, (String)"Must provide 'segmentAge' for segmentSelectorType: %s in tier: %s", (Object)segmentSelectorType, (Object)tierName);
                Preconditions.checkState((boolean)TimeUtils.isPeriodValid((String)segmentAge), (String)"segmentAge: %s must be a valid period string (eg. 30d, 24h) in tier: %s", (Object)segmentAge, (Object)tierName);
            } else if (!segmentSelectorType.equalsIgnoreCase("fixed")) {
                throw new IllegalStateException("Unsupported segmentSelectorType: " + segmentSelectorType + " in tier: " + tierName);
            }
            String storageType = tierConfig.getStorageType();
            String serverTag = tierConfig.getServerTag();
            if (storageType.equalsIgnoreCase("pinot_server")) {
                Preconditions.checkState((serverTag != null ? 1 : 0) != 0, (String)"Must provide 'serverTag' for storageType: %s in tier: %s", (Object)storageType, (Object)tierName);
                Preconditions.checkState((boolean)TagNameUtils.isServerTag((String)serverTag), (String)"serverTag: %s must have a valid server tag format (<tenantName>_OFFLINE or <tenantName>_REALTIME) in tier: %s", (Object)serverTag, (Object)tierName);
                continue;
            }
            throw new IllegalStateException("Unsupported storageType: " + storageType + " in tier: " + tierName);
        }
    }

    private static void validateIndexingConfig(IndexingConfig indexingConfig, @Nullable Schema schema) {
        if (schema == null) {
            return;
        }
        ArrayListMultimap columnNameToConfigMap = ArrayListMultimap.create();
        HashSet noDictionaryColumnsSet = new HashSet();
        if (indexingConfig.getNoDictionaryColumns() != null) {
            for (Iterator<Object> columnName : indexingConfig.getNoDictionaryColumns()) {
                columnNameToConfigMap.put((Object)columnName, (Object)"No Dictionary Column Config");
                noDictionaryColumnsSet.add(columnName);
            }
        }
        HashSet bloomFilterColumns = new HashSet();
        if (indexingConfig.getBloomFilterColumns() != null) {
            bloomFilterColumns.addAll(indexingConfig.getBloomFilterColumns());
        }
        if (indexingConfig.getBloomFilterConfigs() != null) {
            bloomFilterColumns.addAll(indexingConfig.getBloomFilterConfigs().keySet());
        }
        for (String bloomFilterColumn : bloomFilterColumns) {
            columnNameToConfigMap.put((Object)bloomFilterColumn, (Object)"Bloom Filter Config");
        }
        if (indexingConfig.getInvertedIndexColumns() != null) {
            for (String columnName : indexingConfig.getInvertedIndexColumns()) {
                if (noDictionaryColumnsSet.contains(columnName)) {
                    throw new IllegalStateException("Cannot create an Inverted index on column " + columnName + " specified in the noDictionaryColumns config");
                }
                columnNameToConfigMap.put((Object)columnName, (Object)"Inverted Index Config");
            }
        }
        if (indexingConfig.getOnHeapDictionaryColumns() != null) {
            for (String columnName : indexingConfig.getOnHeapDictionaryColumns()) {
                columnNameToConfigMap.put((Object)columnName, (Object)"On Heap Dictionary Column Config");
            }
        }
        if (indexingConfig.getRangeIndexColumns() != null) {
            for (String columnName : indexingConfig.getRangeIndexColumns()) {
                columnNameToConfigMap.put((Object)columnName, (Object)"Range Column Config");
            }
        }
        if (indexingConfig.getSortedColumn() != null) {
            for (String columnName : indexingConfig.getSortedColumn()) {
                columnNameToConfigMap.put((Object)columnName, (Object)"Sorted Column Config");
            }
        }
        if (indexingConfig.getVarLengthDictionaryColumns() != null) {
            for (String columnName : indexingConfig.getVarLengthDictionaryColumns()) {
                columnNameToConfigMap.put((Object)columnName, (Object)"Var Length Column Config");
            }
        }
        if (indexingConfig.getSegmentPartitionConfig() != null && indexingConfig.getSegmentPartitionConfig().getColumnPartitionMap() != null) {
            for (String columnName : indexingConfig.getSegmentPartitionConfig().getColumnPartitionMap().keySet()) {
                columnNameToConfigMap.put((Object)columnName, (Object)"Segment Partition Config");
            }
        }
        HashSet jsonIndexColumns = new HashSet();
        if (indexingConfig.getJsonIndexConfigs() != null) {
            jsonIndexColumns.addAll(indexingConfig.getJsonIndexConfigs().keySet());
        } else if (indexingConfig.getJsonIndexColumns() != null) {
            jsonIndexColumns.addAll(indexingConfig.getJsonIndexColumns());
        }
        for (String columnName : jsonIndexColumns) {
            columnNameToConfigMap.put((Object)columnName, (Object)"Json Index Config");
        }
        TableConfigUtils.validateStarTreeIndexConfigs(indexingConfig, (ArrayListMultimap<String, String>)columnNameToConfigMap);
        for (Map.Entry entry : columnNameToConfigMap.entries()) {
            String columnName = (String)entry.getKey();
            String configName = (String)entry.getValue();
            FieldSpec columnFieldSpec = schema.getFieldSpecFor(columnName);
            Preconditions.checkState((columnFieldSpec != null ? 1 : 0) != 0, (Object)("Column Name " + columnName + " defined in " + configName + " must be a valid column defined in the schema"));
            if (!configName.equals(STAR_TREE_CONFIG_NAME)) continue;
            Preconditions.checkState((boolean)columnFieldSpec.isSingleValueField(), (Object)("Column Name " + columnName + " defined in " + configName + " must be a single value column"));
        }
        if (indexingConfig.getRangeIndexColumns() != null) {
            for (String rangeIndexCol : indexingConfig.getRangeIndexColumns()) {
                Preconditions.checkState((schema.getFieldSpecFor(rangeIndexCol).getDataType().isNumeric() || !noDictionaryColumnsSet.contains(rangeIndexCol) ? 1 : 0) != 0, (Object)("Cannot create a range index on non-numeric/no-dictionary column " + rangeIndexCol));
            }
        }
        if (indexingConfig.getVarLengthDictionaryColumns() != null) {
            block14: for (String varLenDictCol : indexingConfig.getVarLengthDictionaryColumns()) {
                FieldSpec varLenDictFieldSpec = schema.getFieldSpecFor(varLenDictCol);
                switch (varLenDictFieldSpec.getDataType().getStoredType()) {
                    case STRING: 
                    case BYTES: {
                        continue block14;
                    }
                }
                throw new IllegalStateException("var length dictionary can only be created for columns of type STRING and BYTES. Invalid for column " + varLenDictCol);
            }
        }
        for (String jsonIndexColumn : jsonIndexColumns) {
            FieldSpec fieldSpec = schema.getFieldSpecFor(jsonIndexColumn);
            Preconditions.checkState((fieldSpec.isSingleValueField() && fieldSpec.getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (String)"Json index can only be created for single value String column. Invalid for column: %s", (Object)jsonIndexColumn);
        }
    }

    private static void validateStarTreeIndexConfigs(IndexingConfig indexingConfig, ArrayListMultimap<String, String> columnNameToConfigMap) {
        List starTreeIndexConfigList = indexingConfig.getStarTreeIndexConfigs();
        if (starTreeIndexConfigList != null) {
            for (StarTreeIndexConfig starTreeIndexConfig : starTreeIndexConfigList) {
                List skipDimensionList;
                String columnName;
                AggregationFunctionColumnPair storedType;
                AggregationFunctionColumnPair columnPair;
                for (String columnName2 : starTreeIndexConfig.getDimensionsSplitOrder()) {
                    columnNameToConfigMap.put((Object)columnName2, (Object)STAR_TREE_CONFIG_NAME);
                }
                List functionColumnPairs = starTreeIndexConfig.getFunctionColumnPairs();
                List aggregationConfigs = starTreeIndexConfig.getAggregationConfigs();
                Preconditions.checkState((functionColumnPairs == null || aggregationConfigs == null ? 1 : 0) != 0, (Object)"Only one of 'functionColumnPairs' or 'aggregationConfigs' can be specified in StarTreeIndexConfig");
                HashSet<AggregationFunctionColumnPair> functionColumnPairsSet = new HashSet<AggregationFunctionColumnPair>();
                HashSet<AggregationFunctionColumnPair> storedTypes = new HashSet<AggregationFunctionColumnPair>();
                if (functionColumnPairs != null) {
                    for (String functionColumnPair : functionColumnPairs) {
                        try {
                            columnPair = AggregationFunctionColumnPair.fromColumnName((String)functionColumnPair);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Invalid StarTreeIndex config: " + functionColumnPair + ". Must bein the form <Aggregation function>__<Column name>");
                        }
                        if (functionColumnPairsSet.contains(columnPair)) {
                            throw new IllegalStateException("Duplicate function column pair: " + functionColumnPair);
                        }
                        functionColumnPairsSet.add(columnPair);
                        storedType = AggregationFunctionColumnPair.resolveToStoredType((AggregationFunctionColumnPair)columnPair);
                        if (!storedTypes.add(storedType)) {
                            LOGGER.warn("StarTreeIndex config duplication: {} already matches existing function column pair: {}. ", (Object)columnPair, (Object)storedType);
                        }
                        if ((columnName = columnPair.getColumn()).equals("*")) continue;
                        columnNameToConfigMap.put((Object)columnName, (Object)STAR_TREE_CONFIG_NAME);
                    }
                }
                if (aggregationConfigs != null) {
                    for (StarTreeAggregationConfig aggregationConfig : aggregationConfigs) {
                        try {
                            columnPair = AggregationFunctionColumnPair.fromAggregationConfig((StarTreeAggregationConfig)aggregationConfig);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Invalid StarTreeIndex config: " + aggregationConfig);
                        }
                        if (functionColumnPairsSet.contains(columnPair)) {
                            throw new IllegalStateException("Duplicate function column pair: " + columnPair + ". If you want multiple pre-aggregations on the same column with the same aggregation function but with different configuration parameters, specify them in separate star-tree index configurations");
                        }
                        functionColumnPairsSet.add(columnPair);
                        storedType = AggregationFunctionColumnPair.resolveToStoredType((AggregationFunctionColumnPair)columnPair);
                        if (!storedTypes.add(storedType)) {
                            LOGGER.warn("StarTreeIndex config duplication: {} already matches existing function column pair: {}. ", (Object)columnPair, (Object)storedType);
                        }
                        if ((columnName = columnPair.getColumn()).equals("*")) continue;
                        columnNameToConfigMap.put((Object)columnName, (Object)STAR_TREE_CONFIG_NAME);
                    }
                }
                if ((skipDimensionList = starTreeIndexConfig.getSkipStarNodeCreationForDimensions()) == null) continue;
                for (String columnName3 : skipDimensionList) {
                    columnNameToConfigMap.put((Object)columnName3, (Object)STAR_TREE_CONFIG_NAME);
                }
            }
        }
    }

    private static void validateFieldConfigList(TableConfig tableConfig, @Nullable Schema schema) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        TableType tableType = tableConfig.getTableType();
        if (fieldConfigList == null) {
            return;
        }
        assert (indexingConfig != null);
        for (FieldConfig fieldConfig : fieldConfigList) {
            String columnName = fieldConfig.getName();
            FieldConfig.EncodingType encodingType = fieldConfig.getEncodingType();
            Preconditions.checkArgument((encodingType != null ? 1 : 0) != 0, (String)"Encoding type must be specified for column: %s", (Object)columnName);
            FieldConfig.CompressionCodec compressionCodec = fieldConfig.getCompressionCodec();
            switch (encodingType) {
                case RAW: {
                    Preconditions.checkArgument((compressionCodec == null || compressionCodec.isApplicableToRawIndex() || compressionCodec == FieldConfig.CompressionCodec.CLP || compressionCodec == FieldConfig.CompressionCodec.CLPV2 ? 1 : 0) != 0, (String)"Compression codec: %s is not applicable to raw index", (Object)compressionCodec);
                    if (compressionCodec != FieldConfig.CompressionCodec.CLP && compressionCodec != FieldConfig.CompressionCodec.CLPV2 || schema == null) break;
                    Preconditions.checkArgument((schema.getFieldSpecFor(columnName).getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"CLP compression codec can only be applied to string columns");
                    break;
                }
                case DICTIONARY: {
                    Preconditions.checkArgument((compressionCodec == null || compressionCodec.isApplicableToDictEncodedIndex() ? 1 : 0) != 0, (String)"Compression codec: %s is not applicable to dictionary encoded index", (Object)compressionCodec);
                    List noDictionaryColumns = indexingConfig.getNoDictionaryColumns();
                    Preconditions.checkArgument((noDictionaryColumns == null || !noDictionaryColumns.contains(columnName) ? 1 : 0) != 0, (String)"FieldConfig encoding type is different from indexingConfig for column: %s", (Object)columnName);
                    Map noDictionaryConfig = indexingConfig.getNoDictionaryConfig();
                    Preconditions.checkArgument((noDictionaryConfig == null || !noDictionaryConfig.containsKey(columnName) ? 1 : 0) != 0, (String)"FieldConfig encoding type is different from indexingConfig for column: %s", (Object)columnName);
                    break;
                }
            }
            if (schema == null) {
                return;
            }
            FieldSpec fieldSpec = schema.getFieldSpecFor(columnName);
            Preconditions.checkState((fieldSpec != null ? 1 : 0) != 0, (String)"Column: %s defined in field config list must be a valid column defined in the schema", (Object)columnName);
            TableConfigUtils.validateForwardIndexDisabledIndexCompatibility(columnName, fieldConfig, indexingConfig, schema, tableType);
            if (!CollectionUtils.isNotEmpty((Collection)fieldConfig.getIndexTypes())) continue;
            for (FieldConfig.IndexType indexType : fieldConfig.getIndexTypes()) {
                switch (indexType) {
                    case INVERTED: {
                        Preconditions.checkState((fieldConfig.getEncodingType() == FieldConfig.EncodingType.DICTIONARY ? 1 : 0) != 0, (String)"Cannot create inverted index on column: %s, it can only be applied to dictionary encoded columns", (Object)columnName);
                        break;
                    }
                    case TEXT: {
                        Preconditions.checkState((fieldSpec.getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (String)"Cannot create text index on column: %s, it can only be applied to string columns", (Object)columnName);
                        break;
                    }
                    case FST: {
                        Preconditions.checkState((fieldConfig.getEncodingType() == FieldConfig.EncodingType.DICTIONARY && fieldSpec.isSingleValueField() && fieldSpec.getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (String)"Cannot create FST index on column: %s, it can only be applied to dictionary encoded single value string columns", (Object)columnName);
                        break;
                    }
                    case TIMESTAMP: {
                        Preconditions.checkState((fieldSpec.getDataType() == FieldSpec.DataType.TIMESTAMP ? 1 : 0) != 0, (String)"Cannot create timestamp index on column: %s, it can only be applied to timestamp columns", (Object)columnName);
                        break;
                    }
                }
            }
        }
    }

    private static void validateForwardIndexDisabledIndexCompatibility(String columnName, FieldConfig fieldConfig, IndexingConfig indexingConfig, Schema schema, TableType tableType) {
        boolean hasInvertedIndex;
        Map fieldConfigProperties = fieldConfig.getProperties();
        if (fieldConfigProperties == null) {
            return;
        }
        boolean forwardIndexDisabled = Boolean.parseBoolean(fieldConfigProperties.getOrDefault("forwardIndexDisabled", FieldConfig.DEFAULT_FORWARD_INDEX_DISABLED));
        if (!forwardIndexDisabled) {
            return;
        }
        Preconditions.checkState((tableType != TableType.REALTIME ? 1 : 0) != 0, (Object)String.format("Cannot disable forward index for column %s, as the table type is REALTIME.", columnName));
        FieldSpec fieldSpec = schema.getFieldSpecFor(columnName);
        if (indexingConfig.getRangeIndexColumns() != null && indexingConfig.getRangeIndexColumns().contains(columnName)) {
            Preconditions.checkState((boolean)fieldSpec.isSingleValueField(), (Object)String.format("Feature not supported for multi-value columns with range index. Cannot disable forward index for column %s. Disable range index on this column to use this feature.", columnName));
            Preconditions.checkState((indexingConfig.getRangeIndexVersion() == 2 ? 1 : 0) != 0, (Object)String.format("Feature not supported for single-value columns with range index version < 2. Cannot disable forward index for column %s. Either disable range index or create range index with version >= 2 to use this feature.", columnName));
        }
        Preconditions.checkState((!indexingConfig.isOptimizeDictionaryForMetrics() && !indexingConfig.isOptimizeDictionary() ? 1 : 0) != 0, (Object)String.format("Dictionary override optimization options (OptimizeDictionary, optimizeDictionaryForMetrics) not supported with forward index for column: %s, disabled", columnName));
        boolean hasDictionary = fieldConfig.getEncodingType() == FieldConfig.EncodingType.DICTIONARY;
        boolean bl = hasInvertedIndex = indexingConfig.getInvertedIndexColumns() != null && indexingConfig.getInvertedIndexColumns().contains(columnName);
        if (!hasDictionary || !hasInvertedIndex) {
            LOGGER.warn("Forward index has been disabled for column {}. Either dictionary ({}) and / or inverted index ({}) has been disabled. If the forward index needs to be regenerated or another index added please refresh or back-fill the forward index as it cannot be rebuilt without dictionary and inverted index.", new Object[]{columnName, hasDictionary ? "enabled" : "disabled", hasInvertedIndex ? "enabled" : "disabled"});
        }
    }

    private static void sanitize(TableConfig tableConfig) {
        tableConfig.setIndexingConfig(TableConfigUtils.sanitizeIndexingConfig(tableConfig.getIndexingConfig()));
    }

    private static IndexingConfig sanitizeIndexingConfig(IndexingConfig indexingConfig) {
        indexingConfig.setInvertedIndexColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getInvertedIndexColumns()));
        indexingConfig.setNoDictionaryColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getNoDictionaryColumns()));
        indexingConfig.setSortedColumn(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getSortedColumn()));
        indexingConfig.setBloomFilterColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getBloomFilterColumns()));
        indexingConfig.setOnHeapDictionaryColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getOnHeapDictionaryColumns()));
        indexingConfig.setRangeIndexColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getRangeIndexColumns()));
        indexingConfig.setVarLengthDictionaryColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getVarLengthDictionaryColumns()));
        return indexingConfig;
    }

    private static List<String> sanitizeListBasedIndexingColumns(List<String> indexingColumns) {
        if (indexingColumns != null) {
            return indexingColumns.stream().filter(v -> !v.isEmpty()).collect(Collectors.toList());
        }
        return null;
    }

    public static void ensureMinReplicas(TableConfig tableConfig, int defaultTableMinReplicas) {
        SegmentsValidationAndRetentionConfig validationConfig = tableConfig.getValidationConfig();
        int replication = tableConfig.getReplication();
        if (replication < defaultTableMinReplicas) {
            LOGGER.info("Creating table with minimum replication factor of: {} instead of requested replication: {}", (Object)defaultTableMinReplicas, (Object)replication);
            validationConfig.setReplication(String.valueOf(defaultTableMinReplicas));
        }
    }

    public static void ensureStorageQuotaConstraints(TableConfig tableConfig, String maxAllowedSize) {
        if (tableConfig.isDimTable()) {
            QuotaConfig quotaConfig = tableConfig.getQuotaConfig();
            long maxAllowedSizeInBytes = DataSizeUtils.toBytes((String)maxAllowedSize);
            if (quotaConfig == null) {
                tableConfig.setQuotaConfig(new QuotaConfig(maxAllowedSize, null));
                LOGGER.info("Assigning default storage quota ({}) for dimension table: {}", (Object)maxAllowedSize, (Object)tableConfig.getTableName());
            } else if (quotaConfig.getStorage() == null) {
                tableConfig.setQuotaConfig(new QuotaConfig(maxAllowedSize, quotaConfig.getMaxQueriesPerSecond()));
                LOGGER.info("Assigning default storage quota ({}) for dimension table: {}", (Object)maxAllowedSize, (Object)tableConfig.getTableName());
            } else if (quotaConfig.getStorageInBytes() > maxAllowedSizeInBytes) {
                throw new IllegalStateException(String.format("Exceeded storage size for dimension table. Requested size: %d, Max allowed size: %d", quotaConfig.getStorageInBytes(), maxAllowedSizeInBytes));
            }
        }
    }

    public static void verifyHybridTableConfigs(String rawTableName, TableConfig offlineTableConfig, TableConfig realtimeTableConfig) {
        String realtimeBroker;
        Preconditions.checkNotNull((Object)offlineTableConfig, (String)"Found null offline table config in hybrid table check for table: %s", (Object)rawTableName);
        Preconditions.checkNotNull((Object)realtimeTableConfig, (String)"Found null realtime table config in hybrid table check for table: %s", (Object)rawTableName);
        LOGGER.info("Validating realtime and offline configs for the hybrid table: {}", (Object)rawTableName);
        SegmentsValidationAndRetentionConfig offlineSegmentConfig = offlineTableConfig.getValidationConfig();
        SegmentsValidationAndRetentionConfig realtimeSegmentConfig = realtimeTableConfig.getValidationConfig();
        String offlineTimeColumnName = offlineSegmentConfig.getTimeColumnName();
        String realtimeTimeColumnName = realtimeSegmentConfig.getTimeColumnName();
        if (offlineTimeColumnName == null || realtimeTimeColumnName == null) {
            throw new IllegalStateException(String.format("'timeColumnName' cannot be null for table: %s! Offline time column name: %s. Realtime time column name: %s", rawTableName, offlineTimeColumnName, realtimeTimeColumnName));
        }
        if (!offlineTimeColumnName.equals(realtimeTimeColumnName)) {
            throw new IllegalStateException(String.format("Time column names are different for table: %s! Offline time column name: %s. Realtime time column name: %s", rawTableName, offlineTimeColumnName, realtimeTimeColumnName));
        }
        TenantConfig offlineTenantConfig = offlineTableConfig.getTenantConfig();
        TenantConfig realtimeTenantConfig = realtimeTableConfig.getTenantConfig();
        String offlineBroker = offlineTenantConfig.getBroker() == null ? "DefaultTenant" : offlineTenantConfig.getBroker();
        String string = realtimeBroker = realtimeTenantConfig.getBroker() == null ? "DefaultTenant" : realtimeTenantConfig.getBroker();
        if (!offlineBroker.equals(realtimeBroker)) {
            throw new IllegalArgumentException(String.format("Broker Tenants are different for table: %s! Offline broker tenant name: %s, Realtime broker tenant name: %s", rawTableName, offlineBroker, realtimeBroker));
        }
    }

    public static boolean needsEmptySegmentPruner(TableConfig tableConfig) {
        if (TableConfigUtils.isKinesisConfigured(tableConfig)) {
            return true;
        }
        RoutingConfig routingConfig = tableConfig.getRoutingConfig();
        if (routingConfig == null) {
            return false;
        }
        List segmentPrunerTypes = routingConfig.getSegmentPrunerTypes();
        if (segmentPrunerTypes == null || segmentPrunerTypes.isEmpty()) {
            return false;
        }
        for (String segmentPrunerType : segmentPrunerTypes) {
            if (!"empty".equalsIgnoreCase(segmentPrunerType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isKinesisConfigured(TableConfig tableConfig) {
        Map streamConfig;
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        if (indexingConfig != null && (streamConfig = indexingConfig.getStreamConfigs()) != null && KINESIS_STREAM_TYPE.equals(streamConfig.get("streamType"))) {
            return true;
        }
        IngestionConfig ingestionConfig = tableConfig.getIngestionConfig();
        if (ingestionConfig == null) {
            return false;
        }
        StreamIngestionConfig streamIngestionConfig = ingestionConfig.getStreamIngestionConfig();
        if (streamIngestionConfig == null) {
            return false;
        }
        for (Map config : streamIngestionConfig.getStreamConfigMaps()) {
            if (config == null || !KINESIS_STREAM_TYPE.equals(config.get("streamType"))) continue;
            return true;
        }
        return false;
    }

    private static boolean isRoutingStrategyAllowedForUpsert(@Nonnull RoutingConfig routingConfig) {
        String instanceSelectorType = routingConfig.getInstanceSelectorType();
        return UPSERT_DEDUP_ALLOWED_ROUTING_STRATEGIES.stream().anyMatch(x -> x.equalsIgnoreCase(instanceSelectorType));
    }

    public static TableConfig createTableConfigFromOldFormat(TableConfig tableConfig, Schema schema) {
        TableConfig clone = new TableConfig(tableConfig);
        for (IndexType indexType : IndexService.getInstance().getAllIndexes()) {
            indexType.convertToNewFormat(clone, schema);
        }
        if (clone.getFieldConfigList() != null) {
            ArrayList<FieldConfig> cleanFieldConfigList = new ArrayList<FieldConfig>();
            for (FieldConfig fieldConfig : clone.getFieldConfigList()) {
                cleanFieldConfigList.add(new FieldConfig.Builder(fieldConfig).withIndexTypes(null).build());
            }
            clone.setFieldConfigList(cleanFieldConfigList);
        }
        return clone;
    }

    public static enum ValidationType {
        ALL,
        TASK,
        UPSERT;

    }
}

