/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import org.apache.helix.HelixManager;
import org.apache.helix.model.IdealState;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.utils.SegmentUtils;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.TableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPreloadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPreloadUtils.class);

    private SegmentPreloadUtils() {
    }

    public static void preloadSegments(TableDataManager tableDataManager, int partitionId, IndexLoadingConfig indexLoadingConfig, HelixManager helixManager, ExecutorService segmentPreloadExecutor, @Nullable BiPredicate<String, SegmentZKMetadata> segmentSelector) throws Exception {
        String tableNameWithType = tableDataManager.getTableName();
        LOGGER.info("Preload segments from partition: {} of table: {} for fast metadata recovery", (Object)partitionId, (Object)tableNameWithType);
        Map<String, Map<String, String>> segmentAssignment = SegmentPreloadUtils.getSegmentAssignment(tableNameWithType, helixManager);
        Map<String, SegmentZKMetadata> segmentMetadataMap = SegmentPreloadUtils.getSegmentsZKMetadata(tableNameWithType, helixManager);
        List<String> preloadedSegments = SegmentPreloadUtils.doPreloadSegments(tableDataManager, partitionId, indexLoadingConfig, segmentAssignment, segmentMetadataMap, segmentPreloadExecutor, segmentSelector);
        LOGGER.info("Preloaded {} segments from partition: {} of table: {} for fast metadata recovery", new Object[]{preloadedSegments.size(), partitionId, tableNameWithType});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Preloaded segments: {}", preloadedSegments);
        }
    }

    @VisibleForTesting
    static List<String> doPreloadSegments(TableDataManager tableDataManager, int partitionId, IndexLoadingConfig indexLoadingConfig, Map<String, Map<String, String>> segmentAssignment, Map<String, SegmentZKMetadata> segmentMetadataMap, ExecutorService segmentPreloadExecutor, @Nullable BiPredicate<String, SegmentZKMetadata> segmentSelector) throws ExecutionException, InterruptedException {
        String tableNameWithType = tableDataManager.getTableName();
        String instanceId = SegmentPreloadUtils.getInstanceId(tableDataManager);
        ArrayList<String> preloadedSegments = new ArrayList<String>();
        ArrayList futures = new ArrayList();
        for (Map.Entry<String, Map<String, String>> entry : segmentAssignment.entrySet()) {
            SegmentZKMetadata segmentZKMetadata;
            Map<String, String> instanceStateMap;
            String segmentName = entry.getKey();
            if (!SegmentPreloadUtils.isSegmentOnlineOnRequestedInstance(segmentName, instanceId, instanceStateMap = entry.getValue()) || !SegmentPreloadUtils.isSegmentFromRequestedPartition(segmentName, tableNameWithType, partitionId, segmentZKMetadata = segmentMetadataMap.get(segmentName)) || segmentSelector != null && !segmentSelector.test(segmentName, segmentZKMetadata)) continue;
            futures.add(segmentPreloadExecutor.submit(() -> SegmentPreloadUtils.preloadSegment(segmentName, tableDataManager, partitionId, indexLoadingConfig, segmentZKMetadata)));
            preloadedSegments.add(segmentName);
        }
        SegmentPreloadUtils.waitForSegmentsPreloaded(futures);
        return preloadedSegments;
    }

    private static void preloadSegment(String segmentName, TableDataManager tableDataManager, int partitionId, IndexLoadingConfig indexLoadingConfig, SegmentZKMetadata segmentZKMetadata) {
        String tableNameWithType = tableDataManager.getTableName();
        try {
            LOGGER.info("Preload segment: {} from partition: {} of table: {}", new Object[]{segmentName, partitionId, tableNameWithType});
            tableDataManager.tryLoadExistingSegment(segmentZKMetadata, indexLoadingConfig);
            LOGGER.info("Preloaded segment: {} from partition: {} of table: {}", new Object[]{segmentName, partitionId, tableNameWithType});
        }
        catch (Exception e) {
            LOGGER.warn("Failed to preload segment: {} from partition: {} of table: {}, skipping", new Object[]{segmentName, partitionId, tableNameWithType, e});
        }
    }

    private static void waitForSegmentsPreloaded(List<Future<?>> futures) throws ExecutionException, InterruptedException {
        try {
            for (Future<?> f : futures) {
                f.get();
            }
        }
        finally {
            for (Future<?> f : futures) {
                if (f.isDone()) continue;
                f.cancel(true);
            }
        }
    }

    public static boolean hasValidDocIdsSnapshot(TableDataManager tableDataManager, TableConfig tableConfig, String segmentName, String segmentTier) {
        try {
            File indexDir = tableDataManager.getSegmentDataDir(segmentName, segmentTier, tableConfig);
            File snapshotFile = new File(SegmentDirectoryPaths.findSegmentDirectory((File)indexDir), "validdocids.bitmap.snapshot");
            return snapshotFile.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isSegmentOnlineOnRequestedInstance(String segmentName, String instanceId, Map<String, String> instanceStateMap) {
        String state = instanceStateMap.get(instanceId);
        if ("ONLINE".equals(state)) {
            return true;
        }
        if (state == null) {
            LOGGER.debug("Skip segment: {} as it's not assigned to instance: {}", (Object)segmentName, (Object)instanceId);
        } else {
            LOGGER.info("Skip segment: {} as its ideal state: {} is not ONLINE for instance: {}", new Object[]{segmentName, state, instanceId});
        }
        return false;
    }

    private static boolean isSegmentFromRequestedPartition(String segmentName, String tableNameWithType, int requestedPartitionId, SegmentZKMetadata segmentZKMetadata) {
        Preconditions.checkState((segmentZKMetadata != null ? 1 : 0) != 0, (String)"Failed to find ZK metadata for segment: %s, table: %s", (Object)segmentName, (Object)tableNameWithType);
        Integer partitionId = SegmentUtils.getRealtimeSegmentPartitionId((String)segmentName, (SegmentZKMetadata)segmentZKMetadata, null);
        Preconditions.checkNotNull((Object)partitionId, (Object)String.format("Failed to get partition id for segment: %s from table: %s", segmentName, tableNameWithType));
        if (partitionId == requestedPartitionId) {
            return true;
        }
        LOGGER.debug("Skip segment: {} as its partition: {} is different from the requested partition: {}", new Object[]{segmentName, partitionId, requestedPartitionId});
        return false;
    }

    private static String getInstanceId(TableDataManager tableDataManager) {
        return tableDataManager.getInstanceDataManagerConfig().getInstanceId();
    }

    private static Map<String, Map<String, String>> getSegmentAssignment(String tableNameWithType, HelixManager helixManager) {
        IdealState idealState = HelixHelper.getTableIdealState((HelixManager)helixManager, (String)tableNameWithType);
        Preconditions.checkState((idealState != null ? 1 : 0) != 0, (String)"Failed to find ideal state for table: %s", (Object)tableNameWithType);
        return idealState.getRecord().getMapFields();
    }

    private static Map<String, SegmentZKMetadata> getSegmentsZKMetadata(String tableNameWithType, HelixManager helixManager) {
        HashMap<String, SegmentZKMetadata> segmentMetadataMap = new HashMap<String, SegmentZKMetadata>();
        ZKMetadataProvider.getSegmentsZKMetadata((ZkHelixPropertyStore)helixManager.getHelixPropertyStore(), (String)tableNameWithType).forEach(m -> segmentMetadataMap.put(m.getSegmentName(), (SegmentZKMetadata)m));
        return segmentMetadataMap;
    }
}

