/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.Adler32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrcUtils.class);
    private static final int BUFFER_SIZE = 65536;
    private static final String CRC_FILE_EXTENSTION = ".crc";
    private final List<File> _files;

    private CrcUtils(List<File> files) {
        this._files = files;
    }

    public static CrcUtils forAllFilesInFolder(File dir) {
        ArrayList<File> normalFiles = new ArrayList<File>();
        CrcUtils.getAllNormalFiles(dir, normalFiles);
        Collections.sort(normalFiles);
        return new CrcUtils(normalFiles);
    }

    private static void getAllNormalFiles(File dir, List<File> normalFiles) {
        File[] files = dir.listFiles();
        Preconditions.checkNotNull((Object)files);
        for (File file : files) {
            if (file.isFile()) {
                if (file.getName().equals("creation.meta") || file.getName().endsWith(CRC_FILE_EXTENSTION)) continue;
                normalFiles.add(file);
                continue;
            }
            CrcUtils.getAllNormalFiles(file, normalFiles);
        }
    }

    public long computeCrc() throws IOException {
        byte[] buffer = new byte[65536];
        Adler32 checksum = new Adler32();
        for (File file : this._files) {
            try (FileInputStream input = new FileInputStream(file);){
                int len;
                while ((len = ((InputStream)input).read(buffer)) > 0) {
                    checksum.update(buffer, 0, len);
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Updated crc = {}, based on file {} of length {}", new Object[]{checksum.getValue(), file, file.length()});
            }
        }
        long crc = checksum.getValue();
        LOGGER.info("Computed crc = {}, based on files {}", (Object)crc, this._files);
        return crc;
    }
}

