/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class ArraySerDeUtils {
    private ArraySerDeUtils() {
    }

    public static byte[] serializeIntArrayWithLength(int[] values) {
        byte[] bytes = new byte[4 + values.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(values.length);
        ArraySerDeUtils.writeValues(byteBuffer, values);
        return bytes;
    }

    public static int[] deserializeIntArrayWithLength(byte[] bytes) {
        return ArraySerDeUtils.deserializeIntArrayWithLength(ByteBuffer.wrap(bytes));
    }

    public static int[] deserializeIntArrayWithLength(ByteBuffer byteBuffer) {
        int length = byteBuffer.getInt();
        int[] values = new int[length];
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return values;
    }

    public static int deserializeIntArrayWithLength(byte[] bytes, int[] values) {
        return ArraySerDeUtils.deserializeIntArrayWithLength(ByteBuffer.wrap(bytes), values);
    }

    public static int deserializeIntArrayWithLength(ByteBuffer byteBuffer, int[] values) {
        int length = byteBuffer.getInt();
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return length;
    }

    public static byte[] serializeIntArrayWithoutLength(int[] values) {
        byte[] bytes = new byte[values.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        ArraySerDeUtils.writeValues(byteBuffer, values);
        return bytes;
    }

    public static int[] deserializeIntArrayWithoutLength(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int length = bytes.length / 4;
        int[] values = new int[length];
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return values;
    }

    public static int deserializeIntArrayWithoutLength(byte[] bytes, int[] values) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int length = bytes.length / 4;
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return length;
    }

    private static void writeValues(ByteBuffer byteBuffer, int[] values) {
        for (int value : values) {
            byteBuffer.putInt(value);
        }
    }

    private static void readValues(ByteBuffer byteBuffer, int[] values, int length) {
        for (int i = 0; i < length; ++i) {
            values[i] = byteBuffer.getInt();
        }
    }

    public static byte[] serializeLongArrayWithLength(long[] values) {
        byte[] bytes = new byte[4 + values.length * 8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(values.length);
        ArraySerDeUtils.writeValues(byteBuffer, values);
        return bytes;
    }

    public static long[] deserializeLongArrayWithLength(byte[] bytes) {
        return ArraySerDeUtils.deserializeLongArrayWithLength(ByteBuffer.wrap(bytes));
    }

    public static long[] deserializeLongArrayWithLength(ByteBuffer byteBuffer) {
        int length = byteBuffer.getInt();
        long[] values = new long[length];
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return values;
    }

    public static int deserializeLongArrayWithLength(byte[] bytes, long[] values) {
        return ArraySerDeUtils.deserializeLongArrayWithLength(ByteBuffer.wrap(bytes), values);
    }

    public static int deserializeLongArrayWithLength(ByteBuffer byteBuffer, long[] values) {
        int length = byteBuffer.getInt();
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return length;
    }

    public static byte[] serializeLongArrayWithoutLength(long[] values) {
        byte[] bytes = new byte[values.length * 8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        ArraySerDeUtils.writeValues(byteBuffer, values);
        return bytes;
    }

    public static long[] deserializeLongArrayWithoutLength(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int length = bytes.length / 8;
        long[] values = new long[length];
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return values;
    }

    public static int deserializeLongArrayWithoutLength(byte[] bytes, long[] values) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int length = bytes.length / 8;
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return length;
    }

    private static void writeValues(ByteBuffer byteBuffer, long[] values) {
        for (long value : values) {
            byteBuffer.putLong(value);
        }
    }

    private static void readValues(ByteBuffer byteBuffer, long[] values, int length) {
        for (int i = 0; i < length; ++i) {
            values[i] = byteBuffer.getLong();
        }
    }

    public static byte[] serializeFloatArrayWithLength(float[] values) {
        byte[] bytes = new byte[4 + values.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(values.length);
        ArraySerDeUtils.writeValues(byteBuffer, values);
        return bytes;
    }

    public static float[] deserializeFloatArrayWithLength(byte[] bytes) {
        return ArraySerDeUtils.deserializeFloatArrayWithLength(ByteBuffer.wrap(bytes));
    }

    public static float[] deserializeFloatArrayWithLength(ByteBuffer byteBuffer) {
        int length = byteBuffer.getInt();
        float[] values = new float[length];
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return values;
    }

    public static int deserializeFloatArrayWithLength(byte[] bytes, float[] values) {
        return ArraySerDeUtils.deserializeFloatArrayWithLength(ByteBuffer.wrap(bytes), values);
    }

    public static int deserializeFloatArrayWithLength(ByteBuffer byteBuffer, float[] values) {
        int length = byteBuffer.getInt();
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return length;
    }

    public static byte[] serializeFloatArrayWithoutLength(float[] values) {
        byte[] bytes = new byte[values.length * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        ArraySerDeUtils.writeValues(byteBuffer, values);
        return bytes;
    }

    public static float[] deserializeFloatArrayWithoutLength(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int length = bytes.length / 4;
        float[] values = new float[length];
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return values;
    }

    public static int deserializeFloatArrayWithoutLength(byte[] bytes, float[] values) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int length = bytes.length / 4;
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return length;
    }

    private static void writeValues(ByteBuffer byteBuffer, float[] values) {
        for (float value : values) {
            byteBuffer.putFloat(value);
        }
    }

    private static void readValues(ByteBuffer byteBuffer, float[] values, int length) {
        for (int i = 0; i < length; ++i) {
            values[i] = byteBuffer.getFloat();
        }
    }

    public static byte[] serializeDoubleArrayWithLength(double[] values) {
        byte[] bytes = new byte[4 + values.length * 8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(values.length);
        ArraySerDeUtils.writeValues(byteBuffer, values);
        return bytes;
    }

    public static double[] deserializeDoubleArrayWithLength(byte[] bytes) {
        return ArraySerDeUtils.deserializeDoubleArrayWithLength(ByteBuffer.wrap(bytes));
    }

    public static double[] deserializeDoubleArrayWithLength(ByteBuffer byteBuffer) {
        int length = byteBuffer.getInt();
        double[] values = new double[length];
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return values;
    }

    public static int deserializeDoubleArrayWithLength(byte[] bytes, double[] values) {
        return ArraySerDeUtils.deserializeDoubleArrayWithLength(ByteBuffer.wrap(bytes), values);
    }

    public static int deserializeDoubleArrayWithLength(ByteBuffer byteBuffer, double[] values) {
        int length = byteBuffer.getInt();
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return length;
    }

    public static byte[] serializeDoubleArrayWithoutLength(double[] values) {
        byte[] bytes = new byte[values.length * 8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        ArraySerDeUtils.writeValues(byteBuffer, values);
        return bytes;
    }

    public static double[] deserializeDoubleArrayWithoutLength(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int length = bytes.length / 8;
        double[] values = new double[length];
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return values;
    }

    public static int deserializeDoubleArrayWithoutLength(byte[] bytes, double[] values) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int length = bytes.length / 8;
        ArraySerDeUtils.readValues(byteBuffer, values, length);
        return length;
    }

    private static void writeValues(ByteBuffer byteBuffer, double[] values) {
        for (double value : values) {
            byteBuffer.putDouble(value);
        }
    }

    private static void readValues(ByteBuffer byteBuffer, double[] values, int length) {
        for (int i = 0; i < length; ++i) {
            values[i] = byteBuffer.getDouble();
        }
    }

    public static byte[] serializeStringArray(String[] values) {
        int headerSize;
        int size = headerSize = 4 + 4 * values.length;
        byte[][] stringBytes = new byte[values.length][];
        for (int i = 0; i < values.length; ++i) {
            stringBytes[i] = values[i].getBytes(StandardCharsets.UTF_8);
            size += stringBytes[i].length;
        }
        return ArraySerDeUtils.writeValues(stringBytes, size, headerSize);
    }

    public static String[] deserializeStringArray(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int numValues = byteBuffer.getInt();
        String[] values = new String[numValues];
        ArraySerDeUtils.readValues(bytes, byteBuffer, values, numValues);
        return values;
    }

    public static int deserializeStringArray(byte[] bytes, String[] values) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int numValues = byteBuffer.getInt();
        ArraySerDeUtils.readValues(bytes, byteBuffer, values, numValues);
        return numValues;
    }

    public static byte[] serializeBytesArray(byte[][] values) {
        int headerSize;
        int size = headerSize = 4 + 4 * values.length;
        for (byte[] value : values) {
            size += value.length;
        }
        return ArraySerDeUtils.writeValues(values, size, headerSize);
    }

    public static byte[][] deserializeBytesArray(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int numValues = byteBuffer.getInt();
        byte[][] values = new byte[numValues][];
        ArraySerDeUtils.readValues(byteBuffer, values, numValues);
        return values;
    }

    public static int deserializeBytesArray(byte[] bytes, byte[][] values) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int numValues = byteBuffer.getInt();
        ArraySerDeUtils.readValues(byteBuffer, values, numValues);
        return numValues;
    }

    private static byte[] writeValues(byte[][] values, int size, int headerSize) {
        byte[] bytes = new byte[size];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(values.length);
        byteBuffer.position(headerSize);
        for (int i = 0; i < values.length; ++i) {
            byteBuffer.putInt((i + 1) * 4, values[i].length);
            byteBuffer.put(values[i]);
        }
        return bytes;
    }

    private static void readValues(byte[] bytes, ByteBuffer byteBuffer, String[] values, int numValues) {
        int offset = (numValues + 1) * 4;
        for (int i = 0; i < numValues; ++i) {
            int length = byteBuffer.getInt();
            values[i] = new String(bytes, offset, length, StandardCharsets.UTF_8);
            offset += length;
        }
    }

    private static void readValues(ByteBuffer byteBuffer, byte[][] values, int numValues) {
        byteBuffer.position((numValues + 1) * 4);
        for (int i = 0; i < numValues; ++i) {
            int length = byteBuffer.getInt((i + 1) * 4);
            values[i] = new byte[length];
            byteBuffer.get(values[i]);
        }
    }
}

