/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.segment.local.upsert.BasePartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.BaseTableUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.ConcurrentMapPartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.ConcurrentMapPartitionUpsertMetadataManagerForConsistentDeletes;
import org.apache.pinot.segment.local.upsert.UpsertUtils;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConcurrentMapTableUpsertMetadataManager
extends BaseTableUpsertMetadataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentMapTableUpsertMetadataManager.class);
    private final Map<Integer, BasePartitionUpsertMetadataManager> _partitionMetadataManagerMap = new ConcurrentHashMap<Integer, BasePartitionUpsertMetadataManager>();

    @Override
    public BasePartitionUpsertMetadataManager getOrCreatePartitionManager(int partitionId) {
        return this._partitionMetadataManagerMap.computeIfAbsent(partitionId, k -> this._enableDeletedKeysCompactionConsistency ? new ConcurrentMapPartitionUpsertMetadataManagerForConsistentDeletes(this._tableNameWithType, (int)k, this._context) : new ConcurrentMapPartitionUpsertMetadataManager(this._tableNameWithType, (int)k, this._context));
    }

    @Override
    public void stop() {
        for (BasePartitionUpsertMetadataManager metadataManager : this._partitionMetadataManagerMap.values()) {
            metadataManager.stop();
        }
    }

    @Override
    public Map<Integer, Long> getPartitionToPrimaryKeyCount() {
        HashMap<Integer, Long> partitionToPrimaryKeyCount = new HashMap<Integer, Long>();
        this._partitionMetadataManagerMap.forEach((partitionID, upsertMetadataManager) -> partitionToPrimaryKeyCount.put((Integer)partitionID, upsertMetadataManager.getNumPrimaryKeys()));
        return partitionToPrimaryKeyCount;
    }

    @Override
    public void lockForSegmentContexts() {
        this._partitionMetadataManagerMap.forEach((partitionID, upsertMetadataManager) -> upsertMetadataManager.getUpsertViewManager().lockTrackedSegments());
    }

    @Override
    public void unlockForSegmentContexts() {
        this._partitionMetadataManagerMap.forEach((partitionID, upsertMetadataManager) -> upsertMetadataManager.getUpsertViewManager().unlockTrackedSegments());
    }

    @Override
    public Set<String> getNewlyAddedSegments() {
        HashSet<String> newlyAddedSegments = new HashSet<String>();
        this._partitionMetadataManagerMap.forEach((partitionID, upsertMetadataManager) -> newlyAddedSegments.addAll(upsertMetadataManager.getNewlyAddedSegments()));
        return newlyAddedSegments;
    }

    @Override
    public void setSegmentContexts(List<SegmentContext> segmentContexts, Map<String, String> queryOptions) {
        if (this._consistencyMode == UpsertConfig.ConsistencyMode.NONE || QueryOptionsUtils.isSkipUpsertView(queryOptions)) {
            for (SegmentContext segmentContext : segmentContexts) {
                IndexSegment segment = segmentContext.getIndexSegment();
                segmentContext.setQueryableDocIdsSnapshot(UpsertUtils.getQueryableDocIdsSnapshotFromSegment(segment));
            }
            return;
        }
        this._partitionMetadataManagerMap.forEach((partitionID, upsertMetadataManager) -> upsertMetadataManager.getUpsertViewManager().setSegmentContexts(segmentContexts, queryOptions));
        if (LOGGER.isDebugEnabled()) {
            for (SegmentContext segmentContext : segmentContexts) {
                IndexSegment segment = segmentContext.getIndexSegment();
                if (segmentContext.getQueryableDocIdsSnapshot() == null) {
                    LOGGER.debug("No upsert view for segment: {}, type: {}, total: {}", new Object[]{segment.getSegmentName(), segment instanceof ImmutableSegment ? "imm" : "mut", segment.getSegmentMetadata().getTotalDocs()});
                    continue;
                }
                int cardCnt = segmentContext.getQueryableDocIdsSnapshot().getCardinality();
                LOGGER.debug("Got upsert view of segment: {}, type: {}, total: {}, valid: {}", new Object[]{segment.getSegmentName(), segment instanceof ImmutableSegment ? "imm" : "mut", segment.getSegmentMetadata().getTotalDocs(), cardCnt});
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (BasePartitionUpsertMetadataManager metadataManager : this._partitionMetadataManagerMap.values()) {
            metadataManager.close();
        }
    }
}

