/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.segment.spi.utils.SegmentMetadataUtils;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.data.Schema;

public class StarTreeBuilderUtils {
    public static final int INVALID_ID = -1;

    private StarTreeBuilderUtils() {
    }

    public static List<StarTreeV2BuilderConfig> generateBuilderConfigs(@Nullable List<StarTreeIndexConfig> indexConfigs, boolean enableDefaultStarTree, SegmentMetadata segmentMetadata) {
        StarTreeV2BuilderConfig defaultConfig;
        ArrayList<StarTreeV2BuilderConfig> builderConfigs = new ArrayList<StarTreeV2BuilderConfig>();
        if (indexConfigs != null) {
            for (StarTreeIndexConfig indexConfig : indexConfigs) {
                StarTreeV2BuilderConfig builderConfig = StarTreeV2BuilderConfig.fromIndexConfig(indexConfig);
                if (builderConfigs.contains(builderConfig)) continue;
                builderConfigs.add(builderConfig);
            }
        }
        if (enableDefaultStarTree && !builderConfigs.contains(defaultConfig = StarTreeV2BuilderConfig.generateDefaultConfig(segmentMetadata))) {
            builderConfigs.add(defaultConfig);
        }
        return builderConfigs;
    }

    public static List<StarTreeV2BuilderConfig> generateBuilderConfigs(@Nullable List<StarTreeIndexConfig> indexConfigs, boolean enableDefaultStarTree, Schema schema, JsonNode segmentMetadata) {
        StarTreeV2BuilderConfig defaultConfig;
        ArrayList<StarTreeV2BuilderConfig> builderConfigs = new ArrayList<StarTreeV2BuilderConfig>();
        if (indexConfigs != null) {
            for (StarTreeIndexConfig indexConfig : indexConfigs) {
                StarTreeV2BuilderConfig builderConfig = StarTreeV2BuilderConfig.fromIndexConfig(indexConfig);
                if (builderConfigs.contains(builderConfig)) continue;
                builderConfigs.add(builderConfig);
            }
        }
        if (enableDefaultStarTree && !builderConfigs.contains(defaultConfig = StarTreeV2BuilderConfig.generateDefaultConfig(schema, segmentMetadata.get("columns")))) {
            builderConfigs.add(defaultConfig);
        }
        return builderConfigs;
    }

    public static void serializeTree(File starTreeFile, TreeNode rootNode, String[] dimensions, int numNodes) throws IOException {
        int headerSizeInBytes = StarTreeBuilderUtils.computeHeaderByteSize(dimensions);
        long totalSizeInBytes = (long)headerSizeInBytes + (long)numNodes * 28L;
        try (PinotDataBuffer buffer = PinotDataBuffer.mapFile((File)starTreeFile, (boolean)false, (long)0L, (long)totalSizeInBytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (String)"StarTreeBuilderUtils#serializeTree: star-tree buffer");){
            long offset = StarTreeBuilderUtils.writeHeader(buffer, headerSizeInBytes, dimensions, numNodes);
            StarTreeBuilderUtils.writeNodes(buffer, offset, rootNode);
        }
    }

    private static int computeHeaderByteSize(String[] dimensions) {
        int headerSizeInBytes = 20;
        for (String dimension : dimensions) {
            headerSizeInBytes += 4;
            headerSizeInBytes += 4;
            headerSizeInBytes += dimension.getBytes(StandardCharsets.UTF_8).length;
        }
        return headerSizeInBytes += 4;
    }

    private static int writeHeader(PinotDataBuffer dataBuffer, int headerSizeInBytes, String[] dimensions, int numNodes) {
        int offset = 0;
        dataBuffer.putLong(offset, -4981643802526953459L);
        dataBuffer.putInt(offset += 8, 1);
        dataBuffer.putInt(offset += 4, headerSizeInBytes);
        int numDimensions = dimensions.length;
        dataBuffer.putInt(offset += 4, numDimensions);
        offset += 4;
        for (int i = 0; i < numDimensions; ++i) {
            dataBuffer.putInt(offset, i);
            String dimension = dimensions[i];
            byte[] dimensionBytes = dimension.getBytes(StandardCharsets.UTF_8);
            int dimensionLength = dimensionBytes.length;
            dataBuffer.putInt(offset += 4, dimensionLength);
            dataBuffer.readFrom((long)(offset += 4), dimensionBytes, 0, dimensionLength);
            offset += dimensionLength;
        }
        dataBuffer.putInt(offset, numNodes);
        return offset += 4;
    }

    private static void writeNodes(PinotDataBuffer dataBuffer, long offset, TreeNode rootNode) {
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        queue.add(rootNode);
        int currentNodeId = 0;
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.remove();
            if (node._children == null) {
                offset = StarTreeBuilderUtils.writeNode(dataBuffer, offset, node, -1, -1);
            } else {
                ArrayList<TreeNode> sortedChildren = new ArrayList<TreeNode>(node._children.values());
                sortedChildren.sort((o1, o2) -> Integer.compare(o1._dimensionValue, o2._dimensionValue));
                int firstChildId = currentNodeId + queue.size() + 1;
                int lastChildId = firstChildId + sortedChildren.size() - 1;
                offset = StarTreeBuilderUtils.writeNode(dataBuffer, offset, node, firstChildId, lastChildId);
                queue.addAll(sortedChildren);
            }
            ++currentNodeId;
        }
    }

    private static long writeNode(PinotDataBuffer dataBuffer, long offset, TreeNode node, int firstChildId, int lastChildId) {
        dataBuffer.putInt(offset, node._dimensionId);
        dataBuffer.putInt(offset += 4L, node._dimensionValue);
        dataBuffer.putInt(offset += 4L, node._startDocId);
        dataBuffer.putInt(offset += 4L, node._endDocId);
        dataBuffer.putInt(offset += 4L, node._aggregatedDocId);
        dataBuffer.putInt(offset += 4L, firstChildId);
        dataBuffer.putInt(offset += 4L, lastChildId);
        return offset += 4L;
    }

    public static boolean shouldModifyExistingStarTrees(List<StarTreeV2BuilderConfig> builderConfigs, List<StarTreeV2Metadata> metadataList) {
        int numStarTrees = builderConfigs.size();
        if (metadataList.size() != numStarTrees) {
            return true;
        }
        for (int i = 0; i < numStarTrees; ++i) {
            StarTreeV2BuilderConfig builderConfig = builderConfigs.get(i);
            StarTreeV2Metadata metadata = metadataList.get(i);
            if (!builderConfig.getDimensionsSplitOrder().equals(metadata.getDimensionsSplitOrder())) {
                return true;
            }
            if (!builderConfig.getSkipStarNodeCreationForDimensions().equals(metadata.getSkipStarNodeCreationForDimensions())) {
                return true;
            }
            if (!builderConfig.getAggregationSpecs().equals(metadata.getAggregationSpecs())) {
                return true;
            }
            if (builderConfig.getMaxLeafRecords() == metadata.getMaxLeafRecords()) continue;
            return true;
        }
        return false;
    }

    public static boolean areStarTreeBuilderConfigListsEqual(List<StarTreeV2BuilderConfig> builderConfig1, List<StarTreeV2BuilderConfig> builderConfig2) {
        int numStarTrees = builderConfig1.size();
        if (builderConfig2.size() != numStarTrees) {
            return false;
        }
        for (int i = 0; i < numStarTrees; ++i) {
            StarTreeV2BuilderConfig builderConfigToCompare2;
            StarTreeV2BuilderConfig builderConfigToCompare1 = builderConfig1.get(i);
            if (builderConfigToCompare1.equals(builderConfigToCompare2 = builderConfig2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void removeStarTrees(File indexDir) throws Exception {
        PropertiesConfiguration metadataProperties = SegmentMetadataUtils.getPropertiesConfiguration((File)indexDir);
        metadataProperties.subset("startree.v2").clear();
        SegmentMetadataUtils.savePropertiesConfiguration((PropertiesConfiguration)metadataProperties, (File)indexDir);
        File segmentDirectory = SegmentDirectoryPaths.findSegmentDirectory((File)indexDir);
        FileUtils.forceDelete((File)new File(segmentDirectory, "star_tree_index"));
        FileUtils.forceDelete((File)new File(segmentDirectory, "star_tree_index_map"));
    }

    public static List<ExpressionContext> expressionContextFromFunctionParameters(AggregationFunctionType aggregationFunctionType, Map<String, Object> functionParameters) {
        ArrayList<ExpressionContext> expressionContexts = new ArrayList<ExpressionContext>();
        switch (aggregationFunctionType) {
            case DISTINCTCOUNTHLL: 
            case DISTINCTCOUNTRAWHLL: {
                if (!functionParameters.containsKey("log2m")) break;
                expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("log2m"))))));
                break;
            }
            case DISTINCTCOUNTHLLPLUS: 
            case DISTINCTCOUNTRAWHLLPLUS: {
                if (functionParameters.containsKey("p") && functionParameters.containsKey("sp")) {
                    expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("p"))))));
                    expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("sp"))))));
                    break;
                }
                if (functionParameters.containsKey("p")) {
                    expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("p"))))));
                    break;
                }
                if (!functionParameters.containsKey("sp")) break;
                expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(14)))));
                expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("sp"))))));
                break;
            }
            case DISTINCTCOUNTULL: 
            case DISTINCTCOUNTRAWULL: {
                if (!functionParameters.containsKey("p")) break;
                expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("p"))))));
                break;
            }
            case DISTINCTCOUNTCPCSKETCH: 
            case DISTINCTCOUNTRAWCPCSKETCH: {
                if (!functionParameters.containsKey("lgK")) break;
                expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("lgK"))))));
                break;
            }
            case SUMPRECISION: {
                if (!functionParameters.containsKey("precision")) break;
                expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("precision"))))));
                break;
            }
            case PERCENTILETDIGEST: 
            case PERCENTILERAWTDIGEST: {
                if (!functionParameters.containsKey("compressionFactor")) break;
                expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("compressionFactor"))))));
                break;
            }
            case DISTINCTCOUNTTHETASKETCH: 
            case DISTINCTCOUNTRAWTHETASKETCH: {
                if (!functionParameters.containsKey("nominalEntries")) break;
                expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("nominalEntries"))))));
                break;
            }
            case DISTINCTCOUNTTUPLESKETCH: 
            case DISTINCTCOUNTRAWINTEGERSUMTUPLESKETCH: {
                if (!functionParameters.containsKey("nominalEntries")) break;
                expressionContexts.add(ExpressionContext.forLiteral((Literal)Literal.intValue((int)Integer.parseInt(String.valueOf(functionParameters.get("nominalEntries"))))));
                break;
            }
        }
        return expressionContexts;
    }

    public static class TreeNode {
        public int _dimensionId = -1;
        public int _dimensionValue = -1;
        public int _startDocId = -1;
        public int _endDocId = -1;
        public int _aggregatedDocId = -1;
        public int _childDimensionId = -1;
        public Map<Integer, TreeNode> _children;
    }
}

