/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.readers;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.ByteArray;

public class PrimaryKeyReader
implements Closeable {
    public final List<PinotSegmentColumnReader> _primaryKeyColumnReaders;

    public PrimaryKeyReader(IndexSegment segment, List<String> primaryKeyColumns) {
        this._primaryKeyColumnReaders = new ArrayList<PinotSegmentColumnReader>(primaryKeyColumns.size());
        for (String primaryKeyColumn : primaryKeyColumns) {
            this._primaryKeyColumnReaders.add(new PinotSegmentColumnReader(segment, primaryKeyColumn));
        }
    }

    public PrimaryKey getPrimaryKey(int docId) {
        int numPrimaryKeys = this._primaryKeyColumnReaders.size();
        Object[] values = new Object[numPrimaryKeys];
        for (int i = 0; i < numPrimaryKeys; ++i) {
            values[i] = PrimaryKeyReader.getValue(this._primaryKeyColumnReaders.get(i), docId);
        }
        return new PrimaryKey(values);
    }

    public void getPrimaryKey(int docId, PrimaryKey buffer) {
        Object[] values = buffer.getValues();
        int numPrimaryKeys = values.length;
        for (int i = 0; i < numPrimaryKeys; ++i) {
            values[i] = PrimaryKeyReader.getValue(this._primaryKeyColumnReaders.get(i), docId);
        }
    }

    @Override
    public void close() throws IOException {
        for (PinotSegmentColumnReader primaryKeyColumnReader : this._primaryKeyColumnReaders) {
            primaryKeyColumnReader.close();
        }
    }

    private static Object getValue(PinotSegmentColumnReader columnReader, int docId) {
        Object value = columnReader.getValue(docId);
        return value instanceof byte[] ? new ByteArray((byte[])value) : value;
    }
}

