/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.readers.forward.BaseChunkForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.ChunkReaderContext;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.MapUtils;

public final class VarByteChunkSVForwardIndexReader
extends BaseChunkForwardIndexReader {
    private static final int ROW_OFFSET_SIZE = 4;
    private final int _maxChunkSize;
    private static ThreadLocal<byte[]> _reusableBytes = ThreadLocal.withInitial(() -> new byte[0]);

    public VarByteChunkSVForwardIndexReader(PinotDataBuffer dataBuffer, FieldSpec.DataType valueType) {
        super(dataBuffer, valueType, true);
        this._maxChunkSize = this._numDocsPerChunk * (4 + this._lengthOfLongestEntry);
    }

    @Nullable
    public ChunkReaderContext createContext() {
        if (this._isCompressed) {
            return new ChunkReaderContext(this._maxChunkSize);
        }
        return null;
    }

    public BigDecimal getBigDecimal(int docId, ChunkReaderContext context) {
        return BigDecimalUtils.deserialize((byte[])this.getBytes(docId, context));
    }

    public String getString(int docId, ChunkReaderContext context) {
        if (this._isCompressed) {
            return this.getStringCompressed(docId, context);
        }
        return this.getStringUncompressed(docId);
    }

    private String getStringCompressed(int docId, ChunkReaderContext context) {
        int chunkRowId = docId % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
        int valueStartOffset = chunkBuffer.getInt(chunkRowId * 4);
        int valueEndOffset = this.getValueEndOffset(chunkRowId, chunkBuffer);
        int length = valueEndOffset - valueStartOffset;
        byte[] bytes = this.getOrExpandByteArray();
        chunkBuffer.position(valueStartOffset);
        chunkBuffer.get(bytes, 0, length);
        return new String(bytes, 0, length, StandardCharsets.UTF_8);
    }

    private String getStringUncompressed(int docId) {
        int chunkId = docId / this._numDocsPerChunk;
        int chunkRowId = docId % this._numDocsPerChunk;
        long chunkStartOffset = this.getChunkPosition(chunkId);
        long valueStartOffset = chunkStartOffset + (long)this._dataBuffer.getInt(chunkStartOffset + (long)chunkRowId * 4L);
        long valueEndOffset = this.getValueEndOffset(chunkId, chunkRowId, chunkStartOffset);
        int length = (int)(valueEndOffset - valueStartOffset);
        byte[] bytes = this.getOrExpandByteArray();
        this._dataBuffer.copyTo(valueStartOffset, bytes, 0, length);
        return new String(bytes, 0, length, StandardCharsets.UTF_8);
    }

    private byte[] getOrExpandByteArray() {
        byte[] bytes = _reusableBytes.get();
        if (bytes.length < this._lengthOfLongestEntry) {
            _reusableBytes.set(new byte[this._lengthOfLongestEntry]);
            bytes = _reusableBytes.get();
        }
        return bytes;
    }

    public byte[] getBytes(int docId, ChunkReaderContext context) {
        if (this._isCompressed) {
            return this.getBytesCompressed(docId, context);
        }
        return this.getBytesUncompressed(docId);
    }

    public Map getMap(int docId, ChunkReaderContext context) {
        return MapUtils.deserializeMap((byte[])this.getBytes(docId, context));
    }

    private byte[] getBytesCompressed(int docId, ChunkReaderContext context) {
        int chunkRowId = docId % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
        int valueStartOffset = chunkBuffer.getInt(chunkRowId * 4);
        int valueEndOffset = this.getValueEndOffset(chunkRowId, chunkBuffer);
        byte[] bytes = new byte[valueEndOffset - valueStartOffset];
        chunkBuffer.position(valueStartOffset);
        chunkBuffer.get(bytes);
        return bytes;
    }

    private byte[] getBytesUncompressed(int docId) {
        int chunkId = docId / this._numDocsPerChunk;
        int chunkRowId = docId % this._numDocsPerChunk;
        long chunkStartOffset = this.getChunkPosition(chunkId);
        long valueStartOffset = chunkStartOffset + (long)this._dataBuffer.getInt(chunkStartOffset + (long)chunkRowId * 4L);
        long valueEndOffset = this.getValueEndOffset(chunkId, chunkRowId, chunkStartOffset);
        byte[] bytes = new byte[(int)(valueEndOffset - valueStartOffset)];
        this._dataBuffer.copyTo(valueStartOffset, bytes);
        return bytes;
    }

    private int getValueEndOffset(int rowId, ByteBuffer chunkBuffer) {
        if (rowId == this._numDocsPerChunk - 1) {
            return chunkBuffer.limit();
        }
        int valueEndOffset = chunkBuffer.getInt((rowId + 1) * 4);
        if (valueEndOffset == 0) {
            return chunkBuffer.limit();
        }
        return valueEndOffset;
    }

    private long getValueEndOffset(int chunkId, int chunkRowId, long chunkStartOffset) {
        if (chunkId == this._numChunks - 1) {
            if (chunkRowId == this._numDocsPerChunk - 1) {
                return this._dataBuffer.size();
            }
            int valueEndOffsetInChunk = this._dataBuffer.getInt(chunkStartOffset + (long)(chunkRowId + 1) * 4L);
            if (valueEndOffsetInChunk == 0) {
                return this._dataBuffer.size();
            }
            return chunkStartOffset + (long)valueEndOffsetInChunk;
        }
        if (chunkRowId == this._numDocsPerChunk - 1) {
            return this.getChunkPosition(chunkId + 1);
        }
        return chunkStartOffset + (long)this._dataBuffer.getInt(chunkStartOffset + (long)(chunkRowId + 1) * 4L);
    }

    public boolean isBufferByteRangeInfoSupported() {
        return true;
    }

    public void recordDocIdByteRanges(int docId, ChunkReaderContext context, List<ForwardIndexReader.ByteRange> ranges) {
        if (this._isCompressed) {
            this.recordDocIdRanges(docId, context, ranges);
        } else {
            this.recordDocIdRangesUncompressed(docId, 4, ranges);
        }
    }

    public boolean isFixedOffsetMappingType() {
        return false;
    }

    public long getRawDataStartOffset() {
        throw new UnsupportedOperationException("Forward index is not of fixed length type");
    }

    public int getDocLength() {
        throw new UnsupportedOperationException("Forward index is not of fixed length type");
    }
}

