/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTReader;
import org.apache.lucene.util.fst.OffHeapFSTStore;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.pinot.segment.local.utils.fst.PinotBufferIndexInput;
import org.apache.pinot.segment.local.utils.fst.RegexpMatcher;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneFSTIndexReader
implements TextIndexReader {
    public static final Logger LOGGER = LoggerFactory.getLogger(LuceneFSTIndexReader.class);
    private final PinotDataBuffer _dataBuffer;
    private final PinotBufferIndexInput _dataBufferIndexInput;
    private final FST<Long> _readFST;

    public LuceneFSTIndexReader(PinotDataBuffer pinotDataBuffer) throws IOException {
        this._dataBuffer = pinotDataBuffer;
        this._dataBufferIndexInput = new PinotBufferIndexInput(this._dataBuffer, 0L, this._dataBuffer.size());
        FST.FSTMetadata metadata = FST.readMetadata((DataInput)this._dataBufferIndexInput, (Outputs)PositiveIntOutputs.getSingleton());
        OffHeapFSTStore fstStore = new OffHeapFSTStore((IndexInput)this._dataBufferIndexInput, this._dataBufferIndexInput.getFilePointer(), metadata);
        this._readFST = FST.fromFSTReader((FST.FSTMetadata)metadata, (FSTReader)fstStore);
    }

    public MutableRoaringBitmap getDocIds(String searchQuery) {
        throw new RuntimeException("LuceneFSTIndexReader only supports getDictIds currently.");
    }

    public ImmutableRoaringBitmap getDictIds(String searchQuery) {
        try {
            MutableRoaringBitmap dictIds = new MutableRoaringBitmap();
            List<Long> matchingIds = RegexpMatcher.regexMatch(searchQuery, this._readFST);
            for (Long matchingId : matchingIds) {
                dictIds.add(matchingId.intValue());
            }
            return dictIds.toImmutableRoaringBitmap();
        }
        catch (Exception ex) {
            LOGGER.error("Error getting matching Ids from FST", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void close() throws IOException {
    }
}

