/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.map;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.index.reader.MapIndexReader;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.index.reader.VectorIndexReader;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;

public class NullDataSource
implements DataSource {
    private final NullDataSourceMetadata _md;
    private final ColumnIndexContainer _indexes;

    public NullDataSource(String name) {
        this._md = new NullDataSourceMetadata(name);
        this._indexes = new ColumnIndexContainer.FromMap(Map.of(StandardIndexes.forward(), new NullForwardIndex()));
    }

    public DataSourceMetadata getDataSourceMetadata() {
        return this._md;
    }

    public ColumnIndexContainer getIndexContainer() {
        return this._indexes;
    }

    public <R extends IndexReader> R getIndex(IndexType<?, R, ?> type) {
        return (R)type.getIndexReader(this._indexes);
    }

    public ForwardIndexReader<?> getForwardIndex() {
        return (ForwardIndexReader)this.getIndex(StandardIndexes.forward());
    }

    @Nullable
    public Dictionary getDictionary() {
        return (Dictionary)this.getIndex(StandardIndexes.dictionary());
    }

    @Nullable
    public InvertedIndexReader<?> getInvertedIndex() {
        return (InvertedIndexReader)this.getIndex(StandardIndexes.inverted());
    }

    @Nullable
    public RangeIndexReader<?> getRangeIndex() {
        return (RangeIndexReader)this.getIndex(StandardIndexes.range());
    }

    @Nullable
    public TextIndexReader getTextIndex() {
        return (TextIndexReader)this.getIndex(StandardIndexes.text());
    }

    @Nullable
    public TextIndexReader getFSTIndex() {
        return (TextIndexReader)this.getIndex(StandardIndexes.fst());
    }

    @Nullable
    public JsonIndexReader getJsonIndex() {
        return (JsonIndexReader)this.getIndex(StandardIndexes.json());
    }

    @Nullable
    public H3IndexReader getH3Index() {
        return (H3IndexReader)this.getIndex(StandardIndexes.h3());
    }

    @Nullable
    public BloomFilterReader getBloomFilter() {
        return (BloomFilterReader)this.getIndex(StandardIndexes.bloomFilter());
    }

    @Nullable
    public NullValueVectorReader getNullValueVector() {
        return (NullValueVectorReader)this.getIndex(StandardIndexes.nullValueVector());
    }

    @Nullable
    public VectorIndexReader getVectorIndex() {
        return (VectorIndexReader)this.getIndex(StandardIndexes.vector());
    }

    @Nullable
    public MapIndexReader getMapIndex() {
        return (MapIndexReader)this.getIndex(StandardIndexes.map());
    }

    public class NullForwardIndex
    implements ForwardIndexReader<ForwardIndexReaderContext> {
        NullForwardIndex() {
        }

        public boolean isDictionaryEncoded() {
            return false;
        }

        public boolean isSingleValue() {
            return false;
        }

        public FieldSpec.DataType getStoredType() {
            return FieldSpec.DataType.INT;
        }

        public int getInt(int docId, ForwardIndexReaderContext context) {
            return FieldSpec.DEFAULT_DIMENSION_NULL_VALUE_OF_INT;
        }

        public long getLong(int docId, ForwardIndexReaderContext context) {
            throw new UnsupportedOperationException();
        }

        public float getFloat(int docId, ForwardIndexReaderContext context) {
            throw new UnsupportedOperationException();
        }

        public double getDouble(int docId, ForwardIndexReaderContext context) {
            throw new UnsupportedOperationException();
        }

        public String getString(int docId, ForwardIndexReaderContext context) {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }

    public static class NullDataSourceMetadata
    implements DataSourceMetadata {
        String _name;

        NullDataSourceMetadata(String name) {
            this._name = name;
        }

        public FieldSpec getFieldSpec() {
            return new DimensionFieldSpec(this._name, FieldSpec.DataType.INT, true);
        }

        public boolean isSorted() {
            return false;
        }

        public int getNumDocs() {
            return 0;
        }

        public int getNumValues() {
            return 0;
        }

        public int getMaxNumValuesPerMVEntry() {
            return 0;
        }

        @Nullable
        public Comparable getMinValue() {
            return FieldSpec.DEFAULT_DIMENSION_NULL_VALUE_OF_INT;
        }

        @Nullable
        public Comparable getMaxValue() {
            return FieldSpec.DEFAULT_DIMENSION_NULL_VALUE_OF_INT;
        }

        @Nullable
        public PartitionFunction getPartitionFunction() {
            return null;
        }

        @Nullable
        public Set<Integer> getPartitions() {
            return null;
        }

        public int getCardinality() {
            return 1;
        }
    }
}

