/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.map;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;

public class MapKeyIndexReader
implements ForwardIndexReader {
    private final ForwardIndexReader _forwardIndexReader;
    private final FieldSpec _keyFieldSpec;
    private final String _keyName;
    private final Object _defaultNullValue;

    public MapKeyIndexReader(ForwardIndexReader forwardIndexReader, String keyName, FieldSpec keyFieldSpec) {
        this._forwardIndexReader = forwardIndexReader;
        this._keyName = keyName;
        this._keyFieldSpec = keyFieldSpec;
        this._defaultNullValue = keyFieldSpec.getDefaultNullValue();
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return this._keyFieldSpec.getDataType();
    }

    public int getInt(int docId, ForwardIndexReaderContext context) {
        return Integer.parseInt(this.extractMapValue(docId, context, this._keyName).toString());
    }

    public long getLong(int docId, ForwardIndexReaderContext context) {
        return Long.parseLong(this.extractMapValue(docId, context, this._keyName).toString());
    }

    public float getFloat(int docId, ForwardIndexReaderContext context) {
        return Float.parseFloat(this.extractMapValue(docId, context, this._keyName).toString());
    }

    public double getDouble(int docId, ForwardIndexReaderContext context) {
        return Double.parseDouble(this.extractMapValue(docId, context, this._keyName).toString());
    }

    public String getString(int docId, ForwardIndexReaderContext context) {
        return this.extractMapValue(docId, context, this._keyName).toString();
    }

    public byte[] getBytes(int docId, ForwardIndexReaderContext context) {
        return (byte[])this.extractMapValue(docId, context, this._keyName);
    }

    public BigDecimal getBigDecimal(int docId, ForwardIndexReaderContext context) {
        return BigDecimalUtils.deserialize((byte[])((byte[])this.extractMapValue(docId, context, this._keyName)));
    }

    private Object extractMapValue(int docId, ForwardIndexReaderContext context, String key) {
        Map map = this._forwardIndexReader.getMap(docId, context);
        Object object = map.get(key);
        if (object == null) {
            return this._defaultNullValue;
        }
        return object;
    }

    public void close() throws IOException {
    }

    @Nullable
    public ForwardIndexReaderContext createContext() {
        return this._forwardIndexReader.createContext();
    }
}

