/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.map;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.map.MapKeyIndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.MapIndexReader;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.ComplexFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;

public class MapIndexReaderWrapper
implements MapIndexReader {
    private final ForwardIndexReader _forwardIndexReader;
    private final ComplexFieldSpec.MapFieldSpec _mapFieldSpec;

    public MapIndexReaderWrapper(ForwardIndexReader forwardIndexReader, ComplexFieldSpec.MapFieldSpec mapFieldSpec) {
        this._forwardIndexReader = forwardIndexReader;
        this._mapFieldSpec = mapFieldSpec;
    }

    public Set<String> getKeys() {
        throw new UnsupportedOperationException();
    }

    public Map<IndexType, IndexReader> getKeyIndexes(String key) {
        return Map.of(StandardIndexes.forward(), new MapKeyIndexReader(this._forwardIndexReader, key, this.getKeyFieldSpec(key)));
    }

    public FieldSpec getKeyFieldSpec(String key) {
        return this._mapFieldSpec.getValueFieldSpec();
    }

    public FieldSpec.DataType getKeyStoredType(String key) {
        return this._mapFieldSpec.getValueFieldSpec().getDataType();
    }

    public ColumnMetadata getKeyMetadata(String key) {
        return new ColumnMetadata(){

            public FieldSpec getFieldSpec() {
                return MapIndexReaderWrapper.this._mapFieldSpec.getValueFieldSpec();
            }

            public int getTotalDocs() {
                return 0;
            }

            public int getCardinality() {
                return 0;
            }

            public boolean isSorted() {
                return false;
            }

            public Comparable getMinValue() {
                return null;
            }

            public Comparable getMaxValue() {
                return null;
            }

            public boolean hasDictionary() {
                return false;
            }

            public int getColumnMaxLength() {
                return 0;
            }

            public int getBitsPerElement() {
                return 0;
            }

            public int getMaxNumberOfMultiValues() {
                return 0;
            }

            public int getTotalNumberOfEntries() {
                return 0;
            }

            @Nullable
            public PartitionFunction getPartitionFunction() {
                return null;
            }

            @Nullable
            public Set<Integer> getPartitions() {
                return null;
            }

            public Map<IndexType<?, ?, ?>, Long> getIndexSizeMap() {
                return Map.of();
            }

            public boolean isAutoGenerated() {
                return false;
            }
        };
    }

    public IndexReader getKeyReader(String key, IndexType indexType) {
        return this.getKeyIndexes(key).get(indexType);
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return FieldSpec.DataType.MAP;
    }

    public void close() throws IOException {
    }
}

