/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.map;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.map.BaseMapDataSource;
import org.apache.pinot.segment.local.segment.index.map.MapIndexReaderWrapper;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.index.reader.MapIndexReader;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableMapDataSource
extends BaseMapDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableMapDataSource.class);
    private final MapIndexReader _mapIndexReader;

    public ImmutableMapDataSource(ColumnMetadata columnMetadata, ColumnIndexContainer columnIndexContainer) {
        super(new ImmutableMapDataSourceMetadata(columnMetadata), columnIndexContainer);
        Object mapIndexReader = this.getMapIndex();
        if (mapIndexReader == null) {
            ForwardIndexReader<?> forwardIndex = this.getForwardIndex();
            mapIndexReader = forwardIndex instanceof MapIndexReader ? (MapIndexReader)forwardIndex : new MapIndexReaderWrapper(forwardIndex, this.getFieldSpec());
        }
        this._mapIndexReader = mapIndexReader;
    }

    public MapIndexReader<ForwardIndexReaderContext, IndexReader> getMapIndexReader() {
        return this._mapIndexReader;
    }

    @Override
    public DataSourceMetadata getKeyDataSourceMetadata(String key) {
        return null;
    }

    @Override
    public ColumnIndexContainer getKeyIndexContainer(String key) {
        return null;
    }

    private static class ImmutableMapDataSourceMetadata
    implements DataSourceMetadata {
        final FieldSpec _fieldSpec;
        final int _numDocs;
        final int _numValues;
        final int _maxNumValuesPerMVEntry;
        final int _cardinality;
        final PartitionFunction _partitionFunction;
        final Set<Integer> _partitions;
        final Comparable _minValue;
        final Comparable _maxValue;

        ImmutableMapDataSourceMetadata(ColumnMetadata columnMetadata) {
            this._fieldSpec = columnMetadata.getFieldSpec();
            this._numDocs = columnMetadata.getTotalDocs();
            this._numValues = columnMetadata.getTotalNumberOfEntries();
            this._maxNumValuesPerMVEntry = this._fieldSpec.isSingleValueField() ? -1 : columnMetadata.getMaxNumberOfMultiValues();
            this._minValue = columnMetadata.getMinValue();
            this._maxValue = columnMetadata.getMaxValue();
            this._partitionFunction = columnMetadata.getPartitionFunction();
            this._partitions = columnMetadata.getPartitions();
            this._cardinality = columnMetadata.getCardinality();
        }

        public FieldSpec getFieldSpec() {
            return this._fieldSpec;
        }

        public boolean isSorted() {
            return false;
        }

        public int getNumDocs() {
            return this._numDocs;
        }

        public int getNumValues() {
            return this._numValues;
        }

        public int getMaxNumValuesPerMVEntry() {
            return this._maxNumValuesPerMVEntry;
        }

        @Nullable
        public Comparable getMinValue() {
            return this._minValue;
        }

        public Comparable getMaxValue() {
            return this._maxValue;
        }

        @Nullable
        public PartitionFunction getPartitionFunction() {
            return this._partitionFunction;
        }

        @Nullable
        public Set<Integer> getPartitions() {
            return this._partitions;
        }

        public int getCardinality() {
            return this._cardinality;
        }

        public int getMaxRowLengthInBytes() {
            throw new UnsupportedOperationException();
        }
    }
}

