/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.VectorIndexConfig;
import org.apache.pinot.segment.spi.index.creator.VectorIndexCreator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorIndexHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorIndexHandler.class);
    private final Map<String, VectorIndexConfig> _vectorConfigs;

    public VectorIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> fieldIndexConfigs, @Nullable TableConfig tableConfig) {
        super(segmentDirectory, fieldIndexConfigs, tableConfig);
        this._vectorConfigs = FieldIndexConfigsUtil.enableConfigByColumn((IndexType)StandardIndexes.vector(), (Map)this._fieldIndexConfigs);
    }

    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._vectorConfigs.keySet());
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.vector());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing Vector index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateVectorIndex(columnMetadata)) continue;
            LOGGER.info("Need to create new Vector index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    public void updateIndices(SegmentDirectory.Writer segmentWriter) throws Exception {
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._vectorConfigs.keySet());
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.vector());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing Vector index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, StandardIndexes.vector());
            LOGGER.info("Removed existing Vector index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateVectorIndex(columnMetadata)) continue;
            this.createVectorIndexForColumn(segmentWriter, columnMetadata);
        }
    }

    private boolean shouldCreateVectorIndex(ColumnMetadata columnMetadata) {
        return columnMetadata != null;
    }

    private void createVectorIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        File segmentDirectory = SegmentDirectoryPaths.segmentDirectoryFor((File)indexDir, (SegmentVersion)this._segmentDirectory.getSegmentMetadata().getVersion());
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(segmentDirectory, columnName + ".vector.v912.hnsw.index.inprogress");
        File vectorIndexFile = new File(segmentDirectory, columnName + ".vector.v912.hnsw.index");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)vectorIndexFile);
        }
        columnMetadata = this.createForwardIndexIfNeeded(segmentWriter, columnName, true);
        LOGGER.info("Creating new Vector index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
        Preconditions.checkState((columnMetadata.getDataType() == FieldSpec.DataType.FLOAT ? 1 : 0) != 0, (Object)"VECTOR index can only be applied to Float Array columns");
        if (columnMetadata.hasDictionary()) {
            this.handleDictionaryBasedColumn(segmentWriter, columnMetadata);
        } else {
            this.handleNonDictionaryBasedColumn(segmentWriter, columnMetadata);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created Vector index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }

    private void handleDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String columnName = columnMetadata.getColumnName();
        File segmentDirectory = SegmentDirectoryPaths.segmentDirectoryFor((File)indexDir, (SegmentVersion)this._segmentDirectory.getSegmentMetadata().getVersion());
        FieldIndexConfigs colIndexConf = (FieldIndexConfigs)this._fieldIndexConfigs.get(columnName);
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(segmentDirectory).withColumnMetadata(columnMetadata).build();
        VectorIndexConfig config = (VectorIndexConfig)colIndexConf.getConfig(StandardIndexes.vector());
        try (ForwardIndexReader forwardIndexReader = (ForwardIndexReader)StandardIndexes.forward().getReaderFactory().createIndexReader((SegmentDirectory.Reader)segmentWriter, colIndexConf, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             Dictionary dictionary = (Dictionary)StandardIndexes.dictionary().getReaderFactory().createIndexReader((SegmentDirectory.Reader)segmentWriter, colIndexConf, columnMetadata);
             VectorIndexCreator vectorIndexCreator = (VectorIndexCreator)StandardIndexes.vector().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);){
            int numDocs = columnMetadata.getTotalDocs();
            float[] vector = new float[columnMetadata.getMaxNumberOfMultiValues()];
            int[] dictIds = new int[columnMetadata.getMaxNumberOfMultiValues()];
            for (int i = 0; i < numDocs; ++i) {
                forwardIndexReader.getDictIdMV(i, dictIds, readerContext);
                for (int j = 0; j < dictIds.length; ++j) {
                    vector[j] = dictionary.getFloatValue(dictIds[j]);
                }
                vectorIndexCreator.add(vector);
            }
            vectorIndexCreator.seal();
        }
    }

    private void handleNonDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String columnName = columnMetadata.getColumnName();
        File segmentDirectory = SegmentDirectoryPaths.segmentDirectoryFor((File)indexDir, (SegmentVersion)this._segmentDirectory.getSegmentMetadata().getVersion());
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(segmentDirectory).withColumnMetadata(columnMetadata).build();
        VectorIndexConfig config = (VectorIndexConfig)((FieldIndexConfigs)this._fieldIndexConfigs.get(columnName)).getConfig(StandardIndexes.vector());
        try (ForwardIndexReader<?> forwardIndexReader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             VectorIndexCreator vectorIndexCreator = (VectorIndexCreator)StandardIndexes.vector().createIndexCreator((IndexCreationContext)context, (IndexConfig)config);){
            int numDocs = columnMetadata.getTotalDocs();
            float[] vector = new float[columnMetadata.getMaxNumberOfMultiValues()];
            for (int i = 0; i < numDocs; ++i) {
                forwardIndexReader.getFloatMV(i, vector, readerContext);
            }
            vectorIndexCreator.seal();
        }
    }
}

