/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.h3;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.realtime.impl.geospatial.MutableH3Index;
import org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial.OffHeapH3IndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial.OnHeapH3IndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.H3IndexHandler;
import org.apache.pinot.segment.local.segment.index.readers.geospatial.ImmutableH3IndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.GeoSpatialIndexCreator;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.index.mutable.MutableIndex;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.segment.spi.index.reader.H3IndexResolution;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class H3IndexType
extends AbstractIndexType<H3IndexConfig, H3IndexReader, GeoSpatialIndexCreator> {
    public static final String INDEX_DISPLAY_NAME = "h3";
    private static final List<String> EXTENSIONS = Collections.singletonList(".h3.idx");

    protected H3IndexType() {
        super("h3_index");
    }

    public Class<H3IndexConfig> getIndexConfigClass() {
        return H3IndexConfig.class;
    }

    public H3IndexConfig getDefaultConfig() {
        return H3IndexConfig.DISABLED;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<H3IndexConfig> createDeserializer() {
        return IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass()).withExclusiveAlternative(IndexConfigDeserializer.fromIndexTypes((FieldConfig.IndexType)FieldConfig.IndexType.H3, (tableConfig, fieldConfig) -> new H3IndexConfig(fieldConfig.getProperties())));
    }

    public GeoSpatialIndexCreator createIndexCreator(IndexCreationContext context, H3IndexConfig indexConfig) throws IOException {
        Preconditions.checkState((boolean)context.getFieldSpec().isSingleValueField(), (Object)"H3 index is currently only supported on single-value columns");
        Preconditions.checkState((context.getFieldSpec().getDataType().getStoredType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"H3 index is currently only supported on BYTES columns");
        H3IndexResolution resolution = Objects.requireNonNull(indexConfig).getResolution();
        return context.isOnHeap() ? new OnHeapH3IndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), resolution) : new OffHeapH3IndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), resolution);
    }

    protected IndexReaderFactory<H3IndexReader> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return new H3IndexHandler(segmentDirectory, configsByCol, tableConfig);
    }

    public List<String> getFileExtensions(@Nullable ColumnMetadata columnMetadata) {
        return EXTENSIONS;
    }

    @Nullable
    public MutableIndex createMutableIndex(MutableIndexContext context, H3IndexConfig config) {
        if (config.isDisabled()) {
            return null;
        }
        if (!context.getFieldSpec().isSingleValueField()) {
            return null;
        }
        try {
            return new MutableH3Index(config.getResolution());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class ReaderFactory
    extends IndexReaderFactory.Default<H3IndexConfig, H3IndexReader> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        protected IndexType<H3IndexConfig, H3IndexReader, ?> getIndexType() {
            return StandardIndexes.h3();
        }

        protected H3IndexReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata, H3IndexConfig indexConfig) {
            return new ImmutableH3IndexReader(dataBuffer);
        }
    }
}

