/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.text;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.LuceneNRTCachingMergePolicy;
import org.apache.pinot.segment.local.segment.index.text.AbstractTextIndexCreator;
import org.apache.pinot.segment.local.segment.store.TextIndexUtils;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.TextIndexConfig;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneTextIndexCreator
extends AbstractTextIndexCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneTextIndexCreator.class);
    public static final String LUCENE_INDEX_DOC_ID_COLUMN_NAME = "DocID";
    private final String _textColumn;
    private final boolean _commitOnClose;
    private final boolean _reuseMutableIndex;
    private final File _indexFile;
    private Directory _indexDirectory;
    private IndexWriter _indexWriter;
    private int _nextDocId = 0;
    public static final CharArraySet ENGLISH_STOP_WORDS_SET = new CharArraySet(LuceneTextIndexCreator.getDefaultEnglishStopWordsSet(), true);

    public static HashSet<String> getDefaultEnglishStopWordsSet() {
        return new HashSet<String>(Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "than", "there", "these", "they", "this", "to", "was", "will", "with", "those"));
    }

    public LuceneTextIndexCreator(String column, File segmentIndexDir, boolean commit, boolean realtimeConversion, @Nullable File consumerDir, @Nullable int[] immutableToMutableIdMap, TextIndexConfig config) {
        this._textColumn = column;
        this._commitOnClose = commit;
        String luceneAnalyzerClass = config.getLuceneAnalyzerClass();
        try {
            this._indexFile = this.getV1TextIndexFile(segmentIndexDir);
            if (this._commitOnClose) {
                TextIndexUtils.writeConfigToPropertiesFile(this._indexFile, config);
            }
            Analyzer luceneAnalyzer = TextIndexUtils.getAnalyzer(config);
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(luceneAnalyzer);
            indexWriterConfig.setRAMBufferSizeMB((double)config.getLuceneMaxBufferSizeMB());
            indexWriterConfig.setCommitOnClose(commit);
            indexWriterConfig.setUseCompoundFile(config.isLuceneUseCompoundFile());
            if (!this._commitOnClose && config.isReuseMutableIndex()) {
                indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            }
            boolean bl = this._reuseMutableIndex = config.isReuseMutableIndex() && commit && realtimeConversion;
            if (this._reuseMutableIndex) {
                LOGGER.info("Reusing the realtime lucene index for segment {} and column {}", (Object)segmentIndexDir, (Object)column);
                indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                this.convertMutableSegment(segmentIndexDir, consumerDir, immutableToMutableIdMap, indexWriterConfig);
                return;
            }
            if (!this._commitOnClose && config.getLuceneNRTCachingDirectoryMaxBufferSizeMB() > 0) {
                int bufSize = config.getLuceneNRTCachingDirectoryMaxBufferSizeMB();
                LOGGER.info("Using NRTCachingDirectory for realtime lucene index for segment {} and column {} with buffer size: {}MB", new Object[]{segmentIndexDir, column, bufSize});
                NRTCachingDirectory dir = new NRTCachingDirectory((Directory)FSDirectory.open((Path)this._indexFile.toPath()), (double)bufSize, (double)bufSize);
                indexWriterConfig.setMergePolicy((MergePolicy)new LuceneNRTCachingMergePolicy(dir));
                this._indexDirectory = dir;
            } else {
                this._indexDirectory = FSDirectory.open((Path)this._indexFile.toPath());
            }
            this._indexWriter = new IndexWriter(this._indexDirectory, indexWriterConfig);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate " + luceneAnalyzerClass + " lucene analyzer for column: " + column, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while instantiating the LuceneTextIndexCreator for column: " + column, e);
        }
    }

    public LuceneTextIndexCreator(IndexCreationContext context, TextIndexConfig indexConfig) {
        this(context.getFieldSpec().getName(), context.getIndexDir(), context.isTextCommitOnClose(), context.isRealtimeConversion(), context.getConsumerDir(), context.getImmutableToMutableIdMap(), indexConfig);
    }

    public IndexWriter getIndexWriter() {
        return this._indexWriter;
    }

    private void convertMutableSegment(File segmentIndexDir, File consumerDir, @Nullable int[] immutableToMutableIdMap, IndexWriterConfig indexWriterConfig) {
        try {
            File dest = this.getV1TextIndexFile(segmentIndexDir);
            File mutableDir = this.getMutableIndexDir(segmentIndexDir, consumerDir);
            FileUtils.copyDirectory((File)mutableDir, (File)dest);
            File writeLock = new File(dest, "write.lock");
            FileUtils.delete((File)writeLock);
            try (FSDirectory destDirectory = FSDirectory.open((Path)dest.toPath());
                 IndexWriter indexWriter = new IndexWriter((Directory)destDirectory, indexWriterConfig);){
                indexWriter.forceMerge(1, true);
                indexWriter.commit();
                this.buildMappingFile(segmentIndexDir, this._textColumn, (Directory)destDirectory, immutableToMutableIdMap);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to build the mapping file during segment conversion: " + e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert the mutable lucene index: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMappingFile(File segmentIndexDir, String column, Directory directory, @Nullable int[] immutableToMutableIdMap) throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
        IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
        int numDocs = indexSearcher.getIndexReader().numDocs();
        int length = 4 * numDocs;
        File docIdMappingFile = new File(SegmentDirectoryPaths.findSegmentDirectory((File)segmentIndexDir), column + ".lucene.mapping");
        String desc = "Text index docId mapping buffer: " + column;
        try (PinotDataBuffer buffer = PinotDataBuffer.mapFile((File)docIdMappingFile, (boolean)false, (long)0L, (long)length, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (String)desc);){
            if (immutableToMutableIdMap == null) {
                for (int i = 0; i < numDocs; ++i) {
                    Document document = indexSearcher.doc(i);
                    int pinotDocId = Integer.parseInt(document.get(LUCENE_INDEX_DOC_ID_COLUMN_NAME));
                    buffer.putInt(i * 4, pinotDocId);
                }
                return;
            }
            try {
                for (int i = 0; i < numDocs; ++i) {
                    Document document = indexSearcher.doc(i);
                    int mutablePinotDocId = Integer.parseInt(document.get(LUCENE_INDEX_DOC_ID_COLUMN_NAME));
                    int immutablePinotDocId = immutableToMutableIdMap[mutablePinotDocId];
                    buffer.putInt(i * 4, immutablePinotDocId);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while building mutable to immutable doc id mapping for text index column: " + column, e);
            }
        }
        finally {
            indexReader.close();
        }
    }

    public void add(String document) {
        if (this._reuseMutableIndex) {
            return;
        }
        Document docToIndex = new Document();
        docToIndex.add((IndexableField)new TextField(this._textColumn, document, Field.Store.NO));
        docToIndex.add((IndexableField)new StoredField(LUCENE_INDEX_DOC_ID_COLUMN_NAME, this._nextDocId++));
        try {
            this._indexWriter.addDocument((Iterable)docToIndex);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while adding a new document to the Lucene index for column: " + this._textColumn, e);
        }
    }

    public void add(String[] documents, int length) {
        if (this._reuseMutableIndex) {
            return;
        }
        Document docToIndex = new Document();
        for (int i = 0; i < length; ++i) {
            docToIndex.add((IndexableField)new TextField(this._textColumn, documents[i], Field.Store.NO));
        }
        docToIndex.add((IndexableField)new StoredField(LUCENE_INDEX_DOC_ID_COLUMN_NAME, this._nextDocId++));
        try {
            this._indexWriter.addDocument((Iterable)docToIndex);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while adding a new document to the Lucene index for column: " + this._textColumn, e);
        }
    }

    public void seal() {
        if (this._reuseMutableIndex) {
            return;
        }
        try {
            this._indexWriter.forceMerge(1);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while sealing the Lucene index for column: " + this._textColumn, e);
        }
    }

    public void close() throws IOException {
        if (this._reuseMutableIndex) {
            return;
        }
        try {
            this._indexWriter.close();
            this._indexDirectory.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while closing the Lucene index for column: " + this._textColumn, e);
        }
        finally {
            if (!this._commitOnClose) {
                FileUtils.deleteQuietly((File)this._indexFile);
            }
        }
    }

    private File getV1TextIndexFile(File indexDir) {
        String luceneIndexDirectory = this._textColumn + ".lucene.v912.index";
        return new File(indexDir, luceneIndexDirectory);
    }

    private File getMutableIndexDir(File indexDir, File consumerDir) {
        String segmentName = this.getSegmentName(indexDir);
        return new File(new File(consumerDir, segmentName), this._textColumn + ".lucene.v912.index");
    }

    private String getSegmentName(File indexDir) {
        String tmpSegmentName = indexDir.getParentFile().getName();
        return tmpSegmentName.substring(tmpSegmentName.indexOf("tmp-") + 4, tmpSegmentName.lastIndexOf(45));
    }

    public int getNumDocs() {
        return this._nextDocId;
    }
}

