/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;

public class DoubleColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private DoubleSet _values = new DoubleOpenHashSet(1000);
    private double[] _sortedValues;
    private boolean _sealed = false;
    private double _prevValue = Double.NEGATIVE_INFINITY;

    public DoubleColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    @Override
    public void collect(Object entry) {
        assert (!this._sealed);
        if (entry instanceof Object[]) {
            Object[] values;
            for (Object obj : values = (Object[])entry) {
                double value = (Double)obj;
                this._values.add(value);
            }
            this._maxNumberOfMultiValues = Math.max(this._maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values);
        } else if (entry instanceof double[]) {
            double[] values;
            for (double value : values = (double[])entry) {
                this._values.add(value);
            }
            this._maxNumberOfMultiValues = Math.max(this._maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values.length);
        } else {
            double value = (Double)entry;
            this.addressSorted(value);
            if (this._values.add(value) && this.isPartitionEnabled()) {
                this.updatePartition(Double.toString(value));
            }
            ++this._totalNumberOfEntries;
        }
    }

    private void addressSorted(double entry) {
        if (this._sorted) {
            this._sorted = entry >= this._prevValue;
            this._prevValue = entry;
        }
    }

    public Double getMinValue() {
        if (this._sealed) {
            return this._sortedValues[0];
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    public Double getMaxValue() {
        if (this._sealed) {
            return this._sortedValues[this._sortedValues.length - 1];
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public Object getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    public int getCardinality() {
        return this._sealed ? this._sortedValues.length : this._values.size();
    }

    @Override
    public void seal() {
        if (!this._sealed) {
            this._sortedValues = this._values.toDoubleArray();
            this._values = null;
            Arrays.sort(this._sortedValues);
            this._sealed = true;
        }
    }
}

