/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.segment.spi.index.creator.CombinedInvertedIndexCreator;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RangeIndexCreator
implements CombinedInvertedIndexCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RangeIndexCreator.class);
    private static final boolean TRACE = false;
    public static final int VERSION = 1;
    private static final int DEFAULT_NUM_RANGES = 20;
    private static final String VALUE_BUFFER_SUFFIX = "val.buf";
    private static final String DOC_ID_VALUE_BUFFER_SUFFIX = ".doc.id.buf";
    private final File _rangeIndexFile;
    private final File _tempValueBufferFile;
    private PinotDataBuffer _tempValueBuffer;
    private NumberValueBuffer _numberValueBuffer;
    private final File _tempDocIdBufferFile;
    private PinotDataBuffer _docIdValueBuffer;
    private IntValueBuffer _docIdBuffer;
    private final int _numValues;
    private int _nextDocId;
    private int _nextValueId;
    private final int _numValuesPerRange;
    private final FieldSpec.DataType _valueType;

    public RangeIndexCreator(File indexDir, FieldSpec fieldSpec, FieldSpec.DataType valueType, int numRanges, int numValuesPerRange, int numDocs, int numValues) throws IOException {
        this._valueType = valueType;
        String columnName = fieldSpec.getName();
        this._rangeIndexFile = new File(indexDir, columnName + ".bitmap.range");
        this._tempValueBufferFile = new File(indexDir, columnName + VALUE_BUFFER_SUFFIX);
        this._tempDocIdBufferFile = new File(indexDir, columnName + DOC_ID_VALUE_BUFFER_SUFFIX);
        this._numValues = fieldSpec.isSingleValueField() ? numDocs : numValues;
        int valueSize = valueType.size();
        try {
            Preconditions.checkArgument((numRanges <= 0 || numValuesPerRange <= 0 ? 1 : 0) != 0, (Object)"At most one of 'numRanges' and 'numValuesPerRange' should be configured");
            this._numValuesPerRange = numRanges > 0 ? (this._numValues + numRanges - 1) / numRanges : (numValuesPerRange > 0 ? numValuesPerRange : (this._numValues + 20 - 1) / 20);
            this._tempValueBuffer = this.createTempBuffer((long)this._numValues * (long)valueSize, this._tempValueBufferFile);
            switch (this._valueType) {
                case INT: {
                    this._numberValueBuffer = new IntValueBuffer(this._tempValueBuffer);
                    break;
                }
                case FLOAT: {
                    this._numberValueBuffer = new FloatValueBuffer(this._tempValueBuffer);
                    break;
                }
                case LONG: {
                    this._numberValueBuffer = new LongValueBuffer(this._tempValueBuffer);
                    break;
                }
                case DOUBLE: {
                    this._numberValueBuffer = new DoubleValueBuffer(this._tempValueBuffer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Range index is not supported for columns of data type:" + valueType);
                }
            }
            this._docIdValueBuffer = this.createTempBuffer((long)this._numValues * 4L, this._tempDocIdBufferFile);
            this._docIdBuffer = new IntValueBuffer(this._docIdValueBuffer);
        }
        catch (Exception e) {
            this.destroyBuffer(this._tempValueBuffer, this._tempValueBufferFile);
            this.destroyBuffer(this._tempValueBuffer, this._tempDocIdBufferFile);
            throw e;
        }
    }

    public FieldSpec.DataType getDataType() {
        return this._valueType;
    }

    public void add(int value) {
        this._numberValueBuffer.put(this._nextDocId, value);
        this._docIdBuffer.put(this._nextDocId, this._nextDocId);
        ++this._nextDocId;
    }

    public void add(int[] values, int length) {
        for (int i = 0; i < length; ++i) {
            this._numberValueBuffer.put(this._nextValueId, values[i]);
            this._docIdBuffer.put(this._nextValueId, this._nextDocId);
            ++this._nextValueId;
        }
        ++this._nextDocId;
    }

    public void add(long value) {
        this._numberValueBuffer.put(this._nextDocId, value);
        this._docIdBuffer.put(this._nextDocId, this._nextDocId);
        ++this._nextDocId;
    }

    public void add(long[] values, int length) {
        for (int i = 0; i < length; ++i) {
            this._numberValueBuffer.put(this._nextValueId, values[i]);
            this._docIdBuffer.put(this._nextValueId, this._nextDocId);
            ++this._nextValueId;
        }
        ++this._nextDocId;
    }

    public void add(float value) {
        this._numberValueBuffer.put(this._nextDocId, Float.valueOf(value));
        this._docIdBuffer.put(this._nextDocId, this._nextDocId);
        ++this._nextDocId;
    }

    public void add(float[] values, int length) {
        for (int i = 0; i < length; ++i) {
            this._numberValueBuffer.put(this._nextValueId, Float.valueOf(values[i]));
            this._docIdBuffer.put(this._nextValueId, this._nextDocId);
            ++this._nextValueId;
        }
        ++this._nextDocId;
    }

    public void add(double value) {
        this._numberValueBuffer.put(this._nextDocId, value);
        this._docIdBuffer.put(this._nextDocId, this._nextDocId);
        ++this._nextDocId;
    }

    public void add(double[] values, int length) {
        for (int i = 0; i < length; ++i) {
            this._numberValueBuffer.put(this._nextValueId, values[i]);
            this._docIdBuffer.put(this._nextValueId, this._nextDocId);
            ++this._nextValueId;
        }
        ++this._nextDocId;
    }

    public void seal() throws IOException {
        IntComparator comparator = (i, j) -> {
            Number val1 = this._numberValueBuffer.get(i);
            Number val2 = this._numberValueBuffer.get(j);
            return this._numberValueBuffer.compare(val1, val2);
        };
        Swapper swapper = (i, j) -> {
            Integer temp = this._docIdBuffer.get(i).intValue();
            this._docIdBuffer.put(i, this._docIdBuffer.get(j).intValue());
            this._docIdBuffer.put(j, temp);
            Number tempValue = this._numberValueBuffer.get(i);
            this._numberValueBuffer.put(i, this._numberValueBuffer.get(j));
            this._numberValueBuffer.put(j, tempValue);
        };
        Arrays.quickSort((int)0, (int)this._numValues, (IntComparator)comparator, (Swapper)swapper);
        ArrayList<Pair> ranges = new ArrayList<Pair>();
        int boundary = this._numValuesPerRange;
        int start = 0;
        for (int i2 = 0; i2 < this._numValues; ++i2) {
            if (i2 <= start + boundary || comparator.compare(i2, i2 - 1) == 0) continue;
            ranges.add(Pair.of((Object)start, (Object)(i2 - 1)));
            start = i2;
        }
        ranges.add(Pair.of((Object)start, (Object)(this._numValues - 1)));
        long bytesWritten = 0L;
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this._rangeIndexFile));
             DataOutputStream header = new DataOutputStream(bos);
             FileOutputStream fos = new FileOutputStream(this._rangeIndexFile);
             FileChannel channel = fos.getChannel();
             DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fos));){
            header.writeInt(1);
            bytesWritten += 4L;
            byte[] valueDataTypeBytes = this._valueType.name().getBytes(Charsets.UTF_8);
            header.writeInt(valueDataTypeBytes.length);
            bytesWritten += 4L;
            header.write(valueDataTypeBytes);
            bytesWritten += (long)valueDataTypeBytes.length;
            header.writeInt(ranges.size());
            bytesWritten += 4L;
            for (Pair range : ranges) {
                Number rangeStart = this._numberValueBuffer.get((Integer)range.getLeft());
                this.writeNumberToHeader(header, rangeStart);
            }
            bytesWritten += (long)ranges.size() * (long)this._valueType.size();
            Number lastRangeEnd = this._numberValueBuffer.get((Integer)((Pair)ranges.get(ranges.size() - 1)).getRight());
            this.writeNumberToHeader(header, lastRangeEnd);
            long bitmapOffsetHeaderSize = (long)(ranges.size() + 1) * 8L;
            long bitmapOffset = (bytesWritten += (long)this._valueType.size()) + bitmapOffsetHeaderSize;
            header.writeLong(bitmapOffset);
            bytesWritten += 8L;
            channel.position(bitmapOffset);
            for (int i3 = 0; i3 < ranges.size(); ++i3) {
                Pair range = (Pair)ranges.get(i3);
                MutableRoaringBitmap bitmap = new MutableRoaringBitmap();
                for (int index = ((Integer)range.getLeft()).intValue(); index <= (Integer)range.getRight(); ++index) {
                    bitmap.add(this._docIdBuffer.get(index).intValue());
                }
                int sizeInBytes = bitmap.serializedSizeInBytes();
                Preconditions.checkState(((bitmapOffset += (long)sizeInBytes) > 0L ? 1 : 0) != 0, (String)"Inverted index file: %s exceeds 2GB limit", (Object)this._rangeIndexFile);
                header.writeLong(bitmapOffset);
                bytesWritten += 8L;
                byte[] bytes = new byte[sizeInBytes];
                bitmap.serialize(ByteBuffer.wrap(bytes));
                dataOutputStream.write(bytes);
                bytesWritten += (long)bytes.length;
            }
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)this._rangeIndexFile);
            throw e;
        }
        Preconditions.checkState((bytesWritten == this._rangeIndexFile.length() ? 1 : 0) != 0, (Object)("Length of inverted index file: " + this._rangeIndexFile.length() + " does not match the number of bytes written: " + bytesWritten));
    }

    private void writeNumberToHeader(DataOutputStream header, Number number) throws IOException {
        switch (this._valueType) {
            case INT: {
                header.writeInt(number.intValue());
                break;
            }
            case LONG: {
                header.writeLong(number.longValue());
                break;
            }
            case FLOAT: {
                header.writeFloat(number.floatValue());
                break;
            }
            case DOUBLE: {
                header.writeDouble(number.doubleValue());
                break;
            }
            default: {
                throw new RuntimeException("Range index not supported for dataType: " + this._valueType);
            }
        }
    }

    private void dumpRanges(List<Pair<Integer, Integer>> ranges) {
        StringBuilder rangeOffsets = new StringBuilder("[ ");
        StringBuilder rangeValues = new StringBuilder("[ ");
        for (Pair<Integer, Integer> range : ranges) {
            rangeOffsets.append("(").append(range.getLeft()).append(",").append(range.getRight()).append(") ,");
            rangeValues.append("(").append(this._numberValueBuffer.get((Integer)range.getLeft())).append(",").append(this._numberValueBuffer.get((Integer)range.getRight())).append(") ,");
        }
        rangeOffsets.append(" ]");
        rangeValues.append(" ]");
        LOGGER.info("rangeOffsets = {}", (Object)rangeOffsets);
        LOGGER.info("rangeValues = {}", (Object)rangeValues);
    }

    public void close() throws IOException {
        org.apache.pinot.common.utils.FileUtils.close((Closeable[])new Closeable[]{new DataBufferAndFile(this._tempValueBuffer, this._tempValueBufferFile), new DataBufferAndFile(this._docIdValueBuffer, this._tempDocIdBufferFile)});
    }

    public int getNumValuesPerRange() {
        return this._numValuesPerRange;
    }

    void dump() {
        StringBuilder docIdAsString = new StringBuilder("DocIdBuffer  [ ");
        for (int i = 0; i < this._numValues; ++i) {
            docIdAsString.append(this._docIdBuffer.get(i) + ", ");
        }
        docIdAsString.append("]");
        LOGGER.info(docIdAsString.toString());
        StringBuilder valuesAsString = new StringBuilder("ValueBuffer  [ ");
        for (int i = 0; i < this._numValues; ++i) {
            valuesAsString.append(this._numberValueBuffer.get(i) + ", ");
        }
        valuesAsString.append("] ");
        LOGGER.info(valuesAsString.toString());
    }

    private PinotDataBuffer createTempBuffer(long size, File mmapFile) throws IOException {
        return PinotDataBuffer.mapFile((File)mmapFile, (boolean)false, (long)0L, (long)size, (ByteOrder)PinotDataBuffer.NATIVE_ORDER, (String)"RangeIndexCreator: temp buffer");
    }

    private void destroyBuffer(PinotDataBuffer buffer, File mmapFile) throws IOException {
        if (buffer != null) {
            buffer.close();
            if (mmapFile.exists()) {
                FileUtils.forceDelete((File)mmapFile);
            }
        }
    }

    private static class DoubleValueBuffer
    implements NumberValueBuffer {
        private final PinotDataBuffer _dataBuffer;

        DoubleValueBuffer(PinotDataBuffer dataBuffer) {
            this._dataBuffer = dataBuffer;
        }

        @Override
        public void put(int position, Number value) {
            this._dataBuffer.putDouble(position << 3, value.doubleValue());
        }

        @Override
        public Number get(int position) {
            return this._dataBuffer.getDouble(position << 3);
        }

        @Override
        public int compare(Number val1, Number val2) {
            return Double.compare(val1.doubleValue(), val2.doubleValue());
        }
    }

    private static class FloatValueBuffer
    implements NumberValueBuffer {
        private final PinotDataBuffer _dataBuffer;

        FloatValueBuffer(PinotDataBuffer dataBuffer) {
            this._dataBuffer = dataBuffer;
        }

        @Override
        public void put(int position, Number value) {
            this._dataBuffer.putFloat(position << 2, value.floatValue());
        }

        @Override
        public Number get(int position) {
            return Float.valueOf(this._dataBuffer.getFloat(position << 2));
        }

        @Override
        public int compare(Number val1, Number val2) {
            return Float.compare(val1.floatValue(), val2.floatValue());
        }
    }

    private static class LongValueBuffer
    implements NumberValueBuffer {
        private final PinotDataBuffer _dataBuffer;

        LongValueBuffer(PinotDataBuffer dataBuffer) {
            this._dataBuffer = dataBuffer;
        }

        @Override
        public void put(int position, Number value) {
            this._dataBuffer.putLong(position << 3, value.longValue());
        }

        @Override
        public Number get(int position) {
            return this._dataBuffer.getLong(position << 3);
        }

        @Override
        public int compare(Number val1, Number val2) {
            return Long.compare(val1.longValue(), val2.longValue());
        }
    }

    private static class IntValueBuffer
    implements NumberValueBuffer {
        private final PinotDataBuffer _dataBuffer;

        IntValueBuffer(PinotDataBuffer dataBuffer) {
            this._dataBuffer = dataBuffer;
        }

        @Override
        public void put(int position, Number value) {
            this._dataBuffer.putInt(position << 2, value.intValue());
        }

        @Override
        public Number get(int position) {
            return this._dataBuffer.getInt(position << 2);
        }

        @Override
        public int compare(Number val1, Number val2) {
            return Integer.compare(val1.intValue(), val2.intValue());
        }
    }

    private static interface NumberValueBuffer {
        public void put(int var1, Number var2);

        public Number get(int var1);

        public int compare(Number var1, Number var2);
    }

    private class DataBufferAndFile
    implements Closeable {
        private final PinotDataBuffer _dataBuffer;
        private final File _file;

        DataBufferAndFile(PinotDataBuffer buffer, File file) {
            this._dataBuffer = buffer;
            this._file = file;
        }

        @Override
        public void close() throws IOException {
            RangeIndexCreator.this.destroyBuffer(this._dataBuffer, this._file);
        }
    }
}

