/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkForwardIndexWriter;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkForwardIndexWriterV4;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkForwardIndexWriterV5;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkWriter;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.ForwardIndexUtils;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class MultiValueFixedByteRawIndexCreator
implements ForwardIndexCreator {
    private final VarByteChunkWriter _indexWriter;
    private final FieldSpec.DataType _valueType;

    public MultiValueFixedByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxNumberOfMultiValueElements, boolean deriveNumDocsPerChunk, int writerVersion, int targetMaxChunkSizeBytes, int targetDocsPerChunk) throws IOException {
        this(new File(baseIndexDir, column + ".mv.raw.fwd"), compressionType, totalDocs, valueType, maxNumberOfMultiValueElements, deriveNumDocsPerChunk, writerVersion, targetMaxChunkSizeBytes, targetDocsPerChunk);
    }

    public MultiValueFixedByteRawIndexCreator(File indexFile, ChunkCompressionType compressionType, int totalDocs, FieldSpec.DataType valueType, int maxNumberOfMultiValueElements, boolean deriveNumDocsPerChunk, int writerVersion) throws IOException {
        this(indexFile, compressionType, totalDocs, valueType, maxNumberOfMultiValueElements, deriveNumDocsPerChunk, writerVersion, ForwardIndexConfig.getDefaultTargetMaxChunkSizeBytes(), ForwardIndexConfig.getDefaultTargetDocsPerChunk());
    }

    public MultiValueFixedByteRawIndexCreator(File indexFile, ChunkCompressionType compressionType, int totalDocs, FieldSpec.DataType valueType, int maxNumberOfMultiValueElements, boolean deriveNumDocsPerChunk, int writerVersion, int targetMaxChunkSizeBytes, int targetDocsPerChunk) throws IOException {
        if (writerVersion < 4) {
            int totalMaxLength = 4 + maxNumberOfMultiValueElements * valueType.getStoredType().size();
            int numDocsPerChunk = deriveNumDocsPerChunk ? Math.max(targetMaxChunkSizeBytes / (totalMaxLength + 4), 1) : targetDocsPerChunk;
            this._indexWriter = new VarByteChunkForwardIndexWriter(indexFile, compressionType, totalDocs, numDocsPerChunk, totalMaxLength, writerVersion);
        } else if (writerVersion == 5) {
            int totalMaxLength = maxNumberOfMultiValueElements * valueType.getStoredType().size();
            int chunkSize = ForwardIndexUtils.getDynamicTargetChunkSize(totalMaxLength, targetDocsPerChunk, targetMaxChunkSizeBytes);
            this._indexWriter = new VarByteChunkForwardIndexWriterV5(indexFile, compressionType, chunkSize);
        } else {
            int totalMaxLength = 4 + maxNumberOfMultiValueElements * valueType.getStoredType().size();
            int chunkSize = ForwardIndexUtils.getDynamicTargetChunkSize(totalMaxLength, targetDocsPerChunk, targetMaxChunkSizeBytes);
            this._indexWriter = new VarByteChunkForwardIndexWriterV4(indexFile, compressionType, chunkSize);
        }
        this._valueType = valueType;
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return false;
    }

    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    public void putIntMV(int[] values) {
        this._indexWriter.putIntMV(values);
    }

    public void putLongMV(long[] values) {
        this._indexWriter.putLongMV(values);
    }

    public void putFloatMV(float[] values) {
        this._indexWriter.putFloatMV(values);
    }

    public void putDoubleMV(double[] values) {
        this._indexWriter.putDoubleMV(values);
    }

    public void close() throws IOException {
        this._indexWriter.close();
    }
}

