/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import com.yscope.clp.compressorfrontend.EncodedMessage;
import com.yscope.clp.compressorfrontend.MessageEncoder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.segment.local.io.util.VarLengthValueWriter;
import org.apache.pinot.segment.local.io.writer.impl.FixedByteChunkForwardIndexWriter;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkForwardIndexWriterV5;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BytesOffHeapMutableDictionary;
import org.apache.pinot.segment.local.realtime.impl.forward.CLPMutableForwardIndexV2;
import org.apache.pinot.segment.local.segment.creator.impl.stats.CLPStatsProvider;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLPForwardIndexCreatorV2
implements ForwardIndexCreator {
    public static final Logger LOGGER = LoggerFactory.getLogger(CLPForwardIndexCreatorV2.class);
    public static final byte[] MAGIC_BYTES = "CLP.v2".getBytes(StandardCharsets.UTF_8);
    public final String _column;
    private final int _numDoc;
    private final File _intermediateFilesDir;
    private final FileChannel _dataFile;
    private final ByteBuffer _fileBuffer;
    private final boolean _isClpEncoded;
    private int _logtypeDictSize;
    private File _logtypeDictFile;
    private VarLengthValueWriter _logtypeDict;
    private int _dictVarDictSize;
    private File _dictVarDictFile;
    private VarLengthValueWriter _dictVarDict;
    private File _logtypeIdFwdIndexFile;
    private FixedByteChunkForwardIndexWriter _logtypeIdFwdIndex;
    private File _dictVarIdFwdIndexFile;
    private VarByteChunkForwardIndexWriterV5 _dictVarIdFwdIndex;
    private File _encodedVarFwdIndexFile;
    private VarByteChunkForwardIndexWriterV5 _encodedVarFwdIndex;
    private File _rawMsgFwdIndexFile;
    private VarByteChunkForwardIndexWriterV5 _rawMsgFwdIndex;
    private int _targetChunkSize = 0x100000;
    private final EncodedMessage _clpEncodedMessage;
    private final EncodedMessage _failToEncodeClpEncodedMessage;
    private final MessageEncoder _clpMessageEncoder;
    private final BytesOffHeapMutableDictionary _mutableLogtypeDict;
    private final BytesOffHeapMutableDictionary _mutableDictVarDict;
    private final ChunkCompressionType _chunkCompressionType;

    public CLPForwardIndexCreatorV2(File baseIndexDir, ColumnStatistics columnStatistics) throws IOException {
        this(baseIndexDir, ((CLPStatsProvider)columnStatistics).getCLPV2Stats().getClpMutableForwardIndexV2(), ChunkCompressionType.ZSTANDARD);
    }

    public CLPForwardIndexCreatorV2(File baseIndexDir, CLPMutableForwardIndexV2 clpMutableForwardIndex, ChunkCompressionType chunkCompressionType) throws IOException {
        this(baseIndexDir, clpMutableForwardIndex, chunkCompressionType, false);
    }

    public CLPForwardIndexCreatorV2(File baseIndexDir, CLPMutableForwardIndexV2 clpMutableForwardIndex, ChunkCompressionType chunkCompressionType, boolean forceRawEncoding) throws IOException {
        this._chunkCompressionType = chunkCompressionType;
        this._column = clpMutableForwardIndex.getColumnName();
        this._numDoc = clpMutableForwardIndex.getNumDoc();
        this._intermediateFilesDir = new File(baseIndexDir, this._column + ".sv.raw.fwd.clp.tmp");
        if (this._intermediateFilesDir.exists()) {
            FileUtils.cleanDirectory((File)this._intermediateFilesDir);
        } else {
            FileUtils.forceMkdir((File)this._intermediateFilesDir);
        }
        this._isClpEncoded = !forceRawEncoding && clpMutableForwardIndex.isClpEncoded();
        this._mutableLogtypeDict = clpMutableForwardIndex.getLogtypeDict();
        this._mutableDictVarDict = clpMutableForwardIndex.getDictVarDict();
        if (this._isClpEncoded) {
            this.initializeDictionaryEncodingMode(chunkCompressionType, clpMutableForwardIndex.getLogtypeDict().length(), clpMutableForwardIndex.getDictVarDict().length());
            this.putLogtypeDict(clpMutableForwardIndex.getLogtypeDict());
            this.putDictVarDict(clpMutableForwardIndex.getDictVarDict());
        } else {
            this.initializeRawEncodingMode(chunkCompressionType);
        }
        this._dataFile = new RandomAccessFile(new File(baseIndexDir, this._column + ".sv.raw.fwd"), "rw").getChannel();
        this._fileBuffer = this._dataFile.map(FileChannel.MapMode.READ_WRITE, 0L, Integer.MAX_VALUE);
        this._clpEncodedMessage = new EncodedMessage();
        this._clpMessageEncoder = new MessageEncoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        this._failToEncodeClpEncodedMessage = new EncodedMessage();
        try {
            this._clpMessageEncoder.encodeMessage("Failed to encode message", this._failToEncodeClpEncodedMessage);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to encode error message", ex);
        }
    }

    public boolean isClpEncoded() {
        return this._isClpEncoded;
    }

    private void initializeRawEncodingMode(ChunkCompressionType chunkCompressionType) throws IOException {
        this._rawMsgFwdIndexFile = new File(this._intermediateFilesDir, this._column + ".rawMsg");
        this._rawMsgFwdIndex = new VarByteChunkForwardIndexWriterV5(this._rawMsgFwdIndexFile, chunkCompressionType, this._targetChunkSize);
    }

    private void initializeDictionaryEncodingMode(ChunkCompressionType chunkCompressionType, int logtypeDictSize, int dictVarDictSize) throws IOException {
        this._logtypeDictFile = new File(this._intermediateFilesDir, this._column + ".lt.dict");
        this._logtypeDict = new VarLengthValueWriter(this._logtypeDictFile, logtypeDictSize);
        this._logtypeDictSize = logtypeDictSize;
        this._logtypeIdFwdIndexFile = new File(this._intermediateFilesDir, this._column + ".lt.id");
        this._logtypeIdFwdIndex = new FixedByteChunkForwardIndexWriter(this._logtypeIdFwdIndexFile, chunkCompressionType, this._numDoc, this._targetChunkSize / FieldSpec.DataType.INT.size(), FieldSpec.DataType.INT.size(), 5);
        this._dictVarDictFile = new File(this._intermediateFilesDir, this._column + ".var.dict");
        this._dictVarDict = new VarLengthValueWriter(this._dictVarDictFile, dictVarDictSize);
        this._dictVarDictSize = dictVarDictSize;
        this._dictVarIdFwdIndexFile = new File(this._dictVarIdFwdIndexFile, this._column + ".dictVars");
        this._dictVarIdFwdIndex = new VarByteChunkForwardIndexWriterV5(this._dictVarIdFwdIndexFile, chunkCompressionType, this._targetChunkSize);
        this._encodedVarFwdIndexFile = new File(this._intermediateFilesDir, this._column + ".encodedVars");
        this._encodedVarFwdIndex = new VarByteChunkForwardIndexWriterV5(this._encodedVarFwdIndexFile, chunkCompressionType, this._targetChunkSize);
    }

    public void putLogtypeDict(BytesOffHeapMutableDictionary logtypeDict) throws IOException {
        for (int i = 0; i < logtypeDict.length(); ++i) {
            this._logtypeDict.add(logtypeDict.get(i));
        }
    }

    public void putDictVarDict(BytesOffHeapMutableDictionary dictVarDict) throws IOException {
        for (int i = 0; i < dictVarDict.length(); ++i) {
            this._dictVarDict.add(dictVarDict.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putString(String value) {
        EncodedMessage encodedMessage = this._clpEncodedMessage;
        try {
            this._clpMessageEncoder.encodeMessage(value, encodedMessage);
        }
        catch (IOException e) {
            encodedMessage = this._failToEncodeClpEncodedMessage;
        }
        finally {
            this.appendEncodedMessage(encodedMessage);
        }
    }

    public void appendEncodedMessage(@NotNull EncodedMessage clpEncodedMessage) {
        if (this._isClpEncoded) {
            this._logtypeIdFwdIndex.putInt(this._mutableLogtypeDict.index((Object)clpEncodedMessage.getLogtype()));
            byte[][] dictVars = clpEncodedMessage.getDictionaryVarsAsByteArrays();
            if (null == dictVars || 0 == dictVars.length) {
                this._dictVarIdFwdIndex.putIntMV(ArrayUtils.EMPTY_INT_ARRAY);
            } else {
                int[] dictVarIds = new int[dictVars.length];
                for (int i = 0; i < dictVars.length; ++i) {
                    dictVarIds[i] = this._mutableDictVarDict.index((Object)dictVars[i]);
                }
                this._dictVarIdFwdIndex.putIntMV(dictVarIds);
            }
            long[] encodedVars = clpEncodedMessage.getEncodedVars();
            if (null == encodedVars || 0 == encodedVars.length) {
                this._encodedVarFwdIndex.putLongMV(ArrayUtils.EMPTY_LONG_ARRAY);
            } else {
                this._encodedVarFwdIndex.putLongMV(encodedVars);
            }
        } else {
            this._rawMsgFwdIndex.putBytes(clpEncodedMessage.getMessage());
        }
    }

    public void seal() {
        try {
            if (this.isClpEncoded()) {
                try {
                    this._logtypeDict.close();
                    this._logtypeIdFwdIndex.close();
                    this._dictVarDict.close();
                    this._dictVarIdFwdIndex.close();
                    this._encodedVarFwdIndex.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to close dictionaries and forward indexes for column: " + this._column, e);
                }
            }
            try {
                this._rawMsgFwdIndex.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close raw message forward index for column: " + this._column, e);
            }
            long totalSize = 0L;
            this._fileBuffer.putInt(MAGIC_BYTES.length);
            totalSize += 4L;
            this._fileBuffer.put(MAGIC_BYTES);
            totalSize += (long)MAGIC_BYTES.length;
            this._fileBuffer.putInt(2);
            totalSize += 4L;
            this._fileBuffer.putInt(this._isClpEncoded ? 1 : 0);
            totalSize += 4L;
            if (this._isClpEncoded) {
                this._fileBuffer.putInt(this._logtypeDictSize);
                totalSize += 4L;
                this._fileBuffer.putInt(this._dictVarDictSize);
                totalSize += 4L;
                this._fileBuffer.putInt((int)this._logtypeDictFile.length());
                totalSize += 4L;
                this._fileBuffer.putInt((int)this._dictVarDictFile.length());
                totalSize += 4L;
                this._fileBuffer.putInt((int)this._logtypeIdFwdIndexFile.length());
                totalSize += 4L;
                this._fileBuffer.putInt((int)this._dictVarIdFwdIndexFile.length());
                totalSize += 4L;
                this._fileBuffer.putInt((int)this._encodedVarFwdIndexFile.length());
                totalSize += 4L;
                this.copyFileIntoBuffer(this._logtypeDictFile);
                totalSize += this._logtypeDictFile.length();
                this.copyFileIntoBuffer(this._dictVarDictFile);
                totalSize += this._dictVarDictFile.length();
                this.copyFileIntoBuffer(this._logtypeIdFwdIndexFile);
                totalSize += this._logtypeIdFwdIndexFile.length();
                this.copyFileIntoBuffer(this._dictVarIdFwdIndexFile);
                totalSize += this._dictVarIdFwdIndexFile.length();
                this.copyFileIntoBuffer(this._encodedVarFwdIndexFile);
                totalSize += this._encodedVarFwdIndexFile.length();
            } else {
                this._fileBuffer.putInt((int)this._rawMsgFwdIndexFile.length());
                totalSize += 4L;
                this.copyFileIntoBuffer(this._rawMsgFwdIndexFile);
                totalSize += this._rawMsgFwdIndexFile.length();
            }
            this._dataFile.truncate(totalSize);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to seal forward indexes for column: " + this._column, e);
        }
    }

    public void close() throws IOException {
        FileUtils.deleteDirectory((File)this._intermediateFilesDir);
        this._dataFile.close();
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.STRING;
    }

    private void copyFileIntoBuffer(File file) throws IOException {
        try (FileChannel from = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
            this._fileBuffer.put(from.map(FileChannel.MapMode.READ_ONLY, 0L, file.length()));
        }
    }
}

