/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.pinot.common.utils.FileUtils;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.local.segment.creator.impl.ColumnJsonParserException;
import org.apache.pinot.segment.local.segment.creator.impl.SameValueForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.segment.local.segment.creator.impl.nullvalue.NullValueVectorCreator;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexPlugin;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexType;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.V1Constants;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.ColumnIndexCreationInfo;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentCreator;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.index.DictionaryIndexConfig;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.IndexCreator;
import org.apache.pinot.segment.spi.index.IndexService;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.TextIndexConfig;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.creator.SegmentIndexCreationInfo;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.SegmentZKPropsConfig;
import org.apache.pinot.spi.data.ComplexFieldSpec;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.env.CommonsConfigurationUtils;
import org.apache.pinot.spi.utils.TimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentColumnarIndexCreator
implements SegmentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentColumnarIndexCreator.class);
    static final int METADATA_PROPERTY_LENGTH_LIMIT = 512;
    private SegmentGeneratorConfig _config;
    private TreeMap<String, ColumnIndexCreationInfo> _indexCreationInfoMap;
    private final Map<String, SegmentDictionaryCreator> _dictionaryCreatorMap = new HashMap<String, SegmentDictionaryCreator>();
    private Map<String, Map<IndexType<?, ?, ?>, IndexCreator>> _creatorsByColAndIndex = new HashMap();
    private final Map<String, NullValueVectorCreator> _nullValueVectorCreatorMap = new HashMap<String, NullValueVectorCreator>();
    private String _segmentName;
    private Schema _schema;
    private File _indexDir;
    private int _totalDocs;
    private int _docIdCounter;

    public void init(SegmentGeneratorConfig segmentCreationSpec, SegmentIndexCreationInfo segmentIndexCreationInfo, TreeMap<String, ColumnIndexCreationInfo> indexCreationInfoMap, Schema schema, File outDir, @Nullable int[] immutableToMutableIdMap) throws Exception {
        this._docIdCounter = 0;
        this._config = segmentCreationSpec;
        this._indexCreationInfoMap = indexCreationInfoMap;
        Preconditions.checkState((!outDir.exists() ? 1 : 0) != 0, (String)"Segment output directory: %s already exists", (Object)outDir);
        Preconditions.checkState((boolean)outDir.mkdirs(), (String)"Failed to create output directory: %s", (Object)outDir);
        this._indexDir = outDir;
        this._schema = schema;
        this._totalDocs = segmentIndexCreationInfo.getTotalDocs();
        if (this._totalDocs == 0) {
            return;
        }
        Map indexConfigs = segmentCreationSpec.getIndexConfigsByColName();
        this._creatorsByColAndIndex = Maps.newHashMapWithExpectedSize((int)indexConfigs.keySet().size());
        for (String columnName : indexConfigs.keySet()) {
            Object fakeForwardValue;
            IndexType forwardIdx;
            FieldSpec fieldSpec = schema.getFieldSpecFor(columnName);
            Preconditions.checkState((fieldSpec != null ? 1 : 0) != 0, (String)"Failed to find column: %s in the schema", (Object)columnName);
            if (fieldSpec.isVirtualColumn()) {
                LOGGER.warn("Ignoring index creation for virtual column {}", (Object)columnName);
                continue;
            }
            FieldIndexConfigs originalConfig = (FieldIndexConfigs)indexConfigs.get(columnName);
            ColumnIndexCreationInfo columnIndexCreationInfo = indexCreationInfoMap.get(columnName);
            Preconditions.checkNotNull((Object)columnIndexCreationInfo, (String)"Missing index creation info for column: %s", (Object)columnName);
            boolean dictEnabledColumn = this.createDictionaryForColumn(columnIndexCreationInfo, segmentCreationSpec, fieldSpec);
            if (originalConfig.getConfig(StandardIndexes.inverted()).isEnabled()) {
                Preconditions.checkState((boolean)dictEnabledColumn, (String)"Cannot create inverted index for raw index column: %s", (Object)columnName);
            }
            boolean forwardIndexDisabled = !((ForwardIndexConfig)originalConfig.getConfig(forwardIdx = StandardIndexes.forward())).isEnabled();
            IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(this._indexDir).withDictionary(dictEnabledColumn).withFieldSpec(fieldSpec).withTotalDocs(segmentIndexCreationInfo.getTotalDocs()).withColumnIndexCreationInfo(columnIndexCreationInfo).withOptimizedDictionary(this._config.isOptimizeDictionary() || this._config.isOptimizeDictionaryForMetrics() && fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC).onHeap(segmentCreationSpec.isOnHeap()).withForwardIndexDisabled(forwardIndexDisabled).withTextCommitOnClose(true).withImmutableToMutableIdMap(immutableToMutableIdMap).withRealtimeConversion(segmentCreationSpec.isRealtimeConversion()).withConsumerDir(segmentCreationSpec.getConsumerDir()).build();
            FieldIndexConfigs config = this.adaptConfig(columnName, originalConfig, columnIndexCreationInfo, segmentCreationSpec);
            if (dictEnabledColumn) {
                DictionaryIndexConfig dictConfig = (DictionaryIndexConfig)config.getConfig(StandardIndexes.dictionary());
                if (!dictConfig.isEnabled()) {
                    LOGGER.info("Creating dictionary index in column {}.{} even when it is disabled in config", (Object)segmentCreationSpec.getTableName(), (Object)columnName);
                }
                if (this._config.isOptimizeDictionaryType()) {
                    LOGGER.info("Overriding dictionary type for column: {} using var-length dictionary: {}", (Object)columnName, (Object)columnIndexCreationInfo.isUseVarLengthDictionary());
                    dictConfig = new DictionaryIndexConfig(dictConfig, columnIndexCreationInfo.isUseVarLengthDictionary());
                }
                SegmentDictionaryCreator creator = new DictionaryIndexPlugin().getIndexType().createIndexCreator((IndexCreationContext)context, dictConfig);
                try {
                    creator.build(context.getSortedUniqueElementsArray());
                }
                catch (Exception e) {
                    LOGGER.error("Error building dictionary for field: {}, cardinality: {}, number of bytes per entry: {}", new Object[]{context.getFieldSpec().getName(), context.getCardinality(), creator.getNumBytesPerEntry()});
                    throw e;
                }
                this._dictionaryCreatorMap.put(columnName, creator);
            }
            HashMap creatorsByIndex = Maps.newHashMapWithExpectedSize((int)IndexService.getInstance().getAllIndexes().size());
            for (IndexType index : IndexService.getInstance().getAllIndexes()) {
                if (index.getIndexBuildLifecycle() != IndexType.BuildLifecycle.DURING_SEGMENT_CREATION) continue;
                this.tryCreateIndexCreator(creatorsByIndex, index, context, config);
            }
            IndexCreator oldFwdCreator = (IndexCreator)creatorsByIndex.get(forwardIdx);
            if (oldFwdCreator != null && (fakeForwardValue = this.calculateRawValueForTextIndex(dictEnabledColumn, config, fieldSpec)) != null) {
                ForwardIndexCreator castedOldFwdCreator = (ForwardIndexCreator)oldFwdCreator;
                SameValueForwardIndexCreator fakeValueFwdCreator = new SameValueForwardIndexCreator(fakeForwardValue, castedOldFwdCreator);
                creatorsByIndex.put(forwardIdx, fakeValueFwdCreator);
            }
            this._creatorsByColAndIndex.put(columnName, creatorsByIndex);
        }
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            String columnName = fieldSpec.getName();
            if (this.isNullable(fieldSpec)) {
                LOGGER.info("Column: {} is nullable", (Object)columnName);
                this._nullValueVectorCreatorMap.put(columnName, new NullValueVectorCreator(this._indexDir, columnName));
                continue;
            }
            LOGGER.info("Column: {} is not nullable", (Object)columnName);
        }
    }

    private boolean isNullable(FieldSpec fieldSpec) {
        return this._schema.isEnableColumnBasedNullHandling() ? fieldSpec.isNullable() : this._config.isDefaultNullHandlingEnabled();
    }

    private FieldIndexConfigs adaptConfig(String columnName, FieldIndexConfigs config, ColumnIndexCreationInfo columnIndexCreationInfo, SegmentGeneratorConfig segmentCreationSpec) {
        FieldIndexConfigs.Builder builder = new FieldIndexConfigs.Builder(config);
        ForwardIndexConfig fwdConfig = (ForwardIndexConfig)config.getConfig(StandardIndexes.forward());
        if (!fwdConfig.isEnabled() && columnIndexCreationInfo.isSorted()) {
            builder.add(StandardIndexes.forward(), (IndexConfig)new ForwardIndexConfig.Builder(fwdConfig).withLegacyProperties(segmentCreationSpec.getColumnProperties(), columnName).build());
        }
        if (columnIndexCreationInfo.isSorted()) {
            builder.undeclare(StandardIndexes.inverted());
        }
        return builder.build();
    }

    private <C extends IndexConfig> void tryCreateIndexCreator(Map<IndexType<?, ?, ?>, IndexCreator> creatorsByIndex, IndexType<C, ?, ?> index, IndexCreationContext.Common context, FieldIndexConfigs fieldIndexConfigs) throws Exception {
        IndexConfig config = fieldIndexConfigs.getConfig(index);
        if (config.isEnabled()) {
            creatorsByIndex.put(index, index.createIndexCreator((IndexCreationContext)context, config));
        }
    }

    private boolean createDictionaryForColumn(ColumnIndexCreationInfo info, SegmentGeneratorConfig config, FieldSpec spec) {
        if (spec instanceof ComplexFieldSpec) {
            return false;
        }
        String column = spec.getName();
        FieldIndexConfigs fieldIndexConfigs = (FieldIndexConfigs)config.getIndexConfigsByColName().get(column);
        if (((DictionaryIndexConfig)fieldIndexConfigs.getConfig(StandardIndexes.dictionary())).isDisabled()) {
            return false;
        }
        return DictionaryIndexType.ignoreDictionaryOverride(config.isOptimizeDictionary(), config.isOptimizeDictionaryForMetrics(), config.getNoDictionarySizeRatioThreshold(), config.getNoDictionaryCardinalityRatioThreshold(), spec, fieldIndexConfigs, info.getDistinctValueCount(), info.getTotalNumberOfEntries());
    }

    @Deprecated
    public static ChunkCompressionType getDefaultCompressionType(FieldSpec.FieldType fieldType) {
        return ForwardIndexType.getDefaultCompressionType(fieldType);
    }

    public void indexRow(GenericRow row) throws IOException {
        for (Map.Entry<String, Map<IndexType<?, ?, ?>, IndexCreator>> entry : this._creatorsByColAndIndex.entrySet()) {
            String columnName = entry.getKey();
            Object columnValueToIndex = row.getValue(columnName);
            if (columnValueToIndex == null) {
                throw new RuntimeException("Null value for column:" + columnName);
            }
            Map<IndexType<?, ?, ?>, IndexCreator> creatorsByIndex = entry.getValue();
            FieldSpec fieldSpec = this._schema.getFieldSpecFor(columnName);
            SegmentDictionaryCreator dictionaryCreator = this._dictionaryCreatorMap.get(columnName);
            try {
                if (fieldSpec.isSingleValueField()) {
                    this.indexSingleValueRow(dictionaryCreator, columnValueToIndex, creatorsByIndex);
                    continue;
                }
                this.indexMultiValueRow(dictionaryCreator, (Object[])columnValueToIndex, creatorsByIndex);
            }
            catch (JsonParseException jpe) {
                throw new ColumnJsonParserException(columnName, jpe);
            }
        }
        for (Map.Entry<String, Object> entry : this._nullValueVectorCreatorMap.entrySet()) {
            if (!row.isNullValue(entry.getKey())) continue;
            ((NullValueVectorCreator)entry.getValue()).setNull(this._docIdCounter);
        }
        ++this._docIdCounter;
    }

    public void indexColumn(String columnName, @Nullable int[] sortedDocIds, IndexSegment segment) throws IOException {
        int numDocs = segment.getSegmentMetadata().getTotalDocs();
        if (numDocs == 0) {
            return;
        }
        try (PinotSegmentColumnReader colReader = new PinotSegmentColumnReader(segment, columnName);){
            Map<IndexType<?, ?, ?>, IndexCreator> creatorsByIndex = this._creatorsByColAndIndex.get(columnName);
            NullValueVectorCreator nullVec = this._nullValueVectorCreatorMap.get(columnName);
            FieldSpec fieldSpec = this._schema.getFieldSpecFor(columnName);
            SegmentDictionaryCreator dictionaryCreator = this._dictionaryCreatorMap.get(columnName);
            if (sortedDocIds != null) {
                int onDiskDocId = 0;
                for (int docId : sortedDocIds) {
                    this.indexColumnValue(colReader, creatorsByIndex, columnName, fieldSpec, dictionaryCreator, docId, onDiskDocId, nullVec);
                    ++onDiskDocId;
                }
            } else {
                for (int docId = 0; docId < numDocs; ++docId) {
                    this.indexColumnValue(colReader, creatorsByIndex, columnName, fieldSpec, dictionaryCreator, docId, docId, nullVec);
                }
            }
        }
    }

    private void indexColumnValue(PinotSegmentColumnReader colReader, Map<IndexType<?, ?, ?>, IndexCreator> creatorsByIndex, String columnName, FieldSpec fieldSpec, SegmentDictionaryCreator dictionaryCreator, int sourceDocId, int onDiskDocPos, @Nullable NullValueVectorCreator nullVec) throws IOException {
        Object columnValueToIndex = colReader.getValue(sourceDocId);
        if (columnValueToIndex == null) {
            throw new RuntimeException("Null value for column:" + columnName);
        }
        if (fieldSpec.isSingleValueField()) {
            this.indexSingleValueRow(dictionaryCreator, columnValueToIndex, creatorsByIndex);
        } else {
            this.indexMultiValueRow(dictionaryCreator, (Object[])columnValueToIndex, creatorsByIndex);
        }
        if (nullVec != null && colReader.isNull(sourceDocId)) {
            nullVec.setNull(onDiskDocPos);
        }
    }

    private void indexSingleValueRow(SegmentDictionaryCreator dictionaryCreator, Object value, Map<IndexType<?, ?, ?>, IndexCreator> creatorsByIndex) throws IOException {
        int dictId = dictionaryCreator != null ? dictionaryCreator.indexOfSV(value) : -1;
        for (IndexCreator creator : creatorsByIndex.values()) {
            creator.add(value, dictId);
        }
    }

    private void indexMultiValueRow(SegmentDictionaryCreator dictionaryCreator, Object[] values, Map<IndexType<?, ?, ?>, IndexCreator> creatorsByIndex) throws IOException {
        int[] dictId = dictionaryCreator != null ? dictionaryCreator.indexOfMV(values) : null;
        for (IndexCreator creator : creatorsByIndex.values()) {
            creator.add(values, dictId);
        }
    }

    @Nullable
    private Object calculateRawValueForTextIndex(boolean dictEnabledColumn, FieldIndexConfigs configs, FieldSpec fieldSpec) {
        if (dictEnabledColumn) {
            return null;
        }
        TextIndexConfig textConfig = (TextIndexConfig)configs.getConfig(StandardIndexes.text());
        if (!textConfig.isEnabled()) {
            return null;
        }
        Object rawValue = textConfig.getRawValueForTextIndex();
        if (rawValue == null) {
            return null;
        }
        if (!fieldSpec.isSingleValueField()) {
            if (fieldSpec.getDataType().getStoredType() == FieldSpec.DataType.STRING) {
                if (!(rawValue instanceof String[])) {
                    rawValue = new String[]{String.valueOf(rawValue)};
                }
            } else if (fieldSpec.getDataType().getStoredType() == FieldSpec.DataType.BYTES) {
                if (!(rawValue instanceof String[])) {
                    rawValue = new byte[][]{String.valueOf(rawValue).getBytes(StandardCharsets.UTF_8)};
                }
            } else {
                throw new RuntimeException("Text Index is only supported for STRING and BYTES stored type");
            }
        }
        return rawValue;
    }

    public void setSegmentName(String segmentName) {
        this._segmentName = segmentName;
    }

    public void seal() throws ConfigurationException, IOException {
        for (SegmentDictionaryCreator segmentDictionaryCreator : this._dictionaryCreatorMap.values()) {
            segmentDictionaryCreator.seal();
        }
        for (NullValueVectorCreator nullValueVectorCreator : this._nullValueVectorCreatorMap.values()) {
            nullValueVectorCreator.seal();
        }
        for (Map map : this._creatorsByColAndIndex.values()) {
            for (IndexCreator creator : map.values()) {
                creator.seal();
            }
        }
        this.writeMetadata();
    }

    private void writeMetadata() throws ConfigurationException {
        Object timeColumnIndexCreationInfo;
        File metadataFile = new File(this._indexDir, "metadata.properties");
        PropertiesConfiguration properties = CommonsConfigurationUtils.fromFile((File)metadataFile);
        properties.setProperty("creator.version", (Object)this._config.getCreatorVersion());
        properties.setProperty("segment.padding.character", (Object)String.valueOf('\u0000'));
        properties.setProperty("segment.name", (Object)this._segmentName);
        properties.setProperty("segment.table.name", (Object)this._config.getTableName());
        properties.setProperty("segment.dimension.column.names", (Object)this._config.getDimensions());
        properties.setProperty("segment.metric.column.names", (Object)this._config.getMetrics());
        properties.setProperty("segment.datetime.column.names", (Object)this._config.getDateTimeColumnNames());
        properties.setProperty("segment.complex.column.names", (Object)this._config.getComplexColumnNames());
        String timeColumnName = this._config.getTimeColumnName();
        properties.setProperty("segment.time.column.name", (Object)timeColumnName);
        properties.setProperty("segment.total.docs", (Object)String.valueOf(this._totalDocs));
        if (timeColumnName != null && (timeColumnIndexCreationInfo = this._indexCreationInfoMap.get(timeColumnName)) != null) {
            TimeUnit timeUnit;
            long endTime;
            long l;
            if (this._config.getStartTime() != null) {
                l = Long.parseLong(this._config.getStartTime());
                endTime = Long.parseLong(this._config.getEndTime());
                timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this._config.getSegmentTimeUnit())));
            } else if (this._totalDocs > 0) {
                String startTimeStr = timeColumnIndexCreationInfo.getMin().toString();
                String endTimeStr = timeColumnIndexCreationInfo.getMax().toString();
                if (this._config.getTimeColumnType() == SegmentGeneratorConfig.TimeColumnType.SIMPLE_DATE) {
                    DateTimeFormatSpec formatSpec = this._config.getDateTimeFormatSpec();
                    Preconditions.checkNotNull((Object)formatSpec, (Object)"DateTimeFormatSpec must exist for SimpleDate");
                    DateTimeFormatter dateTimeFormatter = formatSpec.getDateTimeFormatter();
                    l = dateTimeFormatter.parseMillis(startTimeStr);
                    endTime = dateTimeFormatter.parseMillis(endTimeStr);
                    timeUnit = TimeUnit.MILLISECONDS;
                } else {
                    l = Long.parseLong(startTimeStr);
                    endTime = Long.parseLong(endTimeStr);
                    timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this._config.getSegmentTimeUnit())));
                }
            } else {
                long now = System.currentTimeMillis();
                if (this._config.getTimeColumnType() == SegmentGeneratorConfig.TimeColumnType.SIMPLE_DATE) {
                    l = now;
                    endTime = now;
                    timeUnit = TimeUnit.MILLISECONDS;
                } else {
                    timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this._config.getSegmentTimeUnit())));
                    l = timeUnit.convert(now, TimeUnit.MILLISECONDS);
                    endTime = timeUnit.convert(now, TimeUnit.MILLISECONDS);
                }
            }
            if (!this._config.isSkipTimeValueCheck()) {
                Interval timeInterval = new Interval(timeUnit.toMillis(l), timeUnit.toMillis(endTime), DateTimeZone.UTC);
                Preconditions.checkState((boolean)TimeUtils.isValidTimeInterval((Interval)timeInterval), (String)"Invalid segment start/end time: %s (in millis: %s/%s) for time column: %s, must be between: %s", (Object[])new Object[]{timeInterval, timeInterval.getStartMillis(), timeInterval.getEndMillis(), timeColumnName, TimeUtils.VALID_TIME_INTERVAL});
            }
            properties.setProperty("segment.start.time", (Object)l);
            properties.setProperty("segment.end.time", (Object)endTime);
            properties.setProperty("segment.time.unit", (Object)timeUnit);
        }
        for (Map.Entry entry : this._config.getCustomProperties().entrySet()) {
            properties.setProperty((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this._indexCreationInfoMap.entrySet()) {
            String column = (String)entry.getKey();
            ColumnIndexCreationInfo columnIndexCreationInfo = (ColumnIndexCreationInfo)entry.getValue();
            SegmentDictionaryCreator dictionaryCreator = this._dictionaryCreatorMap.get(column);
            int dictionaryElementSize = dictionaryCreator != null ? dictionaryCreator.getNumBytesPerEntry() : 0;
            SegmentColumnarIndexCreator.addColumnMetadataInfo(properties, column, columnIndexCreationInfo, this._totalDocs, this._schema.getFieldSpecFor(column), dictionaryCreator != null, dictionaryElementSize);
        }
        SegmentZKPropsConfig segmentZKPropsConfig = this._config.getSegmentZKPropsConfig();
        if (segmentZKPropsConfig != null) {
            properties.setProperty("segment.realtime.startOffset", (Object)segmentZKPropsConfig.getStartOffset());
            properties.setProperty("segment.realtime.endOffset", (Object)segmentZKPropsConfig.getEndOffset());
        }
        CommonsConfigurationUtils.saveToFile((PropertiesConfiguration)properties, (File)metadataFile);
    }

    public static void addColumnMetadataInfo(PropertiesConfiguration properties, String column, ColumnIndexCreationInfo columnIndexCreationInfo, int totalDocs, FieldSpec fieldSpec, boolean hasDictionary, int dictionaryElementSize) {
        PartitionFunction partitionFunction;
        int cardinality = columnIndexCreationInfo.getDistinctValueCount();
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"cardinality"), (Object)String.valueOf(cardinality));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"totalDocs"), (Object)String.valueOf(totalDocs));
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"dataType"), (Object)String.valueOf(dataType));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"bitsPerElement"), (Object)String.valueOf(PinotDataBitSet.getNumBitsPerValue(cardinality - 1)));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"lengthOfEachEntry"), (Object)String.valueOf(dictionaryElementSize));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"columnType"), (Object)String.valueOf(fieldSpec.getFieldType()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"isSorted"), (Object)String.valueOf(columnIndexCreationInfo.isSorted()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"hasDictionary"), (Object)String.valueOf(hasDictionary));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"isSingleValues"), (Object)String.valueOf(fieldSpec.isSingleValueField()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"maxNumberOfMultiValues"), (Object)String.valueOf(columnIndexCreationInfo.getMaxNumberOfMultiValueElements()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"totalNumberOfEntries"), (Object)String.valueOf(columnIndexCreationInfo.getTotalNumberOfEntries()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"isAutoGenerated"), (Object)String.valueOf(columnIndexCreationInfo.isAutoGenerated()));
        if (dataType.equals((Object)FieldSpec.DataType.STRING) || dataType.equals((Object)FieldSpec.DataType.BYTES) || dataType.equals((Object)FieldSpec.DataType.JSON)) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"schemaMaxLength"), (Object)fieldSpec.getMaxLength());
            FieldSpec.MaxLengthExceedStrategy maxLengthExceedStrategy = fieldSpec.getMaxLengthExceedStrategy();
            if (maxLengthExceedStrategy != null) {
                properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"schemaMaxLengthExceedStrategy"), (Object)maxLengthExceedStrategy);
            }
        }
        if ((partitionFunction = columnIndexCreationInfo.getPartitionFunction()) != null) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"partitionFunction"), (Object)partitionFunction.getName());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"numPartitions"), (Object)columnIndexCreationInfo.getNumPartitions());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"partitionValues"), (Object)columnIndexCreationInfo.getPartitions());
            if (columnIndexCreationInfo.getPartitionFunctionConfig() != null) {
                for (Map.Entry entry : columnIndexCreationInfo.getPartitionFunctionConfig().entrySet()) {
                    properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)String.format("%s.%s", "partitionFunctionConfig", entry.getKey())), entry.getValue());
                }
            }
        }
        if (fieldSpec.getFieldType() == FieldSpec.FieldType.DATE_TIME) {
            DateTimeFieldSpec dateTimeFieldSpec = (DateTimeFieldSpec)fieldSpec;
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"datetimeFormat"), (Object)dateTimeFieldSpec.getFormat());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"datetimeGranularity"), (Object)dateTimeFieldSpec.getGranularity());
        }
        if (fieldSpec.getFieldType() == FieldSpec.FieldType.COMPLEX) {
            ComplexFieldSpec complexFieldSpec = (ComplexFieldSpec)fieldSpec;
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"complexChildFieldNames"), new ArrayList(complexFieldSpec.getChildFieldSpecs().keySet()));
            for (Map.Entry entry : complexFieldSpec.getChildFieldSpecs().entrySet()) {
                SegmentColumnarIndexCreator.addFieldSpec(properties, ComplexFieldSpec.getFullChildName((String[])new String[]{column, (String)entry.getKey()}), (FieldSpec)entry.getValue());
            }
        }
        if (fieldSpec.getFieldType() != FieldSpec.FieldType.COMPLEX && totalDocs > 0) {
            Object min = columnIndexCreationInfo.getMin();
            Object object = columnIndexCreationInfo.getMax();
            if (min != null && object != null) {
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(properties, column, min, object, dataType.getStoredType());
            }
        }
        String defaultNullValue = columnIndexCreationInfo.getDefaultNullValue().toString();
        if (dataType.getStoredType() == FieldSpec.DataType.STRING) {
            defaultNullValue = CommonsConfigurationUtils.replaceSpecialCharacterInPropertyValue((String)defaultNullValue);
        }
        if (defaultNullValue != null) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"defaultNullValue"), (Object)defaultNullValue);
        }
    }

    public static void addFieldSpec(PropertiesConfiguration properties, String column, FieldSpec fieldSpec) {
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"columnType"), (Object)String.valueOf(fieldSpec.getFieldType()));
        if (!column.equals(fieldSpec.getName())) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"columnName"), (Object)String.valueOf(fieldSpec.getName()));
        }
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"dataType"), (Object)String.valueOf(dataType));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"isSingleValues"), (Object)String.valueOf(fieldSpec.isSingleValueField()));
        if (dataType.equals((Object)FieldSpec.DataType.STRING) || dataType.equals((Object)FieldSpec.DataType.BYTES) || dataType.equals((Object)FieldSpec.DataType.JSON)) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"schemaMaxLength"), (Object)fieldSpec.getMaxLength());
            FieldSpec.MaxLengthExceedStrategy maxLengthExceedStrategy = fieldSpec.getMaxLengthExceedStrategy();
            if (maxLengthExceedStrategy != null) {
                properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"schemaMaxLengthExceedStrategy"), (Object)maxLengthExceedStrategy);
            }
        }
        if (fieldSpec.getFieldType() == FieldSpec.FieldType.DATE_TIME) {
            DateTimeFieldSpec dateTimeFieldSpec = (DateTimeFieldSpec)fieldSpec;
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"datetimeFormat"), (Object)dateTimeFieldSpec.getFormat());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"datetimeGranularity"), (Object)dateTimeFieldSpec.getGranularity());
        }
        if (fieldSpec.getFieldType() == FieldSpec.FieldType.COMPLEX) {
            ComplexFieldSpec complexFieldSpec = (ComplexFieldSpec)fieldSpec;
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"complexChildFieldNames"), new ArrayList(complexFieldSpec.getChildFieldSpecs().keySet()));
            for (Map.Entry entry : complexFieldSpec.getChildFieldSpecs().entrySet()) {
                SegmentColumnarIndexCreator.addFieldSpec(properties, ComplexFieldSpec.getFullChildName((String[])new String[]{column, (String)entry.getKey()}), (FieldSpec)entry.getValue());
            }
        }
    }

    public static void addColumnMinMaxValueInfo(PropertiesConfiguration properties, String column, @Nullable Object minValue, @Nullable Object maxValue, FieldSpec.DataType storedType) {
        String validMaxValue;
        String validMinValue;
        String string = validMinValue = minValue != null ? SegmentColumnarIndexCreator.getValidPropertyValue(minValue.toString(), storedType) : null;
        if (validMinValue != null) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"minValue"), (Object)validMinValue);
        }
        String string2 = validMaxValue = maxValue != null ? SegmentColumnarIndexCreator.getValidPropertyValue(maxValue.toString(), storedType) : null;
        if (validMaxValue != null) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"maxValue"), (Object)validMaxValue);
        }
        if (validMinValue == null && validMaxValue == null) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"minMaxValueInvalid"), (Object)true);
        }
    }

    @Nullable
    private static String getValidPropertyValue(String value, FieldSpec.DataType storedType) {
        if (value.length() > 512) {
            return null;
        }
        return storedType == FieldSpec.DataType.STRING ? CommonsConfigurationUtils.replaceSpecialCharacterInPropertyValue((String)value) : value;
    }

    public static void removeColumnMetadataInfo(PropertiesConfiguration properties, String column) {
        properties.subset("column." + column).clear();
    }

    public void close() throws IOException {
        List creators = this._creatorsByColAndIndex.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
        creators.addAll(this._nullValueVectorCreatorMap.values());
        creators.addAll(this._dictionaryCreatorMap.values());
        FileUtils.close(creators);
    }
}

