/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;

class SchemaTreeNode {
    private boolean _isColumn;
    private final Map<String, SchemaTreeNode> _children;
    @Nonnull
    private final String _keyName;
    @Nullable
    private String _columnName;
    @Nullable
    private final String _parentPath;
    private FieldSpec _fieldSpec;

    public SchemaTreeNode(String keyName, String parentPath, Schema schema) {
        this._keyName = keyName;
        this._parentPath = parentPath;
        this._fieldSpec = schema.getFieldSpecFor(this.getJsonKeyPath());
        this._children = new HashMap<String, SchemaTreeNode>();
    }

    public boolean isColumn() {
        return this._isColumn;
    }

    public void setColumn(String columnName, Schema schema) {
        if (columnName == null) {
            this._columnName = this.getJsonKeyPath();
        } else {
            this._columnName = columnName;
            this._fieldSpec = schema.getFieldSpecFor(columnName);
        }
        this._isColumn = true;
    }

    public boolean hasChild(String key) {
        return this._children.containsKey(key);
    }

    public SchemaTreeNode getAndCreateChild(String key, Schema schema) {
        SchemaTreeNode child = this._children.get(key);
        if (child == null) {
            child = new SchemaTreeNode(key, this.getJsonKeyPath(), schema);
            this._children.put(key, child);
        }
        return child;
    }

    private SchemaTreeNode getChild(String key) {
        return this._children.get(key);
    }

    public SchemaTreeNode getChild(String key, boolean useAnonymousDot) {
        if (useAnonymousDot && key.contains(".")) {
            SchemaTreeNode node = this;
            for (String subKey : key.split("\\.")) {
                if (node == null) {
                    return null;
                }
                node = node.getChild(subKey);
            }
            return node;
        }
        return this.getChild(key);
    }

    public String getKeyName() {
        return this._keyName;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public Object getValue(Object value) {
        if (this._fieldSpec != null && this._fieldSpec.getDataType() == FieldSpec.DataType.STRING && this._fieldSpec.isSingleValueField()) {
            try {
                if (value instanceof Collection) {
                    return JsonUtils.objectToString((Object)value);
                }
                if (value instanceof Object[]) {
                    return JsonUtils.objectToString(Arrays.asList((Object[])value));
                }
                if (value instanceof Map) {
                    return JsonUtils.objectToString((Object)value);
                }
            }
            catch (JsonProcessingException e) {
                return value.toString();
            }
        }
        return value;
    }

    public String getJsonKeyPath() {
        if (this._parentPath == null || this._parentPath.isEmpty()) {
            return this._keyName;
        }
        return this._parentPath + "." + this._keyName;
    }
}

