/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.recordtransformer.ExtraFieldsContainer;
import org.apache.pinot.segment.local.recordtransformer.SchemaTreeNode;
import org.apache.pinot.segment.local.utils.Base64Utils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.SchemaConformingTransformerConfig;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.metrics.PinotMeter;
import org.apache.pinot.spi.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.stream.StreamDataDecoderImpl;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaConformingTransformer
implements RecordTransformer {
    private static final Logger _logger = LoggerFactory.getLogger(SchemaConformingTransformer.class);
    private static final int MAXIMUM_LUCENE_DOCUMENT_SIZE = 32766;
    private static final List<String> MERGED_TEXT_INDEX_SUFFIX_TO_EXCLUDE = Arrays.asList("_logtype", "_dictionaryVars", "_encodedVars");
    private final boolean _continueOnError;
    private final FieldSpec.DataType _indexableExtrasFieldType;
    private final FieldSpec.DataType _unindexableExtrasFieldType;
    private final DimensionFieldSpec _mergedTextIndexFieldSpec;
    private final SchemaConformingTransformerConfig _transformerConfig;
    @Nullable
    ServerMetrics _serverMetrics = null;
    private SchemaTreeNode _schemaTree;
    @Nullable
    private PinotMeter _realtimeMergedTextIndexTruncatedDocumentSizeMeter = null;
    private String _tableName;
    private int _jsonKeyValueSeparatorByteCount;
    private long _mergedTextIndexDocumentBytesCount = 0L;
    private long _mergedTextIndexDocumentCount = 0L;

    public SchemaConformingTransformer(TableConfig tableConfig, Schema schema) {
        if (null == tableConfig.getIngestionConfig() || null == tableConfig.getIngestionConfig().getSchemaConformingTransformerConfig()) {
            this._continueOnError = false;
            this._transformerConfig = null;
            this._indexableExtrasFieldType = null;
            this._unindexableExtrasFieldType = null;
            this._mergedTextIndexFieldSpec = null;
            return;
        }
        this._continueOnError = tableConfig.getIngestionConfig().isContinueOnError();
        this._transformerConfig = tableConfig.getIngestionConfig().getSchemaConformingTransformerConfig();
        String indexableExtrasFieldName = this._transformerConfig.getIndexableExtrasField();
        this._indexableExtrasFieldType = indexableExtrasFieldName == null ? null : SchemaConformingTransformer.getAndValidateExtrasFieldType(schema, indexableExtrasFieldName);
        String unindexableExtrasFieldName = this._transformerConfig.getUnindexableExtrasField();
        this._unindexableExtrasFieldType = unindexableExtrasFieldName == null ? null : SchemaConformingTransformer.getAndValidateExtrasFieldType(schema, unindexableExtrasFieldName);
        this._mergedTextIndexFieldSpec = schema.getDimensionSpec(this._transformerConfig.getMergedTextIndexField());
        this._tableName = tableConfig.getTableName();
        this._schemaTree = SchemaConformingTransformer.validateSchemaAndCreateTree(schema, this._transformerConfig);
        this._serverMetrics = ServerMetrics.get();
        this._jsonKeyValueSeparatorByteCount = this._transformerConfig.getJsonKeyValueSeparator().getBytes(StandardCharsets.UTF_8).length;
    }

    public static void validateSchema(@Nonnull Schema schema, @Nonnull SchemaConformingTransformerConfig transformerConfig) {
        String unindexableExtrasFieldName;
        SchemaConformingTransformer.validateSchemaFieldNames(schema.getPhysicalColumnNames(), transformerConfig);
        String indexableExtrasFieldName = transformerConfig.getIndexableExtrasField();
        if (null != indexableExtrasFieldName) {
            SchemaConformingTransformer.getAndValidateExtrasFieldType(schema, indexableExtrasFieldName);
        }
        if (null != (unindexableExtrasFieldName = transformerConfig.getUnindexableExtrasField())) {
            SchemaConformingTransformer.getAndValidateExtrasFieldType(schema, indexableExtrasFieldName);
        }
        Map columnNameToJsonKeyPathMap = transformerConfig.getColumnNameToJsonKeyPathMap();
        for (Map.Entry entry : columnNameToJsonKeyPathMap.entrySet()) {
            String columnName = (String)entry.getKey();
            FieldSpec fieldSpec = schema.getFieldSpecFor((String)entry.getKey());
            Preconditions.checkState((null != fieldSpec ? 1 : 0) != 0, (String)"Field '%s' doesn't exist in schema", (Object)columnName);
        }
        Set preserveFieldNames = transformerConfig.getFieldPathsToPreserveInput();
        for (String preserveFieldName : preserveFieldNames) {
            Preconditions.checkState((columnNameToJsonKeyPathMap.containsValue(preserveFieldName) || schema.getFieldSpecFor(preserveFieldName) != null ? 1 : 0) != 0, (String)"Preserved path '%s' doesn't exist in columnNameToJsonKeyPathMap or schema", (Object)preserveFieldName);
        }
        SchemaConformingTransformer.validateSchemaAndCreateTree(schema, transformerConfig);
    }

    public static boolean base64ValueFilter(byte[] bytes, int minLength) {
        return bytes.length >= minLength && Base64Utils.isBase64IgnoreTrailingPeriods(bytes);
    }

    private static void validateSchemaFieldNames(Set<String> schemaFields, SchemaConformingTransformerConfig transformerConfig) {
        Set fieldPathsToDrop;
        String unindexableFieldSuffix = transformerConfig.getUnindexableFieldSuffix();
        if (null != unindexableFieldSuffix) {
            for (String field : schemaFields) {
                Preconditions.checkState((!field.endsWith(unindexableFieldSuffix) ? 1 : 0) != 0, (String)"Field '%s' has no-index suffix '%s'", (Object)field, (Object)unindexableFieldSuffix);
            }
        }
        if (null != (fieldPathsToDrop = transformerConfig.getFieldPathsToDrop())) {
            HashSet<String> fieldIntersection = new HashSet<String>(schemaFields);
            fieldIntersection.retainAll(fieldPathsToDrop);
            Preconditions.checkState((boolean)fieldIntersection.isEmpty(), (Object)"Fields in schema overlap with fieldPathsToDrop");
        }
    }

    private static SchemaTreeNode validateSchemaAndCreateTree(@Nonnull Schema schema, @Nonnull SchemaConformingTransformerConfig transformerConfig) throws IllegalArgumentException {
        TreeSet schemaFields = schema.getPhysicalColumnNames();
        HashMap<String, String> jsonKeyPathToColumnNameMap = new HashMap<String, String>();
        for (Map.Entry entry : transformerConfig.getColumnNameToJsonKeyPathMap().entrySet()) {
            String columnName = (String)entry.getKey();
            String jsonKeyPath = (String)entry.getValue();
            schemaFields.remove(columnName);
            schemaFields.add(jsonKeyPath);
            jsonKeyPathToColumnNameMap.put(jsonKeyPath, columnName);
        }
        SchemaTreeNode rootNode = new SchemaTreeNode("", null, schema);
        ArrayList<String> subKeys = new ArrayList<String>();
        for (String field : schemaFields) {
            SchemaTreeNode currentNode = rootNode;
            int keySeparatorIdx = field.indexOf(".");
            if (-1 == keySeparatorIdx) {
                currentNode = rootNode.getAndCreateChild(field, schema);
            } else {
                subKeys.clear();
                SchemaConformingTransformer.getAndValidateSubKeys(field, keySeparatorIdx, subKeys);
                for (String subKey : subKeys) {
                    SchemaTreeNode childNode;
                    currentNode = childNode = currentNode.getAndCreateChild(subKey, schema);
                }
            }
            currentNode.setColumn((String)jsonKeyPathToColumnNameMap.get(field), schema);
        }
        return rootNode;
    }

    private static FieldSpec.DataType getAndValidateExtrasFieldType(Schema schema, @Nonnull String extrasFieldName) {
        FieldSpec fieldSpec = schema.getFieldSpecFor(extrasFieldName);
        Preconditions.checkState((null != fieldSpec ? 1 : 0) != 0, (String)"Field '%s' doesn't exist in schema", (Object)extrasFieldName);
        FieldSpec.DataType fieldDataType = fieldSpec.getDataType();
        Preconditions.checkState((FieldSpec.DataType.JSON == fieldDataType || FieldSpec.DataType.STRING == fieldDataType ? 1 : 0) != 0, (String)"Field '%s' has unsupported type %s", (Object)fieldDataType.toString());
        return fieldDataType;
    }

    private static void getAndValidateSubKeys(String key, int firstKeySeparatorIdx, List<String> subKeys) throws IllegalArgumentException {
        int subKeyBeginIdx = 0;
        int subKeyEndIdx = firstKeySeparatorIdx;
        int keyLength = key.length();
        while (true) {
            String subKey;
            if ((subKey = key.substring(subKeyBeginIdx, subKeyEndIdx)).isEmpty()) {
                throw new IllegalArgumentException("Unsupported empty sub-key in '" + key + "'.");
            }
            subKeys.add(subKey);
            subKeyBeginIdx = subKeyEndIdx + 1;
            if (subKeyBeginIdx >= keyLength) break;
            int keySeparatorIdx = key.indexOf(".", subKeyBeginIdx);
            if (-1 != keySeparatorIdx) {
                subKeyEndIdx = keySeparatorIdx;
                continue;
            }
            subKeyEndIdx = key.length();
        }
    }

    public boolean isNoOp() {
        return null == this._transformerConfig;
    }

    @Nullable
    public GenericRow transform(GenericRow record) {
        GenericRow outputRecord = new GenericRow();
        HashMap<String, Object> mergedTextIndexMap = new HashMap<String, Object>();
        try {
            ArrayDeque<String> jsonPath = new ArrayDeque<String>();
            ExtraFieldsContainer extraFieldsContainer = new ExtraFieldsContainer(null != this._transformerConfig.getUnindexableExtrasField());
            for (Map.Entry recordEntry : record.getFieldToValueMap().entrySet()) {
                String recordKey = (String)recordEntry.getKey();
                Object recordValue = recordEntry.getValue();
                jsonPath.addLast(recordKey);
                ExtraFieldsContainer currentFieldsContainer = this.processField(this._schemaTree, jsonPath, recordValue, true, outputRecord, mergedTextIndexMap);
                extraFieldsContainer.addChild(currentFieldsContainer);
                jsonPath.removeLast();
            }
            this.putExtrasField(this._transformerConfig.getIndexableExtrasField(), this._indexableExtrasFieldType, extraFieldsContainer.getIndexableExtras(), outputRecord);
            this.putExtrasField(this._transformerConfig.getUnindexableExtrasField(), this._unindexableExtrasFieldType, extraFieldsContainer.getUnindexableExtras(), outputRecord);
            if (null != this._mergedTextIndexFieldSpec && !mergedTextIndexMap.isEmpty()) {
                List<String> luceneDocuments = this.getLuceneDocumentsFromMergedTextIndexMap(mergedTextIndexMap);
                if (this._mergedTextIndexFieldSpec.isSingleValueField()) {
                    outputRecord.putValue(this._mergedTextIndexFieldSpec.getName(), (Object)String.join((CharSequence)" ", luceneDocuments));
                } else {
                    outputRecord.putValue(this._mergedTextIndexFieldSpec.getName(), luceneDocuments);
                }
            }
        }
        catch (Exception e) {
            if (!this._continueOnError) {
                throw e;
            }
            _logger.error("Couldn't transform record: {}", (Object)record.toString(), (Object)e);
            outputRecord.putValue("$INCOMPLETE_RECORD_KEY$", (Object)true);
        }
        return outputRecord;
    }

    private ExtraFieldsContainer processField(SchemaTreeNode parentNode, Deque<String> jsonPath, Object value, boolean isIndexable, GenericRow outputRecord, Map<String, Object> mergedTextIndexMap) {
        SchemaTreeNode currentNode;
        boolean storeIndexableExtras = this._transformerConfig.getIndexableExtrasField() != null;
        boolean storeUnindexableExtras = this._transformerConfig.getUnindexableExtrasField() != null;
        String key = jsonPath.peekLast();
        ExtraFieldsContainer extraFieldsContainer = new ExtraFieldsContainer(storeUnindexableExtras);
        if (StreamDataDecoderImpl.isSpecialKeyType((String)key) || GenericRow.isSpecialKeyType((String)key)) {
            outputRecord.putValue(key, value);
            return extraFieldsContainer;
        }
        String keyJsonPath = String.join((CharSequence)".", jsonPath);
        Set fieldPathsToDrop = this._transformerConfig.getFieldPathsToDrop();
        if (null != fieldPathsToDrop && fieldPathsToDrop.contains(keyJsonPath)) {
            return extraFieldsContainer;
        }
        SchemaTreeNode schemaTreeNode = currentNode = parentNode == null ? null : parentNode.getChild(key, this._transformerConfig.isUseAnonymousDotInFieldNames());
        if (this._transformerConfig.getFieldPathsToPreserveInput().contains(keyJsonPath) || this._transformerConfig.getFieldPathsToPreserveInputWithIndex().contains(keyJsonPath)) {
            if (currentNode != null) {
                outputRecord.putValue(currentNode.getColumnName(), currentNode.getValue(value));
            } else {
                outputRecord.putValue(keyJsonPath, value);
            }
            if (this._transformerConfig.getFieldPathsToPreserveInputWithIndex().contains(keyJsonPath)) {
                this.flattenAndAddToMergedTextIndexMap(mergedTextIndexMap, keyJsonPath, value);
            }
            return extraFieldsContainer;
        }
        String unindexableFieldSuffix = this._transformerConfig.getUnindexableFieldSuffix();
        boolean bl = isIndexable = isIndexable && (null == unindexableFieldSuffix || !key.endsWith(unindexableFieldSuffix));
        if (currentNode == null && !storeIndexableExtras && !storeUnindexableExtras) {
            return extraFieldsContainer;
        }
        if (value == null) {
            return extraFieldsContainer;
        }
        if (!(value instanceof Map)) {
            if (!isIndexable) {
                extraFieldsContainer.addUnindexableEntry(key, value);
            } else if (null != currentNode && currentNode.isColumn()) {
                outputRecord.putValue(currentNode.getColumnName(), currentNode.getValue(value));
                if (this._transformerConfig.getFieldsToDoubleIngest().contains(keyJsonPath)) {
                    extraFieldsContainer.addIndexableEntry(key, value);
                }
                mergedTextIndexMap.put(currentNode.getColumnName(), value);
            } else if (storeIndexableExtras) {
                if (!this._transformerConfig.getFieldPathsToSkipStorage().contains(keyJsonPath)) {
                    extraFieldsContainer.addIndexableEntry(key, value);
                }
                mergedTextIndexMap.put(keyJsonPath, value);
            }
            return extraFieldsContainer;
        }
        Map valueAsMap = (Map)value;
        for (Map.Entry entry : valueAsMap.entrySet()) {
            jsonPath.addLast((String)entry.getKey());
            ExtraFieldsContainer childContainer = this.processField(currentNode, jsonPath, entry.getValue(), isIndexable, outputRecord, mergedTextIndexMap);
            extraFieldsContainer.addChild(key, childContainer);
            jsonPath.removeLast();
        }
        return extraFieldsContainer;
    }

    public void generateTextIndexLuceneDocument(Map.Entry<String, Object> kv, List<String> indexDocuments, Integer mergedTextIndexDocumentMaxLength) {
        String key = kv.getKey();
        if (kv.getValue() instanceof Collection || kv.getValue() instanceof Object[]) {
            try {
                this.addLuceneDoc(indexDocuments, mergedTextIndexDocumentMaxLength, key, JsonUtils.objectToString((Object)kv.getValue()));
                if (kv.getValue() instanceof Collection) {
                    for (Object o : (Collection)kv.getValue()) {
                        this.addLuceneDoc(indexDocuments, mergedTextIndexDocumentMaxLength, key, JsonUtils.objectToString(o));
                    }
                } else if (kv.getValue() instanceof Object[]) {
                    for (Object o : (Object[])kv.getValue()) {
                        this.addLuceneDoc(indexDocuments, mergedTextIndexDocumentMaxLength, key, JsonUtils.objectToString((Object)o));
                    }
                }
            }
            catch (JsonProcessingException e) {
                this.addLuceneDoc(indexDocuments, mergedTextIndexDocumentMaxLength, key, kv.getValue().toString());
            }
            return;
        }
        this.addLuceneDoc(indexDocuments, mergedTextIndexDocumentMaxLength, key, kv.getValue().toString());
    }

    private void addLuceneDoc(List<String> indexDocuments, Integer mergedTextIndexDocumentMaxLength, String key, String val) {
        if (key.length() + this._jsonKeyValueSeparatorByteCount > 32766) {
            _logger.error("The provided key's length is too long, text index document cannot be truncated");
            return;
        }
        int valueTruncationLength = mergedTextIndexDocumentMaxLength - this._jsonKeyValueSeparatorByteCount - key.length();
        if (val.length() > valueTruncationLength) {
            this._realtimeMergedTextIndexTruncatedDocumentSizeMeter = this._serverMetrics.addMeteredTableValue(this._tableName, (AbstractMetrics.Meter)ServerMeter.REALTIME_MERGED_TEXT_IDX_TRUNCATED_DOCUMENT_SIZE, (long)(key.length() + this._jsonKeyValueSeparatorByteCount + val.length()), this._realtimeMergedTextIndexTruncatedDocumentSizeMeter);
            val = val.substring(0, valueTruncationLength);
        }
        this._mergedTextIndexDocumentBytesCount += (long)(key.length() + this._jsonKeyValueSeparatorByteCount + val.length());
        ++this._mergedTextIndexDocumentCount;
        this._serverMetrics.setValueOfTableGauge(this._tableName, (AbstractMetrics.Gauge)ServerGauge.REALTIME_MERGED_TEXT_IDX_DOCUMENT_AVG_LEN, this._mergedTextIndexDocumentBytesCount / this._mergedTextIndexDocumentCount);
        this.addKeyValueToDocuments(indexDocuments, key, val, this._transformerConfig.isReverseTextIndexKeyValueOrder(), this._transformerConfig.isOptimizeCaseInsensitiveSearch());
    }

    private void flattenAndAddToMergedTextIndexMap(Map<String, Object> mergedTextIndexMap, String key, Object value) {
        String unindexableFieldSuffix = this._transformerConfig.getUnindexableFieldSuffix();
        if (null != unindexableFieldSuffix && key.endsWith(unindexableFieldSuffix)) {
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                this.flattenAndAddToMergedTextIndexMap(mergedTextIndexMap, key + "." + (String)entry.getKey(), entry.getValue());
            }
        } else {
            mergedTextIndexMap.put(key, value);
        }
    }

    private void putExtrasField(String fieldName, FieldSpec.DataType fieldType, Map<String, Object> field, GenericRow outputRecord) {
        if (null == field) {
            return;
        }
        switch (fieldType) {
            case JSON: {
                outputRecord.putValue(fieldName, field);
                break;
            }
            case STRING: {
                try {
                    outputRecord.putValue(fieldName, (Object)JsonUtils.objectToString(field));
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Failed to convert '" + fieldName + "' to string", e);
                }
            }
            default: {
                throw new UnsupportedOperationException("Cannot convert '" + fieldName + "' to " + fieldType.name());
            }
        }
    }

    private List<String> getLuceneDocumentsFromMergedTextIndexMap(Map<String, Object> mergedTextIndexMap) {
        Integer mergedTextIndexDocumentMaxLength = this._transformerConfig.getMergedTextIndexDocumentMaxLength();
        ArrayList<String> luceneDocuments = new ArrayList<String>();
        mergedTextIndexMap.entrySet().stream().filter(kv -> null != kv.getKey() && null != kv.getValue()).filter(kv -> !this._transformerConfig.getMergedTextIndexPathToExclude().contains(kv.getKey())).filter(kv -> !SchemaConformingTransformer.base64ValueFilter(kv.getValue().toString().getBytes(), this._transformerConfig.getMergedTextIndexBinaryDocumentDetectionMinLength())).filter(kv -> !MERGED_TEXT_INDEX_SUFFIX_TO_EXCLUDE.stream().anyMatch(suffix -> ((String)kv.getKey()).endsWith((String)suffix))).forEach(kv -> this.generateTextIndexLuceneDocument((Map.Entry<String, Object>)kv, (List<String>)luceneDocuments, mergedTextIndexDocumentMaxLength));
        return luceneDocuments;
    }

    private void addKeyValueToDocuments(List<String> documents, String key, String value, boolean addInReverseOrder, boolean addCaseInsensitiveVersion) {
        this.addKeyValueToDocumentWithOrder(documents, key, value, addInReverseOrder);
        if (addCaseInsensitiveVersion && value.chars().anyMatch(Character::isUpperCase)) {
            this.addKeyValueToDocumentWithOrder(documents, key, value.toLowerCase(Locale.ENGLISH), addInReverseOrder);
        }
    }

    private void addKeyValueToDocumentWithOrder(List<String> documents, String key, String value, boolean addInReverseOrder) {
        if (addInReverseOrder) {
            documents.add(this._transformerConfig.getMergedTextIndexBeginOfDocAnchor() + value + this._transformerConfig.getJsonKeyValueSeparator() + key + this._transformerConfig.getMergedTextIndexEndOfDocAnchor());
        } else {
            documents.add(this._transformerConfig.getMergedTextIndexBeginOfDocAnchor() + key + this._transformerConfig.getJsonKeyValueSeparator() + value + this._transformerConfig.getMergedTextIndexEndOfDocAnchor());
        }
    }
}

