/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.recordtransformer.DataTypeTransformer;
import org.apache.pinot.segment.local.recordtransformer.ExpressionTransformer;
import org.apache.pinot.segment.local.recordtransformer.FilterTransformer;
import org.apache.pinot.segment.local.recordtransformer.NullValueTransformer;
import org.apache.pinot.segment.local.recordtransformer.SanitizationTransformer;
import org.apache.pinot.segment.local.recordtransformer.SchemaConformingTransformer;
import org.apache.pinot.segment.local.recordtransformer.SpecialValueTransformer;
import org.apache.pinot.segment.local.recordtransformer.TimeValidationTransformer;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.EnrichmentConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.recordtransformer.enricher.RecordEnricherRegistry;

public class CompositeTransformer
implements RecordTransformer {
    private final List<RecordTransformer> _transformers;

    public static List<RecordTransformer> getDefaultTransformers(TableConfig tableConfig, Schema schema) {
        List enrichmentConfigs;
        ArrayList<RecordTransformer> transformers = new ArrayList<RecordTransformer>();
        IngestionConfig ingestionConfig = tableConfig.getIngestionConfig();
        if (ingestionConfig != null && (enrichmentConfigs = ingestionConfig.getEnrichmentConfigs()) != null) {
            for (EnrichmentConfig enrichmentConfig : enrichmentConfigs) {
                try {
                    CompositeTransformer.addIfNotNoOp(transformers, (RecordTransformer)RecordEnricherRegistry.createRecordEnricher((EnrichmentConfig)enrichmentConfig));
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to instantiate record enricher " + enrichmentConfig.getEnricherType(), e);
                }
            }
        }
        CompositeTransformer.addIfNotNoOp(transformers, new ExpressionTransformer(tableConfig, schema));
        CompositeTransformer.addIfNotNoOp(transformers, new FilterTransformer(tableConfig));
        CompositeTransformer.addIfNotNoOp(transformers, new SchemaConformingTransformer(tableConfig, schema));
        CompositeTransformer.addIfNotNoOp(transformers, new DataTypeTransformer(tableConfig, schema));
        CompositeTransformer.addIfNotNoOp(transformers, new TimeValidationTransformer(tableConfig, schema));
        CompositeTransformer.addIfNotNoOp(transformers, new SpecialValueTransformer(schema));
        CompositeTransformer.addIfNotNoOp(transformers, new NullValueTransformer(tableConfig, schema));
        CompositeTransformer.addIfNotNoOp(transformers, new SanitizationTransformer(schema));
        return transformers;
    }

    private static void addIfNotNoOp(List<RecordTransformer> transformers, RecordTransformer transformer) {
        if (!transformer.isNoOp()) {
            transformers.add(transformer);
        }
    }

    public static CompositeTransformer getDefaultTransformer(TableConfig tableConfig, Schema schema) {
        return new CompositeTransformer(CompositeTransformer.getDefaultTransformers(tableConfig, schema));
    }

    public static CompositeTransformer composeAllTransformers(List<RecordTransformer> customTransformers, TableConfig tableConfig, Schema schema) {
        ArrayList<RecordTransformer> allTransformers = new ArrayList<RecordTransformer>(customTransformers);
        allTransformers.addAll(CompositeTransformer.getDefaultTransformers(tableConfig, schema));
        return new CompositeTransformer(allTransformers);
    }

    public static CompositeTransformer getPassThroughTransformer() {
        return new CompositeTransformer(List.of());
    }

    public CompositeTransformer(List<RecordTransformer> transformers) {
        this._transformers = transformers;
    }

    public Set<String> getInputColumns() {
        HashSet<String> inputColumns = new HashSet<String>();
        for (RecordTransformer transformer : this._transformers) {
            inputColumns.addAll(transformer.getInputColumns());
        }
        return inputColumns;
    }

    @Nullable
    public GenericRow transform(GenericRow record) {
        for (RecordTransformer transformer : this._transformers) {
            if (!IngestionUtils.shouldIngestRow(record)) {
                return record;
            }
            if ((record = transformer.transform(record)) != null) continue;
            return null;
        }
        return record;
    }
}

