/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherManager;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneDocIdCollector;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneIndexRefreshManager;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneRefreshListener;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneTextIndexSearcherPool;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.local.segment.store.TextIndexUtils;
import org.apache.pinot.segment.local.utils.LuceneTextIndexUtils;
import org.apache.pinot.segment.spi.index.TextIndexConfig;
import org.apache.pinot.segment.spi.index.mutable.MutableTextIndex;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeLuceneTextIndex
implements MutableTextIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeLuceneTextIndex.class);
    private static final RealtimeLuceneTextIndexSearcherPool SEARCHER_POOL = RealtimeLuceneTextIndexSearcherPool.getInstance();
    private final LuceneTextIndexCreator _indexCreator;
    private SearcherManager _searcherManager;
    private Analyzer _analyzer;
    private Constructor<QueryParserBase> _queryParserClassConstructor;
    private final String _column;
    private final String _segmentName;
    private final boolean _reuseMutableIndex;
    private boolean _enablePrefixSuffixMatchingInPhraseQueries = false;
    private final RealtimeLuceneRefreshListener _refreshListener;
    private final RealtimeLuceneIndexRefreshManager.SearcherManagerHolder _searcherManagerHolder;

    public RealtimeLuceneTextIndex(String column, File segmentIndexDir, String segmentName, TextIndexConfig config) {
        this._column = column;
        this._segmentName = segmentName;
        try {
            this._indexCreator = new LuceneTextIndexCreator(column, new File(segmentIndexDir.getAbsolutePath() + "/" + segmentName), false, false, null, null, config);
            IndexWriter indexWriter = this._indexCreator.getIndexWriter();
            this._searcherManager = new SearcherManager(indexWriter, false, false, null);
            LLCSegmentName llcSegmentName = new LLCSegmentName(segmentName);
            this._refreshListener = new RealtimeLuceneRefreshListener(llcSegmentName.getTableName(), segmentName, column, llcSegmentName.getPartitionGroupId(), this._indexCreator::getNumDocs);
            this._searcherManager.addListener((ReferenceManager.RefreshListener)this._refreshListener);
            this._analyzer = this._indexCreator.getIndexWriter().getConfig().getAnalyzer();
            this._queryParserClassConstructor = TextIndexUtils.getQueryParserWithStringAndAnalyzerTypeConstructor(config.getLuceneQueryParserClass());
            this._enablePrefixSuffixMatchingInPhraseQueries = config.isEnablePrefixSuffixMatchingInPhraseQueries();
            this._reuseMutableIndex = config.isReuseMutableIndex();
            this._searcherManagerHolder = new RealtimeLuceneIndexRefreshManager.SearcherManagerHolder(segmentName, column, this._searcherManager);
            RealtimeLuceneIndexRefreshManager.getInstance().addSearcherManagerHolder(this._searcherManagerHolder);
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate realtime Lucene index reader for column {}, exception {}", (Object)column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void add(String document) {
        this._indexCreator.add(document);
    }

    public void add(String[] documents) {
        this._indexCreator.add(documents, documents.length);
    }

    public ImmutableRoaringBitmap getDictIds(String searchQuery) {
        throw new UnsupportedOperationException();
    }

    public MutableRoaringBitmap getDocIds(String searchQuery) {
        MutableRoaringBitmap docIDs = new MutableRoaringBitmap();
        RealtimeLuceneDocIdCollector docIDCollector = new RealtimeLuceneDocIdCollector(docIDs);
        Callable<MutableRoaringBitmap> searchCallable = () -> {
            MutableRoaringBitmap mutableRoaringBitmap;
            IndexSearcher indexSearcher = null;
            try {
                QueryParserBase parser = this._queryParserClassConstructor.newInstance(this._column, this._analyzer);
                if (this._enablePrefixSuffixMatchingInPhraseQueries) {
                    parser.setAllowLeadingWildcard(true);
                }
                Query query = parser.parse(searchQuery);
                if (this._enablePrefixSuffixMatchingInPhraseQueries) {
                    query = LuceneTextIndexUtils.convertToMultiTermSpanQuery(query);
                }
                indexSearcher = (IndexSearcher)this._searcherManager.acquire();
                indexSearcher.search(query, (Collector)docIDCollector);
                mutableRoaringBitmap = this.getPinotDocIds(indexSearcher, docIDs);
            }
            catch (Throwable throwable) {
                try {
                    if (indexSearcher != null) {
                        this._searcherManager.release(indexSearcher);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed while releasing the searcher manager for realtime text index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
                }
                throw throwable;
            }
            try {
                if (indexSearcher != null) {
                    this._searcherManager.release((Object)indexSearcher);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed while releasing the searcher manager for realtime text index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
            }
            return mutableRoaringBitmap;
        };
        Future<MutableRoaringBitmap> searchFuture = SEARCHER_POOL.getExecutorService().submit(searchCallable);
        try {
            return searchFuture.get();
        }
        catch (InterruptedException e) {
            docIDCollector.markShouldCancel();
            LOGGER.warn("TEXT_MATCH query interrupted while querying the consuming segment {}, column {}, search query {}", new Object[]{this._segmentName, this._column, searchQuery});
            throw new RuntimeException("TEXT_MATCH query interrupted while querying the consuming segment");
        }
        catch (Exception e) {
            LOGGER.error("Failed while searching the realtime text index for segment {}, column {}, search query {}, exception {}", new Object[]{this._segmentName, this._column, searchQuery, e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    private MutableRoaringBitmap getPinotDocIds(IndexSearcher indexSearcher, MutableRoaringBitmap luceneDocIds) {
        PeekableIntIterator luceneDocIDIterator = luceneDocIds.getIntIterator();
        MutableRoaringBitmap actualDocIDs = new MutableRoaringBitmap();
        try {
            while (luceneDocIDIterator.hasNext()) {
                int luceneDocId = luceneDocIDIterator.next();
                Document document = indexSearcher.doc(luceneDocId);
                int pinotDocId = Integer.parseInt(document.get("DocID"));
                actualDocIDs.add(pinotDocId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failure while retrieving document from index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return actualDocIDs;
    }

    private Constructor<QueryParserBase> getQueryParserWithStringAndAnalyzerTypeConstructor(String queryParserClassName) throws ReflectiveOperationException {
        Class<?> queryParserClass = Class.forName(queryParserClassName);
        if (!QueryParserBase.class.isAssignableFrom(queryParserClass)) {
            throw new ReflectiveOperationException("The specified lucene query parser class " + queryParserClassName + " is not assignable from " + QueryParserBase.class.getName());
        }
        try {
            queryParserClass.getConstructor(String.class, Analyzer.class);
        }
        catch (NoSuchMethodException ex) {
            throw new NoSuchMethodException("The specified lucene query parser class " + queryParserClassName + " is not assignable because the class does not have the required constructor method with parameter type [String.class, Analyzer.class]");
        }
        return queryParserClass.getConstructor(String.class, Analyzer.class);
    }

    public void commit() {
        if (!this._reuseMutableIndex) {
            return;
        }
        try {
            this._indexCreator.getIndexWriter().commit();
            this._searcherManagerHolder.getLock().lock();
            try {
                this._searcherManagerHolder.setIndexClosed();
                this._searcherManager.maybeRefreshBlocking();
            }
            finally {
                this._searcherManagerHolder.getLock().unlock();
            }
            this._indexCreator.getIndexWriter().close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to commit the realtime lucene text index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this._searcherManagerHolder.getLock().lock();
            try {
                this._searcherManagerHolder.setIndexClosed();
            }
            finally {
                this._searcherManagerHolder.getLock().unlock();
            }
            this._searcherManager.close();
            this._searcherManager = null;
            this._refreshListener.close();
            this._indexCreator.close();
            this._analyzer.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed while closing the realtime text index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public SearcherManager getSearcherManager() {
        return this._searcherManager;
    }
}

