/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.lucene.search.SearcherManager;
import org.apache.pinot.common.utils.ScalingThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeLuceneIndexRefreshManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeLuceneIndexRefreshManager.class);
    private final int _maxParallelism;
    private int _delayMs;
    private final List<List<SearcherManagerHolder>> _partitionedListsOfSearchers;
    private static RealtimeLuceneIndexRefreshManager _singletonInstance;
    private static ExecutorService _executorService;

    private RealtimeLuceneIndexRefreshManager(int maxParallelism, int delayMs) {
        this._maxParallelism = maxParallelism;
        this._delayMs = delayMs;
        _executorService = ScalingThreadPoolExecutor.newScalingThreadPool((int)0, (int)this._maxParallelism, (long)0L);
        this._partitionedListsOfSearchers = new ArrayList<List<SearcherManagerHolder>>();
    }

    public static RealtimeLuceneIndexRefreshManager getInstance() {
        Preconditions.checkArgument((_singletonInstance != null ? 1 : 0) != 0, (Object)"RealtimeLuceneIndexRefreshManager.init() must be called first");
        return _singletonInstance;
    }

    public static RealtimeLuceneIndexRefreshManager init(int maxParallelism, int delayMs) {
        _singletonInstance = new RealtimeLuceneIndexRefreshManager(maxParallelism, delayMs);
        return _singletonInstance;
    }

    @VisibleForTesting
    public void reset() {
        this._partitionedListsOfSearchers.clear();
        _executorService.shutdownNow();
        _executorService = ScalingThreadPoolExecutor.newScalingThreadPool((int)0, (int)this._maxParallelism, (long)0L);
    }

    @VisibleForTesting
    public void setDelayMs(int delayMs) {
        this._delayMs = delayMs;
    }

    public synchronized void addSearcherManagerHolder(SearcherManagerHolder searcherManagerHolder) {
        if (this._partitionedListsOfSearchers.size() < this._maxParallelism) {
            List<SearcherManagerHolder> searcherManagers = Collections.synchronizedList(new ArrayList());
            searcherManagers.add(searcherManagerHolder);
            this._partitionedListsOfSearchers.add(searcherManagers);
            _executorService.submit(new RealtimeLuceneRefreshRunnable(searcherManagers, this._delayMs));
            return;
        }
        List<SearcherManagerHolder> smallestList = null;
        for (List<SearcherManagerHolder> list : this._partitionedListsOfSearchers) {
            if (smallestList != null && list.size() >= smallestList.size()) continue;
            smallestList = list;
        }
        assert (smallestList != null);
        smallestList.add(searcherManagerHolder);
        if (smallestList.size() == 1) {
            _executorService.submit(new RealtimeLuceneRefreshRunnable(smallestList, this._delayMs));
        }
    }

    public boolean awaitTermination() {
        _executorService.shutdownNow();
        boolean terminated = false;
        try {
            terminated = _executorService.awaitTermination(45L, TimeUnit.SECONDS);
            if (!terminated) {
                LOGGER.warn("Realtime Lucene index refresh pool did not terminate in 45 seconds.");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while waiting for realtime Lucene index refresh to shutdown.");
        }
        return terminated;
    }

    @VisibleForTesting
    public int getPoolSize() {
        return ((ThreadPoolExecutor)_executorService).getPoolSize();
    }

    @VisibleForTesting
    public List<Integer> getListSizes() {
        return this._partitionedListsOfSearchers.stream().map(List::size).sorted().collect(Collectors.toList());
    }

    private static class RealtimeLuceneRefreshRunnable
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeLuceneRefreshRunnable.class);
        private final int _delayMs;
        private final List<SearcherManagerHolder> _searchers;

        public RealtimeLuceneRefreshRunnable(List<SearcherManagerHolder> searchers, int delayMs) {
            this._searchers = searchers;
            this._delayMs = delayMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i = 0;
            while (!this._searchers.isEmpty() && i <= this._searchers.size() && !Thread.interrupted()) {
                block12: {
                    if (i == this._searchers.size()) {
                        i = 0;
                    }
                    SearcherManagerHolder searcherManagerHolder = this._searchers.get(i);
                    assert (searcherManagerHolder != null);
                    searcherManagerHolder.getLock().lock();
                    try {
                        if (searcherManagerHolder.isIndexClosed()) {
                            this._searchers.remove(i);
                            continue;
                        }
                        if (searcherManagerHolder.isIndexClosed()) break block12;
                        try {
                            searcherManagerHolder.getSearcherManager().maybeRefresh();
                        }
                        catch (Exception e) {
                            LOGGER.warn("Caught exception {} while refreshing realtime lucene reader for segment: {} and column: {}", new Object[]{e, searcherManagerHolder.getSegmentName(), searcherManagerHolder.getColumnName()});
                        }
                        ++i;
                    }
                    finally {
                        searcherManagerHolder.getLock().unlock();
                        continue;
                    }
                }
                try {
                    Thread.sleep(this._delayMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static class SearcherManagerHolder {
        private final String _segmentName;
        private final String _columnName;
        private final Lock _lock;
        private volatile boolean _indexClosed;
        private final SearcherManager _searcherManager;

        public SearcherManagerHolder(String segmentName, String columnName, SearcherManager searcherManager) {
            this._segmentName = segmentName;
            this._columnName = columnName;
            this._lock = new ReentrantLock();
            this._indexClosed = false;
            this._searcherManager = searcherManager;
        }

        public void setIndexClosed() {
            this._indexClosed = true;
        }

        public Lock getLock() {
            return this._lock;
        }

        public String getSegmentName() {
            return this._segmentName;
        }

        public String getColumnName() {
            return this._columnName;
        }

        public SearcherManager getSearcherManager() {
            return this._searcherManager;
        }

        public boolean isIndexClosed() {
            return this._indexClosed;
        }
    }
}

