/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.NRTCachingDirectory;

public class LuceneNRTCachingMergePolicy
extends TieredMergePolicy {
    private final NRTCachingDirectory _nrtCachingDirectory;

    public LuceneNRTCachingMergePolicy(NRTCachingDirectory nrtCachingDirectory) {
        this._nrtCachingDirectory = nrtCachingDirectory;
    }

    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        SegmentInfos inMemorySegmentInfos = new SegmentInfos(segmentInfos.getIndexCreatedVersionMajor());
        HashSet<String> cachedFiles = new HashSet<String>(List.of(this._nrtCachingDirectory.listCachedFiles()));
        for (SegmentCommitInfo info : segmentInfos) {
            String file;
            Iterator iterator = info.files().iterator();
            while (iterator.hasNext() && cachedFiles.contains(file = (String)iterator.next())) {
            }
            inMemorySegmentInfos.add(info);
        }
        return super.findMerges(mergeTrigger, inMemorySegmentInfos, mergeContext);
    }
}

