/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.forward;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.pinot.segment.local.io.writer.impl.MutableOffHeapByteArrayStore;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.MapUtils;

public class VarByteSVMutableForwardIndex
implements MutableForwardIndex {
    private final FieldSpec.DataType _storedType;
    private final MutableOffHeapByteArrayStore _byteArrayStore;
    private int _lengthOfShortestElement;
    private int _lengthOfLongestElement;

    public VarByteSVMutableForwardIndex(FieldSpec.DataType storedType, PinotDataBufferMemoryManager memoryManager, String allocationContext, int estimatedMaxNumberOfValues, int estimatedAverageStringLength) {
        this._storedType = storedType;
        this._byteArrayStore = new MutableOffHeapByteArrayStore(memoryManager, allocationContext, estimatedMaxNumberOfValues, estimatedAverageStringLength);
        this._lengthOfShortestElement = Integer.MAX_VALUE;
        this._lengthOfLongestElement = Integer.MIN_VALUE;
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return this._storedType;
    }

    public int getLengthOfShortestElement() {
        return this._lengthOfShortestElement;
    }

    public int getLengthOfLongestElement() {
        return this._lengthOfLongestElement;
    }

    public BigDecimal getBigDecimal(int docId) {
        return BigDecimalUtils.deserialize((byte[])this._byteArrayStore.get(docId));
    }

    public String getString(int docId) {
        return new String(this._byteArrayStore.get(docId), StandardCharsets.UTF_8);
    }

    public byte[] getBytes(int docId) {
        return this._byteArrayStore.get(docId);
    }

    public Map<String, Object> getMap(int docId, ForwardIndexReaderContext context) {
        return MapUtils.deserializeMap((byte[])this.getBytes(docId));
    }

    public void setBigDecimal(int docId, BigDecimal value) {
        this.setBytes(docId, BigDecimalUtils.serialize((BigDecimal)value));
    }

    public void setString(int docId, String value) {
        this.setBytes(docId, value.getBytes(StandardCharsets.UTF_8));
    }

    public void setBytes(int docId, byte[] value) {
        this._byteArrayStore.add(value);
        this._lengthOfLongestElement = Math.max(this._lengthOfLongestElement, value.length);
        this._lengthOfShortestElement = Math.min(this._lengthOfShortestElement, value.length);
    }

    public void close() throws IOException {
        this._byteArrayStore.close();
    }
}

