/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.converter;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.segment.local.realtime.converter.stats.RealtimeSegmentSegmentCreationDataSource;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.SegmentZKPropsConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class RealtimeSegmentConverter {
    private final MutableSegmentImpl _realtimeSegmentImpl;
    private final SegmentZKPropsConfig _segmentZKPropsConfig;
    private final String _outputPath;
    private final Schema _dataSchema;
    private final String _tableName;
    private final TableConfig _tableConfig;
    private final String _segmentName;
    private final boolean _nullHandlingEnabled;
    private final boolean _enableColumnMajor;

    public RealtimeSegmentConverter(MutableSegmentImpl realtimeSegment, SegmentZKPropsConfig segmentZKPropsConfig, String outputPath, Schema schema, String tableName, TableConfig tableConfig, String segmentName, boolean nullHandlingEnabled) {
        this._realtimeSegmentImpl = realtimeSegment;
        this._segmentZKPropsConfig = segmentZKPropsConfig;
        this._outputPath = outputPath;
        this._dataSchema = RealtimeSegmentConverter.getUpdatedSchema(schema);
        this._tableName = tableName;
        this._tableConfig = tableConfig;
        this._segmentName = segmentName;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._enableColumnMajor = this._tableConfig.getIngestionConfig() != null && this._tableConfig.getIngestionConfig().getStreamIngestionConfig() != null ? this._tableConfig.getIngestionConfig().getStreamIngestionConfig().getColumnMajorSegmentBuilderEnabled() : this._tableConfig.getIndexingConfig().isColumnMajorSegmentBuilderEnabled();
    }

    public void build(@Nullable SegmentVersion segmentVersion, ServerMetrics serverMetrics) throws Exception {
        SegmentGeneratorConfig genConfig = new SegmentGeneratorConfig(this._tableConfig, this._dataSchema, true);
        genConfig.setSegmentTimeValueCheck(false);
        if (segmentVersion != null) {
            genConfig.setSegmentVersion(segmentVersion);
        }
        genConfig.setTableName(this._tableName);
        genConfig.setOutDir(this._outputPath);
        genConfig.setSegmentName(this._segmentName);
        SegmentPartitionConfig segmentPartitionConfig = this._realtimeSegmentImpl.getSegmentPartitionConfig();
        genConfig.setSegmentPartitionConfig(segmentPartitionConfig);
        genConfig.setDefaultNullHandlingEnabled(this._nullHandlingEnabled);
        genConfig.setSegmentZKPropsConfig(this._segmentZKPropsConfig);
        this._realtimeSegmentImpl.commit();
        SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
        try (PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();){
            String sortedColumn = null;
            List columnSortOrder = genConfig.getColumnSortOrder();
            if (CollectionUtils.isNotEmpty((Collection)columnSortOrder)) {
                sortedColumn = (String)columnSortOrder.get(0);
            }
            int[] sortedDocIds = sortedColumn != null ? this._realtimeSegmentImpl.getSortedDocIdIterationOrderWithSortedColumn(sortedColumn) : null;
            recordReader.init(this._realtimeSegmentImpl, sortedDocIds);
            RealtimeSegmentSegmentCreationDataSource dataSource = new RealtimeSegmentSegmentCreationDataSource(this._realtimeSegmentImpl, recordReader);
            driver.init(genConfig, dataSource, TransformPipeline.getPassThroughPipeline());
            if (!this._enableColumnMajor) {
                driver.build();
            } else {
                driver.buildByColumn((IndexSegment)this._realtimeSegmentImpl);
            }
        }
        if (segmentPartitionConfig != null) {
            Map columnPartitionMap = segmentPartitionConfig.getColumnPartitionMap();
            for (String columnName : columnPartitionMap.keySet()) {
                int numPartitions = driver.getSegmentStats().getColumnProfileFor(columnName).getPartitions().size();
                serverMetrics.addValueToTableGauge(this._tableName, (AbstractMetrics.Gauge)ServerGauge.REALTIME_SEGMENT_NUM_PARTITIONS, (long)numPartitions);
            }
        }
    }

    @VisibleForTesting
    public static Schema getUpdatedSchema(Schema original) {
        return original.withoutVirtualColumns();
    }

    public boolean isColumnMajorEnabled() {
        return this._enableColumnMajor;
    }
}

