/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import java.io.File;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.segment.local.io.writer.impl.BaseChunkForwardIndexWriter;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;

@NotThreadSafe
public class FixedByteChunkForwardIndexWriter
extends BaseChunkForwardIndexWriter {
    private int _chunkDataOffset = 0;

    public FixedByteChunkForwardIndexWriter(File file, ChunkCompressionType compressionType, int totalDocs, int numDocsPerChunk, int sizeOfEntry, int writerVersion) throws IOException {
        super(file, compressionType, totalDocs, FixedByteChunkForwardIndexWriter.normalizeDocsPerChunk(writerVersion, numDocsPerChunk), (long)sizeOfEntry * (long)FixedByteChunkForwardIndexWriter.normalizeDocsPerChunk(writerVersion, numDocsPerChunk), sizeOfEntry, writerVersion, true);
    }

    public void putInt(int value) {
        this._chunkBuffer.putInt(value);
        this._chunkDataOffset += 4;
        this.flushChunkIfNeeded();
    }

    public void putLong(long value) {
        this._chunkBuffer.putLong(value);
        this._chunkDataOffset += 8;
        this.flushChunkIfNeeded();
    }

    public void putFloat(float value) {
        this._chunkBuffer.putFloat(value);
        this._chunkDataOffset += 4;
        this.flushChunkIfNeeded();
    }

    public void putDouble(double value) {
        this._chunkBuffer.putDouble(value);
        this._chunkDataOffset += 8;
        this.flushChunkIfNeeded();
    }

    @Override
    protected void writeChunk() {
        super.writeChunk();
        this._chunkDataOffset = 0;
    }

    private void flushChunkIfNeeded() {
        if (this._chunkDataOffset == this._chunkSize) {
            this.writeChunk();
        }
    }

    private static int normalizeDocsPerChunk(int version, int numDocsPerChunk) {
        if (version >= 4 && (numDocsPerChunk & numDocsPerChunk - 1) != 0) {
            return 1 << 32 - Integer.numberOfLeadingZeros(numDocsPerChunk - 1);
        }
        return numDocsPerChunk;
    }
}

