/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.pinot.segment.local.io.compression.ChunkCompressorFactory;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChunkForwardIndexWriter
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseChunkForwardIndexWriter.class);
    protected final FileChannel _dataFile;
    protected ByteBuffer _header;
    protected final ByteBuffer _chunkBuffer;
    protected final ByteBuffer _compressedBuffer;
    protected final ChunkCompressor _chunkCompressor;
    protected int _chunkSize;
    protected long _dataOffset;
    private final int _headerEntryChunkOffsetSize;

    protected BaseChunkForwardIndexWriter(File file, ChunkCompressionType compressionType, int totalDocs, int numDocsPerChunk, long chunkSize, int sizeOfEntry, int version, boolean fixed) throws IOException {
        Preconditions.checkArgument((version == 2 || version == 3 || fixed && (version == 4 || version == 5) ? 1 : 0) != 0, (String)"Illegal version: %s for %s bytes values", (int)version, (Object)(fixed ? "fixed" : "variable"));
        Preconditions.checkArgument((chunkSize <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Chunk size limited to 2GB");
        this._chunkSize = (int)chunkSize;
        this._chunkCompressor = ChunkCompressorFactory.getCompressor(compressionType);
        this._headerEntryChunkOffsetSize = version == 2 ? 4 : 8;
        this._dataOffset = this.writeHeader(compressionType, totalDocs, numDocsPerChunk, sizeOfEntry, version);
        this._chunkBuffer = ByteBuffer.allocateDirect(this._chunkSize);
        int maxCompressedChunkSize = this._chunkCompressor.maxCompressedSize(this._chunkSize);
        this._compressedBuffer = ByteBuffer.allocateDirect(maxCompressedChunkSize);
        this._dataFile = new RandomAccessFile(file, "rw").getChannel();
    }

    @Override
    public void close() throws IOException {
        if (this._chunkBuffer.position() > 0) {
            this.writeChunk();
        }
        this._header.flip();
        this._dataFile.write(this._header, 0L);
        this._dataFile.close();
        this._chunkCompressor.close();
    }

    private int writeHeader(ChunkCompressionType compressionType, int totalDocs, int numDocsPerChunk, int sizeOfEntry, int version) {
        int numChunks = (totalDocs + numDocsPerChunk - 1) / numDocsPerChunk;
        int headerSize = 28 + numChunks * this._headerEntryChunkOffsetSize;
        this._header = ByteBuffer.allocateDirect(headerSize);
        int offset = 0;
        this._header.putInt(version);
        offset += 4;
        this._header.putInt(numChunks);
        offset += 4;
        this._header.putInt(numDocsPerChunk);
        offset += 4;
        this._header.putInt(sizeOfEntry);
        offset += 4;
        this._header.putInt(totalDocs);
        offset += 4;
        this._header.putInt(compressionType.getValue());
        int dataHeaderStart = (offset += 4) + 4;
        this._header.putInt(dataHeaderStart);
        return headerSize;
    }

    protected void writeChunk() {
        int sizeToWrite;
        this._chunkBuffer.flip();
        try {
            sizeToWrite = this._chunkCompressor.compress(this._chunkBuffer, this._compressedBuffer);
            this._dataFile.write(this._compressedBuffer, this._dataOffset);
            this._compressedBuffer.clear();
        }
        catch (IOException e) {
            LOGGER.error("Exception caught while compressing/writing data chunk", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (this._headerEntryChunkOffsetSize == 4) {
            Preconditions.checkState((this._dataOffset <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Integer overflow detected. Try to use raw version 3 or 4, reduce targetDocsPerChunk or targetMaxChunkSize");
            this._header.putInt((int)this._dataOffset);
        } else if (this._headerEntryChunkOffsetSize == 8) {
            this._header.putLong(this._dataOffset);
        }
        this._dataOffset += (long)sizeToWrite;
        this._chunkBuffer.clear();
    }
}

