/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4DecompressorWithLength;
import org.apache.pinot.segment.local.io.compression.LZ4Compressor;
import org.apache.pinot.segment.spi.compression.ChunkDecompressor;

class LZ4WithLengthDecompressor
implements ChunkDecompressor {
    static final LZ4WithLengthDecompressor INSTANCE = new LZ4WithLengthDecompressor();
    private final LZ4DecompressorWithLength _decompressor = new LZ4DecompressorWithLength(LZ4Compressor.LZ4_FACTORY.safeDecompressor());

    private LZ4WithLengthDecompressor() {
    }

    public int decompress(ByteBuffer compressedInput, ByteBuffer decompressedOutput) throws IOException {
        this._decompressor.decompress(compressedInput, decompressedOutput);
        decompressedOutput.flip();
        return decompressedOutput.limit();
    }

    public int decompressedLength(ByteBuffer compressedInput) {
        return LZ4DecompressorWithLength.getDecompressedLength((ByteBuffer)compressedInput);
    }
}

