/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.function;

import javax.annotation.Nullable;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.segment.local.function.GroovyFunctionEvaluator;
import org.apache.pinot.segment.local.function.InbuiltFunctionEvaluator;
import org.apache.pinot.segment.local.function.TimeSpecFunctionEvaluator;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.apache.pinot.spi.data.TimeGranularitySpec;

public class FunctionEvaluatorFactory {
    private FunctionEvaluatorFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static FunctionEvaluator getExpressionEvaluator(FieldSpec fieldSpec) {
        FunctionEvaluator functionEvaluator = null;
        String columnName = fieldSpec.getName();
        String transformExpression = fieldSpec.getTransformFunction();
        if (transformExpression != null && !transformExpression.isEmpty()) {
            try {
                return FunctionEvaluatorFactory.getExpressionEvaluator(transformExpression);
            }
            catch (Exception e) {
                throw new IllegalStateException("Caught exception while constructing expression evaluator for transform expression:" + transformExpression + ", of column:" + columnName);
            }
        }
        if (fieldSpec.getFieldType() == FieldSpec.FieldType.TIME) {
            TimeGranularitySpec outgoingGranularitySpec;
            TimeFieldSpec timeFieldSpec = (TimeFieldSpec)fieldSpec;
            TimeGranularitySpec incomingGranularitySpec = timeFieldSpec.getIncomingGranularitySpec();
            if (incomingGranularitySpec.equals((Object)(outgoingGranularitySpec = timeFieldSpec.getOutgoingGranularitySpec()))) return functionEvaluator;
            if (incomingGranularitySpec.getName().equals(outgoingGranularitySpec.getName())) throw new IllegalStateException("Invalid timeSpec - Incoming and outgoing field specs are different, but name " + incomingGranularitySpec.getName() + " is same");
            return new TimeSpecFunctionEvaluator(incomingGranularitySpec, outgoingGranularitySpec);
        }
        if (columnName.endsWith("__KEYS")) {
            String sourceMapName = columnName.substring(0, columnName.length() - "__KEYS".length());
            String defaultMapKeysTransformExpression = FunctionEvaluatorFactory.getDefaultMapKeysTransformExpression(sourceMapName);
            return FunctionEvaluatorFactory.getExpressionEvaluator(defaultMapKeysTransformExpression);
        }
        if (!columnName.endsWith("__VALUES")) return functionEvaluator;
        String sourceMapName = columnName.substring(0, columnName.length() - "__VALUES".length());
        String defaultMapValuesTransformExpression = FunctionEvaluatorFactory.getDefaultMapValuesTransformExpression(sourceMapName);
        return FunctionEvaluatorFactory.getExpressionEvaluator(defaultMapValuesTransformExpression);
    }

    public static FunctionEvaluator getExpressionEvaluator(String transformExpression) {
        if (FunctionEvaluatorFactory.isGroovyExpression(transformExpression)) {
            return new GroovyFunctionEvaluator(transformExpression);
        }
        return new InbuiltFunctionEvaluator(transformExpression);
    }

    public static boolean isGroovyExpression(String transformExpression) {
        return transformExpression.startsWith(GroovyFunctionEvaluator.getGroovyExpressionPrefix());
    }

    private static String getDefaultMapKeysTransformExpression(String mapColumnName) {
        return String.format("Groovy({%s.sort()*.key}, %s)", mapColumnName, mapColumnName);
    }

    private static String getDefaultMapValuesTransformExpression(String mapColumnName) {
        return String.format("Groovy({%s.sort()*.value}, %s)", mapColumnName, mapColumnName);
    }
}

