/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.dedup;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.dedup.ConcurrentMapTableDedupMetadataManager;
import org.apache.pinot.segment.local.dedup.TableDedupMetadataManager;
import org.apache.pinot.spi.config.table.DedupConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDedupMetadataManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDedupMetadataManagerFactory.class);
    public static final String DEDUP_DEFAULT_METADATA_MANAGER_CLASS = "default.metadata.manager.class";
    public static final String DEDUP_DEFAULT_ENABLE_PRELOAD = "default.enable.preload";

    private TableDedupMetadataManagerFactory() {
    }

    public static TableDedupMetadataManager create(TableConfig tableConfig, Schema schema, TableDataManager tableDataManager, ServerMetrics serverMetrics, @Nullable PinotConfiguration instanceDedupConfig) {
        TableDedupMetadataManager metadataManager;
        String tableNameWithType = tableConfig.getTableName();
        DedupConfig dedupConfig = tableConfig.getDedupConfig();
        Preconditions.checkArgument((dedupConfig != null ? 1 : 0) != 0, (String)"Must provide dedup config for table: %s", (Object)tableNameWithType);
        String metadataManagerClass = dedupConfig.getMetadataManagerClass();
        if (instanceDedupConfig != null) {
            if (metadataManagerClass == null) {
                metadataManagerClass = instanceDedupConfig.getProperty(DEDUP_DEFAULT_METADATA_MANAGER_CLASS);
            }
            if (!dedupConfig.isEnablePreload()) {
                dedupConfig.setEnablePreload(Boolean.parseBoolean(instanceDedupConfig.getProperty(DEDUP_DEFAULT_ENABLE_PRELOAD, "false")));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)metadataManagerClass)) {
            LOGGER.info("Creating TableDedupMetadataManager with class: {} for table: {}", (Object)metadataManagerClass, (Object)tableNameWithType);
            try {
                metadataManager = (TableDedupMetadataManager)Class.forName(metadataManagerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Caught exception while constructing TableDedupMetadataManager with class: %s for table: %s", metadataManagerClass, tableNameWithType), e);
            }
        } else {
            LOGGER.info("Creating ConcurrentMapTableDedupMetadataManager for table: {}", (Object)tableNameWithType);
            metadataManager = new ConcurrentMapTableDedupMetadataManager();
        }
        metadataManager.init(tableConfig, schema, tableDataManager, serverMetrics);
        return metadataManager;
    }
}

