/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.dedup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class DedupContext {
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final List<String> _primaryKeyColumns;
    private final HashFunction _hashFunction;
    private final boolean _enablePreload;
    private final double _metadataTTL;
    private final String _dedupTimeColumn;
    private final File _tableIndexDir;
    private final TableDataManager _tableDataManager;

    private DedupContext(TableConfig tableConfig, Schema schema, List<String> primaryKeyColumns, HashFunction hashFunction, boolean enablePreload, double metadataTTL, String dedupTimeColumn, File tableIndexDir, TableDataManager tableDataManager) {
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._primaryKeyColumns = primaryKeyColumns;
        this._hashFunction = hashFunction;
        this._enablePreload = enablePreload;
        this._metadataTTL = metadataTTL;
        this._dedupTimeColumn = dedupTimeColumn;
        this._tableIndexDir = tableIndexDir;
        this._tableDataManager = tableDataManager;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public List<String> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    public HashFunction getHashFunction() {
        return this._hashFunction;
    }

    public boolean isPreloadEnabled() {
        return this._enablePreload;
    }

    public double getMetadataTTL() {
        return this._metadataTTL;
    }

    public String getDedupTimeColumn() {
        return this._dedupTimeColumn;
    }

    public File getTableIndexDir() {
        return this._tableIndexDir;
    }

    public TableDataManager getTableDataManager() {
        return this._tableDataManager;
    }

    public static class Builder {
        private TableConfig _tableConfig;
        private Schema _schema;
        private List<String> _primaryKeyColumns;
        private HashFunction _hashFunction;
        private boolean _enablePreload;
        private double _metadataTTL;
        private String _dedupTimeColumn;
        private File _tableIndexDir;
        private TableDataManager _tableDataManager;

        public Builder setTableConfig(TableConfig tableConfig) {
            this._tableConfig = tableConfig;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this._schema = schema;
            return this;
        }

        public Builder setPrimaryKeyColumns(List<String> primaryKeyColumns) {
            this._primaryKeyColumns = primaryKeyColumns;
            return this;
        }

        public Builder setHashFunction(HashFunction hashFunction) {
            this._hashFunction = hashFunction;
            return this;
        }

        public Builder setEnablePreload(boolean enablePreload) {
            this._enablePreload = enablePreload;
            return this;
        }

        public Builder setMetadataTTL(double metadataTTL) {
            this._metadataTTL = metadataTTL;
            return this;
        }

        public Builder setDedupTimeColumn(String deupTimeColumn) {
            this._dedupTimeColumn = deupTimeColumn;
            return this;
        }

        public Builder setTableIndexDir(File tableIndexDir) {
            this._tableIndexDir = tableIndexDir;
            return this;
        }

        public Builder setTableDataManager(TableDataManager tableDataManager) {
            this._tableDataManager = tableDataManager;
            return this;
        }

        public DedupContext build() {
            Preconditions.checkState((this._tableConfig != null ? 1 : 0) != 0, (Object)"Table config must be set");
            Preconditions.checkState((this._schema != null ? 1 : 0) != 0, (Object)"Schema must be set");
            Preconditions.checkState((boolean)CollectionUtils.isNotEmpty(this._primaryKeyColumns), (Object)"Primary key columns must be set");
            Preconditions.checkState((this._hashFunction != null ? 1 : 0) != 0, (Object)"Hash function must be set");
            Preconditions.checkState((this._tableIndexDir != null ? 1 : 0) != 0, (Object)"Table index directory must be set");
            return new DedupContext(this._tableConfig, this._schema, this._primaryKeyColumns, this._hashFunction, this._enablePreload, this._metadataTTL, this._dedupTimeColumn, this._tableIndexDir, this._tableDataManager);
        }
    }
}

