/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.data.manager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.StaleSegment;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.utils.SegmentLocks;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

@ThreadSafe
public interface TableDataManager {
    public void init(InstanceDataManagerConfig var1, HelixManager var2, SegmentLocks var3, TableConfig var4, @Nullable ExecutorService var5, @Nullable Cache<Pair<String, String>, SegmentErrorInfo> var6);

    public String getInstanceId();

    public InstanceDataManagerConfig getInstanceDataManagerConfig();

    public void start();

    public void shutDown();

    public boolean isShutDown();

    public Lock getSegmentLock(String var1);

    public boolean hasSegment(String var1);

    @VisibleForTesting
    public void addSegment(ImmutableSegment var1);

    public void addOnlineSegment(String var1) throws Exception;

    public void addNewOnlineSegment(SegmentZKMetadata var1, IndexLoadingConfig var2) throws Exception;

    public boolean tryLoadExistingSegment(SegmentZKMetadata var1, IndexLoadingConfig var2);

    public boolean needReloadSegments() throws Exception;

    public void downloadAndLoadSegment(SegmentZKMetadata var1, IndexLoadingConfig var2) throws Exception;

    public void addConsumingSegment(String var1) throws Exception;

    public void replaceSegment(String var1) throws Exception;

    public void offloadSegment(String var1) throws Exception;

    public void offloadSegmentUnsafe(String var1) throws Exception;

    public void reloadSegment(String var1, IndexLoadingConfig var2, SegmentZKMetadata var3, SegmentMetadata var4, @Nullable Schema var5, boolean var6) throws Exception;

    public File getSegmentDataDir(String var1, @Nullable String var2, TableConfig var3);

    public boolean isSegmentDeletedRecently(String var1);

    public List<SegmentDataManager> acquireAllSegments();

    public List<SegmentDataManager> acquireSegments(List<String> var1, List<String> var2);

    default public List<SegmentDataManager> acquireSegments(List<String> segmentNames, @Nullable List<String> optionalSegmentNames, List<String> missingSegments) {
        return this.acquireSegments(segmentNames, missingSegments);
    }

    @Nullable
    public SegmentDataManager acquireSegment(String var1);

    public void releaseSegment(SegmentDataManager var1);

    public int getNumSegments();

    public String getTableName();

    public File getTableDataDir();

    public HelixManager getHelixManager();

    public ExecutorService getSegmentPreloadExecutor();

    public void addSegmentError(String var1, SegmentErrorInfo var2);

    public Map<String, SegmentErrorInfo> getSegmentErrors();

    public List<SegmentContext> getSegmentContexts(List<IndexSegment> var1, Map<String, String> var2);

    public SegmentZKMetadata fetchZKMetadata(String var1);

    public Pair<TableConfig, Schema> fetchTableConfigAndSchema();

    default public IndexLoadingConfig fetchIndexLoadingConfig() {
        Pair<TableConfig, Schema> tableConfigSchemaPair = this.fetchTableConfigAndSchema();
        return this.getIndexLoadingConfig((TableConfig)tableConfigSchemaPair.getLeft(), (Schema)tableConfigSchemaPair.getRight());
    }

    public IndexLoadingConfig getIndexLoadingConfig(TableConfig var1, @Nullable Schema var2);

    default public void onConsumingToDropped(String segmentNameStr) {
    }

    default public void onConsumingToOnline(String segmentNameStr) {
    }

    public List<StaleSegment> getStaleSegments(TableConfig var1, Schema var2);
}

