/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import java.util.List;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.segment.local.aggregator.AvgValueAggregator;
import org.apache.pinot.segment.local.aggregator.CountValueAggregator;
import org.apache.pinot.segment.local.aggregator.DistinctCountBitmapValueAggregator;
import org.apache.pinot.segment.local.aggregator.DistinctCountCPCSketchValueAggregator;
import org.apache.pinot.segment.local.aggregator.DistinctCountHLLPlusValueAggregator;
import org.apache.pinot.segment.local.aggregator.DistinctCountHLLValueAggregator;
import org.apache.pinot.segment.local.aggregator.DistinctCountThetaSketchValueAggregator;
import org.apache.pinot.segment.local.aggregator.DistinctCountULLValueAggregator;
import org.apache.pinot.segment.local.aggregator.IntegerTupleSketchValueAggregator;
import org.apache.pinot.segment.local.aggregator.MaxValueAggregator;
import org.apache.pinot.segment.local.aggregator.MinMaxRangeValueAggregator;
import org.apache.pinot.segment.local.aggregator.MinValueAggregator;
import org.apache.pinot.segment.local.aggregator.PercentileEstValueAggregator;
import org.apache.pinot.segment.local.aggregator.PercentileTDigestValueAggregator;
import org.apache.pinot.segment.local.aggregator.SumPrecisionValueAggregator;
import org.apache.pinot.segment.local.aggregator.SumValueAggregator;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class ValueAggregatorFactory {
    private ValueAggregatorFactory() {
    }

    public static ValueAggregator getValueAggregator(AggregationFunctionType aggregationType, List<ExpressionContext> arguments) {
        switch (aggregationType) {
            case COUNT: {
                return new CountValueAggregator();
            }
            case MIN: {
                return new MinValueAggregator();
            }
            case MAX: {
                return new MaxValueAggregator();
            }
            case SUM: {
                return new SumValueAggregator();
            }
            case SUMPRECISION: {
                return new SumPrecisionValueAggregator(arguments);
            }
            case AVG: {
                return new AvgValueAggregator();
            }
            case MINMAXRANGE: {
                return new MinMaxRangeValueAggregator();
            }
            case DISTINCTCOUNTBITMAP: {
                return new DistinctCountBitmapValueAggregator();
            }
            case DISTINCTCOUNTHLL: 
            case DISTINCTCOUNTRAWHLL: {
                return new DistinctCountHLLValueAggregator(arguments);
            }
            case PERCENTILEEST: 
            case PERCENTILERAWEST: {
                return new PercentileEstValueAggregator();
            }
            case PERCENTILETDIGEST: 
            case PERCENTILERAWTDIGEST: {
                return new PercentileTDigestValueAggregator(arguments);
            }
            case DISTINCTCOUNTTHETASKETCH: 
            case DISTINCTCOUNTRAWTHETASKETCH: {
                return new DistinctCountThetaSketchValueAggregator(arguments);
            }
            case DISTINCTCOUNTHLLPLUS: 
            case DISTINCTCOUNTRAWHLLPLUS: {
                return new DistinctCountHLLPlusValueAggregator(arguments);
            }
            case DISTINCTCOUNTTUPLESKETCH: 
            case DISTINCTCOUNTRAWINTEGERSUMTUPLESKETCH: 
            case AVGVALUEINTEGERSUMTUPLESKETCH: 
            case SUMVALUESINTEGERSUMTUPLESKETCH: {
                return new IntegerTupleSketchValueAggregator(arguments, IntegerSummary.Mode.Sum);
            }
            case DISTINCTCOUNTCPCSKETCH: 
            case DISTINCTCOUNTRAWCPCSKETCH: {
                return new DistinctCountCPCSketchValueAggregator(arguments);
            }
            case DISTINCTCOUNTULL: 
            case DISTINCTCOUNTRAWULL: {
                return new DistinctCountULLValueAggregator(arguments);
            }
        }
        throw new IllegalStateException("Unsupported aggregation type: " + aggregationType);
    }

    public static FieldSpec.DataType getAggregatedValueType(AggregationFunctionType aggregationType) {
        switch (aggregationType) {
            case COUNT: {
                return CountValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case MIN: {
                return MinValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case MAX: {
                return MaxValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case SUM: {
                return SumValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case SUMPRECISION: {
                return SumPrecisionValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case AVG: {
                return AvgValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case MINMAXRANGE: {
                return MinMaxRangeValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTBITMAP: {
                return DistinctCountBitmapValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTHLL: 
            case DISTINCTCOUNTRAWHLL: {
                return DistinctCountHLLValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case PERCENTILEEST: 
            case PERCENTILERAWEST: {
                return PercentileEstValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case PERCENTILETDIGEST: 
            case PERCENTILERAWTDIGEST: {
                return PercentileTDigestValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTTHETASKETCH: 
            case DISTINCTCOUNTRAWTHETASKETCH: {
                return DistinctCountThetaSketchValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTHLLPLUS: 
            case DISTINCTCOUNTRAWHLLPLUS: {
                return DistinctCountHLLPlusValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTTUPLESKETCH: 
            case DISTINCTCOUNTRAWINTEGERSUMTUPLESKETCH: 
            case AVGVALUEINTEGERSUMTUPLESKETCH: 
            case SUMVALUESINTEGERSUMTUPLESKETCH: {
                return IntegerTupleSketchValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTCPCSKETCH: 
            case DISTINCTCOUNTRAWCPCSKETCH: {
                return DistinctCountCPCSketchValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTULL: 
            case DISTINCTCOUNTRAWULL: {
                return DistinctCountULLValueAggregator.AGGREGATED_VALUE_TYPE;
            }
        }
        throw new IllegalStateException("Unsupported aggregation type: " + aggregationType);
    }
}

